/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.refactorinsight.common.data;

import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.research.refactorinsight.common.adapters.CodeRange;
import org.jetbrains.research.refactorinsight.common.data.Group;
import org.jetbrains.research.refactorinsight.common.data.RefactoringEntry;
import org.jetbrains.research.refactorinsight.common.data.RefactoringLine;
import org.jetbrains.research.refactorinsight.common.data.RefactoringType;
import org.jetbrains.research.refactorinsight.common.diff.DiffRequestGenerator;
import org.jetbrains.research.refactorinsight.common.diff.MoreSidedDiffRequestGenerator;
import org.jetbrains.research.refactorinsight.common.diff.ThreeSidedDiffRequestGenerator;
import org.jetbrains.research.refactorinsight.common.diff.TwoSidedDiffRequestGenerator;
import org.jetbrains.research.refactorinsight.common.diff.VisualizationType;
import org.jetbrains.research.refactorinsight.common.utils.Utils;

public class RefactoringInfo {
    private transient RefactoringEntry entry;
    private transient String groupId;
    private transient List<Pair<String, Boolean>> moreSidedLeftPaths = new ArrayList<Pair<String, Boolean>>();
    private DiffRequestGenerator requestGenerator = new TwoSidedDiffRequestGenerator();
    private final String[][] uiStrings = new String[3][2];
    private final String[] paths = new String[3];
    private RefactoringType type;
    private Group group;
    private Set<String> includes = new HashSet<String>();
    private boolean hidden = false;
    private boolean threeSided = false;
    private boolean moreSided = false;
    private boolean changed = true;

    public RefactoringInfo(RefactoringEntry entry, RefactoringType type) {
        this.entry = entry;
        this.type = type;
    }

    public RefactoringInfo setIncludes(Set<String> includes) {
        this.includes = includes;
        return this;
    }

    public RefactoringInfo addMarking(CodeRange left, CodeRange right, boolean hasColumns) {
        return this.addMarking(left, null, right, VisualizationType.TWO, null, RefactoringLine.MarkingOption.NONE, hasColumns);
    }

    public RefactoringInfo addMarking(CodeRange left, CodeRange right, Consumer<RefactoringLine> offsetFunction, RefactoringLine.MarkingOption option, boolean hasColumns) {
        return this.addMarking(left, null, right, VisualizationType.TWO, offsetFunction, option, hasColumns);
    }

    public RefactoringInfo addMarking(CodeRange left, CodeRange mid, CodeRange right, VisualizationType type, Consumer<RefactoringLine> offsetFunction, RefactoringLine.MarkingOption option, boolean hasColumns) {
        this.requestGenerator.addMarking(left, mid, right, type, offsetFunction, option, hasColumns);
        if (left != null) {
            this.setLeftPath(left.getFilePath());
            if (this.moreSided) {
                this.moreSidedLeftPaths.add((Pair<String, Boolean>)new Pair((Object)left.getFilePath(), (Object)true));
            }
        }
        if (mid != null) {
            this.setMidPath(mid.getFilePath());
        }
        if (right != null) {
            this.setRightPath(right.getFilePath());
        }
        return this;
    }

    public void addAllMarkings(RefactoringInfo info) {
        this.requestGenerator.getMarkings().addAll(info.getLineMarkings());
    }

    public void addIncludedRefactoring(String refactoring) {
        this.includes.add(refactoring);
    }

    public List<RefactoringLine> getLineMarkings() {
        return this.requestGenerator.getMarkings();
    }

    public boolean isThreeSided() {
        return this.threeSided;
    }

    public RefactoringInfo setThreeSided(boolean threeSided) {
        this.threeSided = threeSided;
        if (threeSided) {
            this.requestGenerator = new ThreeSidedDiffRequestGenerator();
        }
        return this;
    }

    public boolean isMoreSided() {
        return this.moreSided;
    }

    public RefactoringInfo setMoreSided(boolean moreSided) {
        this.moreSided = moreSided;
        if (moreSided) {
            this.requestGenerator = new MoreSidedDiffRequestGenerator();
        }
        return this;
    }

    public RefactoringEntry getEntry() {
        return this.entry;
    }

    public RefactoringInfo setEntry(RefactoringEntry entry) {
        this.entry = entry;
        return this;
    }

    public List<Pair<String, Boolean>> getMoreSidedLeftPaths() {
        if (this.moreSidedLeftPaths.isEmpty()) {
            MoreSidedDiffRequestGenerator generator = (MoreSidedDiffRequestGenerator)this.requestGenerator;
            this.moreSidedLeftPaths = generator.getLines().stream().map(line -> new Pair((Object)line.leftPath, (Object)(line.startLineRight == -1 && line.endLineRight == -1 ? 1 : 0))).collect(Collectors.toList());
        }
        return this.moreSidedLeftPaths;
    }

    public RefactoringType getType() {
        return this.type;
    }

    public RefactoringInfo setType(RefactoringType type) {
        this.type = type;
        return this;
    }

    public String getName() {
        return this.type.getName();
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public RefactoringInfo setHidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public RefactoringInfo setGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public String getLeftPath() {
        return this.paths[0];
    }

    public RefactoringInfo setLeftPath(String leftPath) {
        this.paths[0] = Utils.fixPath(leftPath);
        return this;
    }

    public String getMidPath() {
        return this.paths[1];
    }

    public RefactoringInfo setMidPath(String midPath) {
        this.paths[1] = Utils.fixPath(midPath);
        return this;
    }

    public String getRightPath() {
        return this.paths[2];
    }

    public RefactoringInfo setRightPath(String rightPath) {
        this.paths[2] = Utils.fixPath(rightPath);
        return this;
    }

    public String getNameBefore() {
        return this.uiStrings[0][0];
    }

    public RefactoringInfo setNameBefore(String nameBefore) {
        this.uiStrings[0][0] = nameBefore;
        return this;
    }

    public String getNameAfter() {
        return this.uiStrings[0][1];
    }

    public RefactoringInfo setNameAfter(String nameAfter) {
        this.uiStrings[0][1] = nameAfter;
        return this;
    }

    public String getElementBefore() {
        return this.uiStrings[1][0];
    }

    public RefactoringInfo setElementBefore(String elementBefore) {
        this.uiStrings[1][0] = elementBefore;
        return this;
    }

    public String getElementAfter() {
        return this.uiStrings[1][1];
    }

    public RefactoringInfo setElementAfter(String elementAfter) {
        this.uiStrings[1][1] = elementAfter;
        return this;
    }

    public String getDetailsBefore() {
        return this.uiStrings[2][0];
    }

    public RefactoringInfo setDetailsBefore(String detailsBefore) {
        this.uiStrings[2][0] = detailsBefore;
        return this;
    }

    public String getDetailsAfter() {
        return this.uiStrings[2][1];
    }

    public RefactoringInfo setDetailsAfter(String detailsAfter) {
        this.uiStrings[2][1] = detailsAfter;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RefactoringInfo)) {
            return false;
        }
        RefactoringInfo that = (RefactoringInfo)o;
        return this.getNameAfter().equals(that.getNameAfter()) && this.getNameBefore().equals(that.getNameBefore()) && Objects.equals(this.getDetailsAfter(), that.getDetailsAfter()) && Objects.equals(this.getDetailsBefore(), that.getDetailsBefore()) && Objects.equals(this.getElementBefore(), that.getElementBefore()) && this.type == that.getType() && this.group == that.getGroup();
    }

    public Group getGroup() {
        return this.group;
    }

    public RefactoringInfo setGroup(Group group) {
        this.group = group;
        return this;
    }

    public void correctLines(String before, String mid, String after) {
        boolean skipAnnotationsLeft = true;
        boolean skipAnnotationsRight = true;
        if (this.type.getName().matches("Add\\s(\\w)*\\sAnnotation")) {
            skipAnnotationsRight = false;
        } else if (this.type.getName().matches("Remove\\s(\\w)*\\sAnnotation")) {
            skipAnnotationsLeft = false;
        } else if (this.type.getName().matches("Modify\\s(\\w)*\\sAnnotation")) {
            skipAnnotationsRight = false;
            skipAnnotationsLeft = false;
        }
        this.requestGenerator.correct(before, mid, after, skipAnnotationsLeft, true, skipAnnotationsRight);
    }

    public void correctMoreSidedLines(List<String> befores, String after) {
        ((MoreSidedDiffRequestGenerator)this.requestGenerator).correct(befores, after, this.moreSidedLeftPaths, true, false, true);
    }

    public boolean isChanged() {
        return this.changed;
    }

    public RefactoringInfo setChanged(boolean changed) {
        this.changed = changed;
        return this;
    }
}

