/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.refactorinsight.common.data;

import com.intellij.diff.fragments.DiffFragmentImpl;
import com.intellij.diff.fragments.LineFragmentImpl;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.fragments.MergeLineFragmentImpl;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.research.refactorinsight.common.adapters.CodeRange;
import org.jetbrains.research.refactorinsight.common.adapters.LocationInfo;
import org.jetbrains.research.refactorinsight.common.diff.MoreSidedDiffRequestGenerator;
import org.jetbrains.research.refactorinsight.common.diff.ThreeSidedRange;
import org.jetbrains.research.refactorinsight.common.diff.VisualizationType;
import org.jetbrains.research.refactorinsight.common.utils.Utils;

public class RefactoringLine {
    private static final int LEFT_START = 0;
    private static final int LEFT_END = 1;
    private static final int MID_START = 2;
    private static final int MID_END = 3;
    private static final int RIGHT_START = 4;
    private static final int RIGHT_END = 5;
    VisualizationType type;
    private final int[] lines = new int[6];
    private int[] columns = new int[6];
    private final List<RefactoringOffset> offsets = new ArrayList<RefactoringOffset>();
    private boolean hasColumns = false;
    private String[] word;
    private boolean lazy = false;
    private List<TextRange> left;
    private List<TextRange> mid;
    private List<TextRange> right;
    private LineFragmentImpl fragment;
    private MoreSidedDiffRequestGenerator.MoreSidedRange moreSidedRange;
    private final MarkingOption markingOption;
    private boolean moreSided;

    public RefactoringLine(CodeRange left, CodeRange mid, CodeRange right, VisualizationType type, MarkingOption option, boolean hasColumns) {
        this(left, mid, right, type, option, hasColumns, false);
    }

    public RefactoringLine(CodeRange left, CodeRange mid, CodeRange right, VisualizationType type, MarkingOption option, boolean hasColumns, boolean moreSided) {
        this.markingOption = option;
        this.type = type;
        this.moreSided = moreSided;
        this.processLinesAndCols(left, mid, right, hasColumns);
    }

    public void correctLines(String leftText, String midText, String rightText, boolean skipAnnotationsLeft, boolean skipAnnotationsMid, boolean skipAnnotationsRight) {
        if (leftText != null) {
            int maxLineLeft = Utils.getMaxLine(leftText);
            this.lines[1] = this.lines[1] < 0 || this.lines[1] > maxLineLeft ? maxLineLeft : this.lines[1];
            this.lines[0] = this.lines[0] < 0 || this.lines[0] > maxLineLeft ? 0 : this.lines[0];
            this.lines[0] = Utils.skipJavadoc(leftText, this.lines[0], skipAnnotationsLeft);
        }
        if (midText != null) {
            int maxLineMid = Utils.getMaxLine(midText);
            this.lines[3] = this.lines[3] < 0 || this.lines[3] > maxLineMid ? maxLineMid : this.lines[3];
            this.lines[2] = this.lines[2] < 0 || this.lines[2] > maxLineMid ? 0 : this.lines[2];
            this.lines[2] = Utils.skipJavadoc(midText, this.lines[2], skipAnnotationsMid);
        }
        if (rightText != null) {
            int maxLineRight = Utils.getMaxLine(rightText);
            this.lines[5] = this.lines[5] < 0 || this.lines[5] > maxLineRight ? maxLineRight : this.lines[5];
            this.lines[4] = this.lines[4] < 0 || this.lines[4] > maxLineRight ? 0 : this.lines[4];
            this.lines[4] = Utils.skipJavadoc(rightText, this.lines[4], skipAnnotationsRight);
        }
        if (this.markingOption == MarkingOption.PACKAGE) {
            this.highlightPackage(leftText, rightText);
        }
        this.processOption(midText != null, this.markingOption);
        this.computeHighlighting(leftText, midText, rightText);
        if (this.moreSided) {
            this.computeMoreSidedRanges(leftText, rightText);
        }
        if (midText == null) {
            this.computeTwoSidedRanges(leftText, rightText);
        } else {
            this.computeThreeSidedRanges(leftText, midText, rightText);
        }
    }

    private void computeMoreSidedRanges(String leftText, String rightText) {
        MoreSidedDiffRequestGenerator.MoreSidedRange moreSidedRange = new MoreSidedDiffRequestGenerator.MoreSidedRange();
        moreSidedRange.startLineLeft = this.lines[0] + 1;
        moreSidedRange.endLineLeft = this.lines[1];
        moreSidedRange.startOffsetLeft = Utils.getOffset(leftText, this.lines[0] + 1, this.columns[0]);
        moreSidedRange.endOffsetLeft = Utils.getOffset(leftText, this.lines[1], this.columns[1]);
        moreSidedRange.startLineRight = this.lines[4] + 1;
        moreSidedRange.endLineRight = this.lines[5];
        moreSidedRange.startOffsetRight = Utils.getOffset(rightText, this.lines[4] + 1, this.columns[4]);
        moreSidedRange.endOffsetRight = Utils.getOffset(rightText, this.lines[5], this.columns[5]);
        this.moreSidedRange = moreSidedRange;
    }

    private void computeThreeSidedRanges(String leftText, String midText, String rightText) {
        this.left = this.offsets.stream().map(RefactoringOffset::getLeftRange).collect(Collectors.toList());
        this.mid = new ArrayList<TextRange>();
        this.right = this.offsets.stream().map(RefactoringOffset::getRightRange).collect(Collectors.toList());
        if (this.hasColumns) {
            try {
                int leftStartOffset = Utils.getOffset(leftText, this.lines[0] + 1, 1);
                this.left.add(new TextRange(Utils.getOffset(leftText, this.lines[0] + 1, this.columns[0]) - leftStartOffset, Utils.getOffset(leftText, this.lines[1], this.columns[1]) - leftStartOffset));
                int midStartOffset = Utils.getOffset(midText, this.lines[2] + 1, 1);
                this.mid.add(new TextRange(Utils.getOffset(midText, this.lines[2] + 1, this.columns[2]) - midStartOffset, Utils.getOffset(midText, this.lines[3], this.columns[3]) - midStartOffset));
                int rightStartOffset = Utils.getOffset(rightText, this.lines[4] + 1, 1);
                this.right.add(new TextRange(Utils.getOffset(rightText, this.lines[4] + 1, this.columns[4]) - rightStartOffset, Utils.getOffset(rightText, this.lines[5], this.columns[5]) - rightStartOffset));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void computeTwoSidedRanges(String leftText, String rightText) {
        if (this.lines[0] == this.lines[1] && this.lines[4] == this.lines[5]) {
            return;
        }
        List fragments = this.offsets.stream().map(RefactoringOffset::toDiffFragment).collect(Collectors.toList());
        if (this.hasColumns) {
            int leftStart = this.lines[0] == this.lines[1] ? this.lines[0] : this.lines[0] + 1;
            int rightStart = this.lines[4] == this.lines[5] ? this.lines[4] : this.lines[4] + 1;
            int leftStartOffset = Utils.getOffset(leftText, leftStart, this.columns[0]);
            int leftEndOffset = Utils.getOffset(leftText, this.lines[1], this.columns[1]);
            int rightStartOffset = Utils.getOffset(rightText, rightStart, this.columns[4]);
            int rightEndOffset = Utils.getOffset(rightText, this.lines[5], this.columns[5]);
            if (leftStartOffset != leftEndOffset && rightStartOffset != rightEndOffset) {
                fragments.add(new DiffFragmentImpl(leftStartOffset, leftEndOffset, rightStartOffset, rightEndOffset));
            }
        }
        this.fragment = new LineFragmentImpl(this.lines[0], this.lines[1], this.lines[4], this.lines[5], 0, 0, 0, 0, fragments);
    }

    private void computeHighlighting(String leftText, String midText, String rightText) {
        int[] beforeColumns;
        if (!this.lazy) {
            return;
        }
        this.hasColumns = true;
        this.columns = new int[]{1, 1, 0, 0, this.columns[4], this.columns[5]};
        if (this.word[0] != null && this.word[1] == null && this.word[2] == null) {
            beforeColumns = Utils.findColumnsBackwards(leftText, this.word[0], this.lines[0]);
            this.columns[0] = beforeColumns[0];
            this.columns[1] = beforeColumns[1];
        } else {
            if (this.word[0] != null) {
                beforeColumns = Utils.findColumns(leftText, this.word[0], this.lines[0]);
                this.columns[0] = beforeColumns[0];
                this.columns[1] = beforeColumns[1];
            }
            if (this.word[1] != null && midText != null) {
                int[] midColumns = Utils.findColumns(midText, this.word[1], this.lines[2]);
                this.columns[2] = midColumns[0];
                this.columns[3] = midColumns[1];
            }
            if (this.word[2] != null) {
                int[] afterColumns = Utils.findColumns(rightText, this.word[2], this.lines[4]);
                this.columns[4] = afterColumns[0];
                this.columns[5] = afterColumns[1];
            }
        }
        for (int i = 0; i < this.columns.length; ++i) {
            this.columns[i] = Math.max(this.columns[i], 1);
        }
    }

    public RefactoringLine addOffset(LocationInfo left, LocationInfo right) {
        this.offsets.add(new RefactoringOffset(left.getStartOffset(), left.getEndOffset(), right.getStartOffset(), right.getEndOffset()));
        return this;
    }

    public RefactoringLine addOffset(LocationInfo location, MarkingOption option) {
        int beforeStart = location.getStartOffset();
        int beforeEnd = location.getEndOffset();
        int afterStart = location.getStartOffset();
        int afterEnd = location.getEndOffset();
        switch (option) {
            case ADD: {
                beforeEnd = 0;
                beforeStart = 0;
                break;
            }
            case REMOVE: {
                afterEnd = 0;
                afterStart = 0;
                break;
            }
        }
        this.offsets.add(new RefactoringOffset(beforeStart, beforeEnd, afterStart, afterEnd));
        return this;
    }

    public LineFragmentImpl getTwoSidedRange() {
        return this.fragment;
    }

    public ThreeSidedRange getThreeSidedRange() {
        return new ThreeSidedRange(this.left, this.mid, this.right, this.type, (MergeLineFragment)new MergeLineFragmentImpl(this.lines[0], this.lines[1], this.lines[2], this.lines[3], this.lines[4], this.lines[5]));
    }

    public int getRightStart() {
        return this.lines[4];
    }

    public int getRightEnd() {
        return this.lines[5];
    }

    public int getLeftStart() {
        return this.lines[0];
    }

    public int getLeftEnd() {
        return this.lines[1];
    }

    public void setHasColumns(boolean hasColumns) {
        this.hasColumns = hasColumns;
    }

    public void setWord(String[] word) {
        this.word = word;
        this.lazy = true;
    }

    public void setMoreSided(boolean moreSided) {
        this.moreSided = moreSided;
    }

    public MoreSidedDiffRequestGenerator.MoreSidedRange getMoreSidedRange() {
        return this.moreSidedRange;
    }

    private void processOption(boolean hasMid, MarkingOption option) {
        switch (option) {
            case ADD: {
                this.lines[1] = this.lines[0];
                this.columns[1] = this.columns[0];
                break;
            }
            case REMOVE: {
                this.lines[5] = this.lines[4];
                break;
            }
            case COLLAPSE: {
                this.lines[1] = this.lines[0] + 1;
                this.lines[5] = this.lines[4] + 1;
                break;
            }
            case EXTRACT: {
                this.lines[0] = 0;
                this.lines[1] = 1;
                if (!hasMid) break;
                this.lines[3] = this.lines[2] + 1;
                break;
            }
        }
    }

    private void highlightPackage(String leftText, String rightText) {
        int packageLine1 = Utils.findPackageLine(leftText);
        int packageLine2 = Utils.findPackageLine(rightText);
        this.lines[0] = packageLine1 == -1 ? 0 : packageLine1;
        this.lines[4] = packageLine2 == -1 ? 0 : packageLine2;
        this.lines[1] = packageLine1 == -1 ? 0 : this.lines[0] + 1;
        this.lines[5] = packageLine2 == -1 ? 0 : this.lines[4] + 1;
    }

    private void processLinesAndCols(CodeRange left, CodeRange mid, CodeRange right, boolean hasColumns) {
        this.hasColumns = hasColumns;
        if (left != null) {
            this.lines[0] = left.getStartLine() - 1;
            this.lines[1] = left.getEndLine();
            if (hasColumns) {
                this.columns[0] = Math.max(left.getStartColumn(), 1);
                this.columns[1] = Math.max(left.getEndColumn(), 1);
            }
        }
        if (mid != null) {
            this.lines[2] = mid.getStartLine() - 1;
            this.lines[3] = mid.getEndLine();
            if (hasColumns) {
                this.columns[2] = Math.max(mid.getStartColumn(), 1);
                this.columns[3] = Math.max(mid.getEndColumn(), 1);
            }
        }
        if (right != null) {
            this.lines[4] = right.getStartLine() - 1;
            this.lines[5] = right.getEndLine();
            if (hasColumns) {
                this.columns[4] = Math.max(right.getStartColumn(), 1);
                this.columns[5] = Math.max(right.getEndColumn(), 1);
            }
        }
    }

    public static class RefactoringOffset {
        private final int leftStart;
        private final int leftEnd;
        private final int rightStart;
        private final int rightEnd;

        public RefactoringOffset(int leftStart, int leftEnd, int rightStart, int rightEnd) {
            this.leftStart = leftStart;
            this.leftEnd = leftEnd;
            this.rightStart = rightStart;
            this.rightEnd = rightEnd;
        }

        public DiffFragmentImpl toDiffFragment() {
            return new DiffFragmentImpl(this.leftStart, this.leftEnd, this.rightStart, this.rightEnd);
        }

        public TextRange getLeftRange() {
            return new TextRange(this.leftStart, this.leftEnd);
        }

        public TextRange getRightRange() {
            return new TextRange(this.rightStart, this.rightEnd);
        }
    }

    public static enum MarkingOption {
        ADD,
        REMOVE,
        COLLAPSE,
        NONE,
        EXTRACT,
        PACKAGE;

    }
}

