/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.refactorinsight.common.diff;

import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.research.refactorinsight.common.adapters.CodeRange;
import org.jetbrains.research.refactorinsight.common.data.RefactoringInfo;
import org.jetbrains.research.refactorinsight.common.data.RefactoringLine;
import org.jetbrains.research.refactorinsight.common.diff.DiffRequestGenerator;
import org.jetbrains.research.refactorinsight.common.diff.VisualizationType;
import org.jetbrains.research.refactorinsight.common.utils.StringUtils;

public class MoreSidedDiffRequestGenerator
extends DiffRequestGenerator {
    List<MoreSidedRange> lines;

    public MoreSidedDiffRequestGenerator(List<MoreSidedRange> lines) {
        this.lines = lines;
    }

    public MoreSidedDiffRequestGenerator() {
    }

    public List<String> getClassNames() {
        return this.lines.stream().map(MoreSidedRange::getLeftPath).map(StringUtils::pathToClassName).distinct().collect(Collectors.toList());
    }

    public List<MoreSidedRange> getLines() {
        return this.lines;
    }

    public static MoreSidedDiffRequestGenerator fromString(String seq) {
        List<MoreSidedRange> lines = Arrays.stream(seq.split(StringUtils.delimiter(4))).map(MoreSidedRange::fromString).collect(Collectors.toList());
        return new MoreSidedDiffRequestGenerator(lines);
    }

    @Override
    public SimpleDiffRequest generate(DiffContent[] contents, RefactoringInfo info) {
        SimpleDiffRequest request = null;
        if (contents != null && this.lines != null && contents.length == this.lines.size() + 1) {
            for (int i = 0; i < this.lines.size(); ++i) {
                this.lines.get((int)i).content = contents[i + 1];
            }
            request = new SimpleDiffRequest(info.getName(), contents[1], contents[0], "Subclasses", info.getRightPath());
            request.putUserData(Key.create((String)"refactoringMiner.isRefactoringDiff"), (Object)true);
            request.putUserData(Key.create((String)"refactoringMiner.List<MoreSidedDiffRequestGenerator.Data>"), this.lines);
            request.putUserData(DiffUserDataKeysEx.CUSTOM_DIFF_COMPUTER, (text1, text2, policy, innerChanges, indicator) -> new ArrayList());
        }
        return request;
    }

    @Override
    public void prepareRanges(List<RefactoringLine> lineMarkings) {
        this.lines = lineMarkings.stream().map(RefactoringLine::getMoreSidedRange).collect(Collectors.toList());
    }

    @Override
    public void addMarking(CodeRange left, CodeRange mid, CodeRange right, VisualizationType type, Consumer<RefactoringLine> offsetFunction, RefactoringLine.MarkingOption option, boolean hasColumns) {
        RefactoringLine line = new RefactoringLine(left, mid, right, type, option, hasColumns, true);
        if (offsetFunction != null) {
            offsetFunction.accept(line);
        }
        this.lineMarkings.add(line);
    }

    @Override
    public void correct(String before, String mid, String after, boolean skipAnnotationsLeft, boolean skipAnnotationsMid, boolean skipAnnotationsRight) {
        throw new IllegalStateException("Incorrect correct method for more sided diff request");
    }

    public void correct(List<String> befores, String after, List<Pair<String, Boolean>> pathPair, boolean skipAnnotationsLeft, boolean skipAnnotationsMid, boolean skipAnnotationsRight) {
        assert (pathPair.size() == this.lineMarkings.size());
        for (int i = 0; i < befores.size(); ++i) {
            ((RefactoringLine)this.lineMarkings.get(i)).correctLines(befores.get(i), null, after, skipAnnotationsLeft, skipAnnotationsMid, skipAnnotationsRight);
            ((RefactoringLine)this.lineMarkings.get((int)i)).getMoreSidedRange().leftPath = (String)pathPair.get((int)i).first;
            if (!((Boolean)pathPair.get((int)i).second).booleanValue()) continue;
            ((RefactoringLine)this.lineMarkings.get((int)i)).getMoreSidedRange().startLineRight = -1;
            ((RefactoringLine)this.lineMarkings.get((int)i)).getMoreSidedRange().endLineRight = -1;
        }
        this.prepareRanges(this.lineMarkings);
    }

    public String toString() {
        if (this.lines == null || this.lines.size() == 0) {
            return "";
        }
        return this.lines.stream().map(MoreSidedRange::toString).collect(Collectors.joining(StringUtils.delimiter(4)));
    }

    public static class MoreSidedRange
    implements Comparable<MoreSidedRange> {
        public int startLineLeft;
        public int endLineLeft;
        public int startOffsetLeft;
        public int endOffsetLeft;
        public int startLineRight;
        public int endLineRight;
        public int startOffsetRight;
        public int endOffsetRight;
        public String leftPath;
        public transient DiffContent content;

        public MoreSidedRange(int startLineLeft, int endLineLeft, int startOffsetLeft, int endOffsetLeft, int startLineRight, int endLineRight, int startOffsetRight, int endOffsetRight, String leftPath) {
            this.startLineLeft = startLineLeft;
            this.endLineLeft = endLineLeft;
            this.startOffsetLeft = startOffsetLeft;
            this.endOffsetLeft = endOffsetLeft;
            this.startLineRight = startLineRight;
            this.endLineRight = endLineRight;
            this.startOffsetRight = startOffsetRight;
            this.endOffsetRight = endOffsetRight;
            this.leftPath = leftPath;
        }

        public MoreSidedRange() {
        }

        public String getLeftPath() {
            return this.leftPath;
        }

        public static MoreSidedRange fromString(String seq) {
            String value = StringUtils.deSanitize(seq);
            String[] tokens = value.split(StringUtils.delimiter(6));
            MoreSidedRange moreSidedRange = new MoreSidedRange();
            moreSidedRange.startLineLeft = Integer.parseInt(tokens[0]);
            moreSidedRange.endLineLeft = Integer.parseInt(tokens[1]);
            moreSidedRange.startOffsetLeft = Integer.parseInt(tokens[2]);
            moreSidedRange.endOffsetLeft = Integer.parseInt(tokens[3]);
            moreSidedRange.startLineRight = Integer.parseInt(tokens[4]);
            moreSidedRange.endLineRight = Integer.parseInt(tokens[5]);
            moreSidedRange.startOffsetRight = Integer.parseInt(tokens[6]);
            moreSidedRange.endOffsetRight = Integer.parseInt(tokens[7]);
            moreSidedRange.leftPath = tokens[8];
            return moreSidedRange;
        }

        public String toString() {
            return String.join((CharSequence)StringUtils.delimiter(6), StringUtils.sanitize(Integer.toString(this.startLineLeft)), StringUtils.sanitize(Integer.toString(this.endLineLeft)), StringUtils.sanitize(Integer.toString(this.startOffsetLeft)), StringUtils.sanitize(Integer.toString(this.endOffsetLeft)), StringUtils.sanitize(Integer.toString(this.startLineRight)), StringUtils.sanitize(Integer.toString(this.endLineRight)), StringUtils.sanitize(Integer.toString(this.startOffsetRight)), StringUtils.sanitize(Integer.toString(this.endOffsetRight)), StringUtils.sanitize(this.leftPath));
        }

        @Override
        public int compareTo(@NotNull MoreSidedRange moreSidedRange) {
            if (moreSidedRange == null) {
                MoreSidedRange.$$$reportNull$$$0(0);
            }
            if (this.leftPath.equals(moreSidedRange.leftPath)) {
                if (this.startLineLeft == moreSidedRange.startLineLeft) {
                    return 0;
                }
                if (this.startLineLeft > moreSidedRange.startLineLeft) {
                    return 1;
                }
                return -1;
            }
            return this.leftPath.compareTo(moreSidedRange.leftPath);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moreSidedRange", "org/jetbrains/research/refactorinsight/common/diff/MoreSidedDiffRequestGenerator$MoreSidedRange", "compareTo"));
        }
    }
}

