/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.refactorinsight.common.diff;

import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.research.refactorinsight.common.data.RefactoringInfo;
import org.jetbrains.research.refactorinsight.common.data.RefactoringLine;
import org.jetbrains.research.refactorinsight.common.diff.DiffRequestGenerator;
import org.jetbrains.research.refactorinsight.common.diff.ThreeSidedRange;
import org.jetbrains.research.refactorinsight.common.utils.StringUtils;

public class ThreeSidedDiffRequestGenerator
extends DiffRequestGenerator {
    private List<ThreeSidedRange> ranges = new ArrayList<ThreeSidedRange>();

    public static ThreeSidedDiffRequestGenerator fromString(String value) {
        String regex = StringUtils.delimiter(4, true);
        ThreeSidedDiffRequestGenerator generator = new ThreeSidedDiffRequestGenerator();
        String[] tokens = value.split(regex);
        if (tokens[0].isEmpty()) {
            return generator;
        }
        generator.ranges = Arrays.stream(tokens).map(ThreeSidedRange::fromString).collect(Collectors.toList());
        return generator;
    }

    @Override
    public SimpleDiffRequest generate(DiffContent[] contents, RefactoringInfo info) {
        SimpleDiffRequest request = new SimpleDiffRequest(info.getName(), contents[0], contents[1], contents[2], info.getLeftPath(), info.getMidPath(), info.getRightPath());
        request.putUserData(Key.create((String)"refactoringMiner.List<ThreeSidedRange>"), this.ranges);
        request.putUserData(Key.create((String)"refactoringMiner.isRefactoringDiff"), (Object)true);
        return request;
    }

    @Override
    public void prepareRanges(List<RefactoringLine> lineMarkings) {
        this.ranges = lineMarkings.stream().map(RefactoringLine::getThreeSidedRange).collect(Collectors.toList());
    }

    public String toString() {
        return this.ranges.stream().map(ThreeSidedRange::toString).collect(Collectors.joining(StringUtils.delimiter(4)));
    }
}

