/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.refactorinsight.common.diff;

import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.fragments.MergeLineFragmentImpl;
import com.intellij.diff.tools.simple.SimpleThreesideDiffChange;
import com.intellij.diff.tools.simple.SimpleThreesideDiffViewer;
import com.intellij.diff.tools.util.text.MergeInnerDifferences;
import com.intellij.diff.util.MergeConflictType;
import com.intellij.diff.util.TextDiffType;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.util.TextRange;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jetbrains.research.refactorinsight.common.diff.VisualizationType;
import org.jetbrains.research.refactorinsight.common.utils.StringUtils;

public class ThreeSidedRange {
    List<TextRange> left;
    List<TextRange> mid;
    List<TextRange> right;
    VisualizationType type;
    MergeLineFragment fragment;

    public ThreeSidedRange(List<TextRange> left, List<TextRange> mid, List<TextRange> right, VisualizationType type, MergeLineFragment fragment) {
        this.left = left;
        this.mid = mid;
        this.right = right;
        this.fragment = fragment;
        this.type = type;
    }

    private static List<TextRange> deStringify(String value) {
        String regex = StringUtils.delimiter(6, true);
        String[] tokens = value.split(regex);
        assert (tokens.length % 2 == 0);
        return IntStream.range(0, tokens.length / 2).map(i -> i * 2).mapToObj(i -> new TextRange(Integer.parseInt(tokens[i]), Integer.parseInt(tokens[i + 1]))).collect(Collectors.toList());
    }

    public static ThreeSidedRange fromString(String value) {
        String regex = StringUtils.delimiter(5, true);
        String[] tokens = value.split(regex);
        return new ThreeSidedRange(ThreeSidedRange.deStringify(tokens[7]), ThreeSidedRange.deStringify(tokens[8]), ThreeSidedRange.deStringify(tokens[9]), VisualizationType.valueOf(tokens[0]), (MergeLineFragment)new MergeLineFragmentImpl(Integer.parseInt(tokens[1]), Integer.parseInt(tokens[2]), Integer.parseInt(tokens[3]), Integer.parseInt(tokens[4]), Integer.parseInt(tokens[5]), Integer.parseInt(tokens[6])));
    }

    public SimpleThreesideDiffChange getDiffChange(SimpleThreesideDiffViewer viewer) {
        return new SimpleThreesideDiffChange(this.fragment, this.getMergeConflictType(this.type), new MergeInnerDifferences(this.left, this.mid, this.right), viewer);
    }

    public String toString() {
        return Stream.of(this.type.toString(), this.fragment.getStartLine(ThreeSide.LEFT), this.fragment.getEndLine(ThreeSide.LEFT), this.fragment.getStartLine(ThreeSide.BASE), this.fragment.getEndLine(ThreeSide.BASE), this.fragment.getStartLine(ThreeSide.RIGHT), this.fragment.getEndLine(ThreeSide.RIGHT), this.stringify(this.left), this.stringify(this.mid), this.stringify(this.right)).map(x$0 -> String.valueOf(x$0)).collect(Collectors.joining(StringUtils.delimiter(5)));
    }

    private String stringify(List<TextRange> list) {
        return list.stream().map(r -> r.getStartOffset() + StringUtils.delimiter(6) + r.getEndOffset()).collect(Collectors.joining(StringUtils.delimiter(6)));
    }

    private MergeConflictType getMergeConflictType(VisualizationType type) {
        switch (type) {
            case LEFT: {
                return new MergeConflictType(TextDiffType.MODIFIED, true, false);
            }
            case RIGHT: {
                return new MergeConflictType(TextDiffType.INSERTED, false, true);
            }
        }
        return new MergeConflictType(TextDiffType.MODIFIED, true, true);
    }
}

