/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.refactorinsight.kotlin.impl.data;

import java.util.HashMap;
import org.jetbrains.research.refactorinsight.common.data.RefactoringType;
import org.jetbrains.research.refactorinsight.kotlin.impl.data.KotlinRefactoringHandler;
import org.jetbrains.research.refactorinsight.kotlin.impl.data.classes.ExtractClassKotlinHandler;
import org.jetbrains.research.refactorinsight.kotlin.impl.data.classes.ExtractSuperClassKotlinHandler;
import org.jetbrains.research.refactorinsight.kotlin.impl.data.classes.MoveClassKotlinHandler;
import org.jetbrains.research.refactorinsight.kotlin.impl.data.classes.MoveRenameClassKotlinHandler;
import org.jetbrains.research.refactorinsight.kotlin.impl.data.classes.RenameClassKotlinHandler;
import org.jetbrains.research.refactorinsight.kotlin.impl.data.methods.AddParameterKotlinHandler;
import org.jetbrains.research.refactorinsight.kotlin.impl.data.methods.ExtractOperationKotlinHandler;
import org.jetbrains.research.refactorinsight.kotlin.impl.data.methods.InlineOperationKotlinHandler;
import org.jetbrains.research.refactorinsight.kotlin.impl.data.methods.MoveOperationKotlinHandler;
import org.jetbrains.research.refactorinsight.kotlin.impl.data.methods.PullUpOperationKotlinHandler;
import org.jetbrains.research.refactorinsight.kotlin.impl.data.methods.PushDownOperationKotlinHandler;
import org.jetbrains.research.refactorinsight.kotlin.impl.data.methods.RemoveParameterKotlinHandler;
import org.jetbrains.research.refactorinsight.kotlin.impl.data.methods.RenameMethodKotlinHandler;
import org.jetbrains.research.refactorinsight.kotlin.impl.data.methods.ReorderParameterKotlinHandler;
import org.jetbrains.research.refactorinsight.kotlin.impl.data.packages.MoveSourceFolderKotlinHandler;
import org.jetbrains.research.refactorinsight.kotlin.impl.data.packages.RenamePackageKotlinHandler;

public class KotlinRefactoringHandlersMap {
    static HashMap<RefactoringType, KotlinRefactoringHandler> handlerHashMap = new HashMap<RefactoringType, KotlinRefactoringHandler>(){
        {
            this.put(RefactoringType.MOVE_OPERATION, new MoveOperationKotlinHandler());
            this.put(RefactoringType.MOVE_AND_RENAME_OPERATION, new MoveOperationKotlinHandler());
            this.put(RefactoringType.RENAME_METHOD, new RenameMethodKotlinHandler());
            this.put(RefactoringType.EXTRACT_OPERATION, new ExtractOperationKotlinHandler());
            this.put(RefactoringType.INLINE_OPERATION, new InlineOperationKotlinHandler());
            this.put(RefactoringType.PULL_UP_OPERATION, new PullUpOperationKotlinHandler());
            this.put(RefactoringType.EXTRACT_AND_MOVE_OPERATION, new ExtractOperationKotlinHandler());
            this.put(RefactoringType.MOVE_AND_INLINE_OPERATION, new InlineOperationKotlinHandler());
            this.put(RefactoringType.PUSH_DOWN_OPERATION, new PushDownOperationKotlinHandler());
            this.put(RefactoringType.EXTRACT_CLASS, new ExtractClassKotlinHandler());
            this.put(RefactoringType.RENAME_CLASS, new RenameClassKotlinHandler());
            this.put(RefactoringType.MOVE_CLASS, new MoveClassKotlinHandler());
            this.put(RefactoringType.MOVE_RENAME_CLASS, new MoveRenameClassKotlinHandler());
            this.put(RefactoringType.EXTRACT_INTERFACE, new ExtractSuperClassKotlinHandler());
            this.put(RefactoringType.EXTRACT_SUPERCLASS, new ExtractSuperClassKotlinHandler());
            this.put(RefactoringType.EXTRACT_SUBCLASS, new ExtractClassKotlinHandler());
            this.put(RefactoringType.ADD_PARAMETER, new AddParameterKotlinHandler());
            this.put(RefactoringType.REMOVE_PARAMETER, new RemoveParameterKotlinHandler());
            this.put(RefactoringType.REORDER_PARAMETER, new ReorderParameterKotlinHandler());
            this.put(RefactoringType.MOVE_SOURCE_FOLDER, new MoveSourceFolderKotlinHandler());
            this.put(RefactoringType.RENAME_PACKAGE, new RenamePackageKotlinHandler());
        }
    };

    public static KotlinRefactoringHandler getKotlinHandler(RefactoringType type) {
        return handlerHashMap.getOrDefault((Object)type, null);
    }
}

