/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.refactorinsight.kotlin.impl.data.methods;

import java.util.List;
import org.jetbrains.research.kotlinrminer.ide.Refactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.RenameOperationRefactoring;
import org.jetbrains.research.refactorinsight.common.data.Group;
import org.jetbrains.research.refactorinsight.common.data.RefactoringInfo;
import org.jetbrains.research.refactorinsight.common.data.RefactoringLine;
import org.jetbrains.research.refactorinsight.kotlin.impl.data.KotlinRefactoringHandler;
import org.jetbrains.research.refactorinsight.kotlin.impl.data.util.KotlinUtils;

public class RenameMethodKotlinHandler
extends KotlinRefactoringHandler {
    @Override
    public RefactoringInfo specify(Refactoring refactoring, RefactoringInfo info) {
        List<String> variables;
        RenameOperationRefactoring ref = (RenameOperationRefactoring)refactoring;
        String id = ref.getRenamedOperation().getClassName() + ".";
        if (ref.getRenamedOperation().isGetter() && !(variables = ref.getRenamedOperation().getBody().getAllVariables()).isEmpty()) {
            id = id + variables.get(0);
            info.setGroupId(id);
        }
        String classNameBefore = ref.getOriginalOperation().getClassName();
        String classNameAfter = ref.getRenamedOperation().getClassName();
        info.setGroup(Group.METHOD).setDetailsBefore(classNameBefore).setDetailsAfter(classNameAfter).setElementBefore(null).setElementAfter(null).setNameBefore(KotlinUtils.calculateSignatureForKotlinMethod(ref.getOriginalOperation())).setNameAfter(KotlinUtils.calculateSignatureForKotlinMethod(ref.getRenamedOperation()));
        return info.addMarking(KotlinUtils.createCodeRangeFromKotlin(ref.getOriginalOperation().codeRange()), KotlinUtils.createCodeRangeFromKotlin(ref.getRenamedOperation().codeRange()), refactoringLine -> refactoringLine.setWord(new String[]{ref.getOriginalOperation().getName(), null, ref.getRenamedOperation().getName()}), RefactoringLine.MarkingOption.COLLAPSE, true);
    }
}

