/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.provider;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierListOwner;
import de.plushnikov.intellij.plugin.processor.LombokProcessorManager;
import de.plushnikov.intellij.plugin.processor.LombokPsiElementUsage;
import de.plushnikov.intellij.plugin.processor.Processor;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LombokImplicitUsageProvider
implements ImplicitUsageProvider {
    public boolean isImplicitUsage(@NotNull PsiElement element) {
        if (element == null) {
            LombokImplicitUsageProvider.$$$reportNull$$$0(0);
        }
        return this.checkUsage(element, EnumSet.of(LombokPsiElementUsage.READ, LombokPsiElementUsage.WRITE, LombokPsiElementUsage.READ_WRITE));
    }

    public boolean isImplicitRead(@NotNull PsiElement element) {
        if (element == null) {
            LombokImplicitUsageProvider.$$$reportNull$$$0(1);
        }
        return this.checkUsage(element, EnumSet.of(LombokPsiElementUsage.READ, LombokPsiElementUsage.READ_WRITE));
    }

    public boolean isImplicitWrite(@NotNull PsiElement element) {
        if (element == null) {
            LombokImplicitUsageProvider.$$$reportNull$$$0(2);
        }
        return this.checkUsage(element, EnumSet.of(LombokPsiElementUsage.WRITE, LombokPsiElementUsage.READ_WRITE));
    }

    private boolean checkUsage(@NotNull PsiElement element, EnumSet<LombokPsiElementUsage> elementUsages) {
        PsiField psiField;
        if (element == null) {
            LombokImplicitUsageProvider.$$$reportNull$$$0(3);
        }
        return element instanceof PsiField && (this.isUsedByLombokAnnotations(psiField = (PsiField)element, (PsiModifierListOwner)psiField, elementUsages) || this.isUsedByLombokAnnotations(psiField, (PsiModifierListOwner)psiField.getContainingClass(), elementUsages));
    }

    private boolean isUsedByLombokAnnotations(@NotNull PsiField psiField, @Nullable PsiModifierListOwner modifierListOwner, EnumSet<LombokPsiElementUsage> elementUsages) {
        if (psiField == null) {
            LombokImplicitUsageProvider.$$$reportNull$$$0(4);
        }
        if (null != modifierListOwner) {
            for (PsiAnnotation psiAnnotation : modifierListOwner.getAnnotations()) {
                for (Processor processor : LombokProcessorManager.getProcessors(psiAnnotation)) {
                    LombokPsiElementUsage psiElementUsage = processor.checkFieldUsage(psiField, psiAnnotation);
                    if (!elementUsages.contains((Object)psiElementUsage)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
        }
        objectArray2[1] = "de/plushnikov/intellij/plugin/provider/LombokImplicitUsageProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitUsage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitRead";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitWrite";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkUsage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isUsedByLombokAnnotations";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

