/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.branch.DvcsBranchUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListPopup;
import git4idea.branch.GitBranchUtil;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.BranchIconUtil;
import git4idea.ui.branch.GitBranchPopup;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitBranchesComboBoxAction
extends ComboBoxAction
implements DumbAware {
    public GitBranchesComboBoxAction() {
        KeymapManager.getInstance().bindShortcuts("Git.Branches", "Git.ShowBranches");
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            GitBranchesComboBoxAction.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        Presentation presentation = e.getPresentation();
        if (project == null || project.isDisposed() || !project.isOpen()) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        GitRepository repo = GitBranchUtil.getCurrentRepository(project);
        if (repo == null) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        String branchName = repo.getCurrentRevision() != null ? GitBranchUtil.getDisplayableBranchText(repo) : GitBundle.message("no.revisions.available", new Object[0]);
        String name = DvcsBranchUtil.shortenBranchName((String)branchName);
        presentation.setText(name, false);
        presentation.setIcon(BranchIconUtil.Companion.getBranchIcon(repo));
        presentation.setEnabledAndVisible(true);
        presentation.setDescription(GitBundle.messagePointer("action.Git.ShowBranches.description", new Object[0]).get());
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button2) {
        return new DefaultActionGroup();
    }

    @NotNull
    protected ListPopup createActionPopup(@NotNull DataContext context, @NotNull JComponent component2, final @Nullable Runnable disposeCallback) {
        if (context == null) {
            GitBranchesComboBoxAction.$$$reportNull$$$0(1);
        }
        if (component2 == null) {
            GitBranchesComboBoxAction.$$$reportNull$$$0(2);
        }
        Project project = Objects.requireNonNull((Project)context.getData(CommonDataKeys.PROJECT));
        GitRepository repo = Objects.requireNonNull(GitBranchUtil.getCurrentRepository(project));
        ListPopup popup2 = GitBranchPopup.getInstance(project, repo, context).asListPopup();
        popup2.addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (disposeCallback != null) {
                    disposeCallback.run();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "git4idea/actions/GitBranchesComboBoxAction$1", "onClosed"));
            }
        });
        ListPopup listPopup = popup2;
        if (listPopup == null) {
            GitBranchesComboBoxAction.$$$reportNull$$$0(3);
        }
        return listPopup;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/actions/GitBranchesComboBoxAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/actions/GitBranchesComboBoxAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionPopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createActionPopup";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

