/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.dvcs.DvcsRememberedInputs;
import com.intellij.externalProcessAuthHelper.AuthenticationGate;
import com.intellij.externalProcessAuthHelper.AuthenticationMode;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.AuthData;
import com.intellij.util.UriUtil;
import com.intellij.util.containers.ContainerUtil;
import git4idea.DialogManager;
import git4idea.commands.GitHttpAuthenticator;
import git4idea.commands.GitHttpLoginDialog;
import git4idea.config.GitConfigUtil;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.i18n.GitBundle;
import git4idea.remote.GitHttpAuthDataProvider;
import git4idea.remote.GitRememberedInputs;
import git4idea.remote.GitRepositoryHostingService;
import git4idea.remote.InteractiveGitHttpAuthDataProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitHttpGuiAuthenticator
implements GitHttpAuthenticator {
    private static final Logger LOG = Logger.getInstance(GitHttpGuiAuthenticator.class);
    private static final String HTTP_SCHEME_URL_PREFIX = "http://";
    @NotNull
    private final Project myProject;
    @Nullable
    private final String myPresetUrl;
    @NotNull
    private final File myWorkingDirectory;
    @NotNull
    private final AuthenticationGate myAuthenticationGate;
    @NotNull
    private final AuthenticationMode myAuthenticationMode;
    @Nullable
    private volatile ProviderAndData myProviderAndData;
    private volatile boolean myCredentialHelperShouldBeUsed;

    GitHttpGuiAuthenticator(@NotNull Project project, @NotNull Collection<String> urls, @NotNull File workingDirectory, @NotNull AuthenticationGate authenticationGate, @NotNull AuthenticationMode authenticationMode) {
        if (project == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(0);
        }
        if (urls == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(1);
        }
        if (workingDirectory == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(2);
        }
        if (authenticationGate == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(3);
        }
        if (authenticationMode == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(4);
        }
        this.myProviderAndData = null;
        this.myCredentialHelperShouldBeUsed = false;
        this.myProject = project;
        this.myPresetUrl = GitHttpGuiAuthenticator.findFirstHttpUrl(urls);
        this.myWorkingDirectory = workingDirectory;
        this.myAuthenticationGate = authenticationGate;
        this.myAuthenticationMode = authenticationMode;
    }

    @Nullable
    private static String findFirstHttpUrl(@NotNull Collection<String> urls) {
        if (urls == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(5);
        }
        return (String)ContainerUtil.find(urls, url -> ((String)UriUtil.splitScheme((String)url).getFirst()).startsWith("http"));
    }

    @Override
    @NotNull
    public String askPassword(@NotNull String url) {
        ProviderAndData newData;
        ProviderAndData providerAndData;
        if (url == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(6);
        }
        if ((providerAndData = this.myProviderAndData) != null) {
            LOG.debug("askPassword. Data already filled in askUsername.");
            String string = providerAndData.getPassword();
            if (string == null) {
                GitHttpGuiAuthenticator.$$$reportNull$$$0(7);
            }
            return string;
        }
        Couple<String> usernameAndUrl = GitHttpGuiAuthenticator.splitToUsernameAndUnifiedUrl(this.getRequiredUrl(url));
        String login = (String)usernameAndUrl.first;
        if (login == null) {
            LOG.debug("askPassword. login unknown, cannot determine password without login");
            return "";
        }
        String unifiedUrl = (String)usernameAndUrl.second;
        LOG.debug("askPassword. gitUrl=" + url + ", unifiedUrl=" + unifiedUrl);
        this.myProviderAndData = newData = this.acquireData(unifiedUrl, provider -> provider.getDataForKnownLogin(login));
        if (newData != null) {
            LOG.debug("askPassword. " + newData.toString());
            String string = newData.getPassword();
            if (string == null) {
                GitHttpGuiAuthenticator.$$$reportNull$$$0(8);
            }
            return string;
        }
        LOG.debug("askPassword. no data provided");
        return "";
    }

    @Override
    @NotNull
    public String askUsername(@NotNull String url) {
        ProviderAndData providerAndData;
        if (url == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(9);
        }
        String unifiedUrl = (String)GitHttpGuiAuthenticator.splitToUsernameAndUnifiedUrl((String)this.getRequiredUrl((String)url)).second;
        LOG.debug("askUsername. gitUrl=" + url + ", unifiedUrl=" + unifiedUrl);
        this.myProviderAndData = providerAndData = this.acquireData(unifiedUrl, AuthDataProvider::getData);
        if (providerAndData != null) {
            LOG.debug("askUsername. " + providerAndData.toString());
            String string = providerAndData.getLogin();
            if (string == null) {
                GitHttpGuiAuthenticator.$$$reportNull$$$0(10);
            }
            return string;
        }
        LOG.debug("askUsername. no data provided");
        return "";
    }

    @Nullable
    private ProviderAndData acquireData(@NotNull String unifiedUrl, @NotNull Function<? super AuthDataProvider, ? extends AuthData> dataAcquirer) {
        if (unifiedUrl == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(11);
        }
        if (dataAcquirer == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(12);
        }
        return (ProviderAndData)this.myAuthenticationGate.waitAndCompute(() -> {
            try {
                for (AuthDataProvider provider : this.getProviders(unifiedUrl)) {
                    AuthData data = (AuthData)dataAcquirer.apply(provider);
                    if (data == null || data.getPassword() == null) continue;
                    return new ProviderAndData(provider, data.getLogin(), data.getPassword());
                }
                return null;
            }
            catch (ProcessCanceledException pce) {
                this.myAuthenticationGate.cancel();
                return new ProviderAndData(new CancelledProvider(unifiedUrl), "", "");
            }
            catch (CredentialHelperShouldBeUsedException e) {
                this.myAuthenticationGate.cancel();
                this.myCredentialHelperShouldBeUsed = true;
                return null;
            }
        });
    }

    @NotNull
    private List<AuthDataProvider> getProviders(@NotNull String unifiedUrl) {
        if (unifiedUrl == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(13);
        }
        ArrayList<AuthDataProvider> delegates = new ArrayList<AuthDataProvider>();
        PasswordSafeProvider passwordSafeProvider = new PasswordSafeProvider(unifiedUrl, GitRememberedInputs.getInstance(), PasswordSafe.getInstance());
        boolean showActionForGitHelper = GitConfigUtil.isCredentialHelperUsed(this.myProject, this.myWorkingDirectory);
        DialogProvider dialogProvider = new DialogProvider(unifiedUrl, this.myProject, passwordSafeProvider, showActionForGitHelper);
        if (this.myAuthenticationMode != AuthenticationMode.NONE) {
            delegates.add(passwordSafeProvider);
        }
        List extensionAdapterProviders = ContainerUtil.map((Object[])((GitHttpAuthDataProvider[])GitHttpAuthDataProvider.EP_NAME.getExtensions()), provider -> new ExtensionAdapterProvider(unifiedUrl, this.myProject, (GitHttpAuthDataProvider)provider));
        if (this.myAuthenticationMode == AuthenticationMode.SILENT) {
            delegates.addAll(ContainerUtil.filter((Collection)extensionAdapterProviders, p -> p.myDelegate.isSilent()));
        } else if (this.myAuthenticationMode == AuthenticationMode.FULL) {
            delegates.addAll(extensionAdapterProviders);
            delegates.add(dialogProvider);
        }
        ArrayList<AuthDataProvider> arrayList = delegates;
        if (arrayList == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @Override
    public void saveAuthData() {
        ProviderAndData providerAndData = this.myProviderAndData;
        if (providerAndData == null) {
            return;
        }
        LOG.debug("saveAuthData. " + providerAndData.toString());
        providerAndData.getProvider().onAuthSuccess();
    }

    @Override
    public void forgetPassword() {
        ProviderAndData providerAndData = this.myProviderAndData;
        if (providerAndData == null) {
            return;
        }
        LOG.debug("forgetPassword. " + providerAndData.toString());
        providerAndData.getProvider().onAuthFailure();
    }

    @Override
    public boolean wasCancelled() {
        if (this.myCredentialHelperShouldBeUsed) {
            return false;
        }
        ProviderAndData providerAndData = this.myProviderAndData;
        return providerAndData != null && providerAndData.getProvider() instanceof CancelledProvider;
    }

    @Override
    public boolean wasRequested() {
        return this.myProviderAndData != null;
    }

    @NotNull
    private String getRequiredUrl(@Nullable String urlFromGit) {
        if (urlFromGit != null && !StringUtil.isEmptyOrSpaces((String)urlFromGit)) {
            String string = urlFromGit;
            if (string == null) {
                GitHttpGuiAuthenticator.$$$reportNull$$$0(15);
            }
            return string;
        }
        if (this.myPresetUrl == null) {
            throw new IllegalStateException("Invalid remote urls in handler");
        }
        String string = this.myPresetUrl;
        if (string == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    private static Couple<String> splitToUsernameAndUnifiedUrl(@NotNull String url) {
        if (url == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(17);
        }
        if (StringUtil.isEmptyOrSpaces((String)url)) {
            Couple couple = Couple.of(null, (Object)url);
            if (couple == null) {
                GitHttpGuiAuthenticator.$$$reportNull$$$0(18);
            }
            return couple;
        }
        Couple couple = UriUtil.splitScheme((String)url);
        String urlWithoutScheme = (String)couple.second;
        if (StringUtil.isEmptyOrSpaces((String)urlWithoutScheme)) {
            Couple couple2 = Couple.of(null, (Object)url);
            if (couple2 == null) {
                GitHttpGuiAuthenticator.$$$reportNull$$$0(19);
            }
            return couple2;
        }
        int i = urlWithoutScheme.indexOf(64);
        if (i <= 0) {
            Couple couple3 = Couple.of(null, (Object)(HTTP_SCHEME_URL_PREFIX + urlWithoutScheme));
            if (couple3 == null) {
                GitHttpGuiAuthenticator.$$$reportNull$$$0(20);
            }
            return couple3;
        }
        Couple couple4 = Couple.of((Object)urlWithoutScheme.substring(0, i), (Object)(HTTP_SCHEME_URL_PREFIX + urlWithoutScheme.substring(i + 1)));
        if (couple4 == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(21);
        }
        return couple4;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authenticationGate";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authenticationMode";
                break;
            }
            case 6: 
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/commands/GitHttpGuiAuthenticator";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unifiedUrl";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataAcquirer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/commands/GitHttpGuiAuthenticator";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "askPassword";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "askUsername";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviders";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredUrl";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "splitToUsernameAndUnifiedUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findFirstHttpUrl";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "askPassword";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "askUsername";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "acquireData";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getProviders";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "splitToUsernameAndUnifiedUrl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ProviderAndData {
        @NotNull
        private final AuthDataProvider myProvider;
        @NotNull
        private final String myLogin;
        @NotNull
        private final String myPassword;

        private ProviderAndData(@NotNull AuthDataProvider provider, @NotNull String login, @NotNull String password) {
            if (provider == null) {
                ProviderAndData.$$$reportNull$$$0(0);
            }
            if (login == null) {
                ProviderAndData.$$$reportNull$$$0(1);
            }
            if (password == null) {
                ProviderAndData.$$$reportNull$$$0(2);
            }
            this.myProvider = provider;
            this.myLogin = login;
            this.myPassword = password;
        }

        @NotNull
        private AuthDataProvider getProvider() {
            AuthDataProvider authDataProvider = this.myProvider;
            if (authDataProvider == null) {
                ProviderAndData.$$$reportNull$$$0(3);
            }
            return authDataProvider;
        }

        @NotNull
        private String getLogin() {
            String string = this.myLogin;
            if (string == null) {
                ProviderAndData.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        private String getPassword() {
            String string = this.myPassword;
            if (string == null) {
                ProviderAndData.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NonNls
        public String toString() {
            return "provider='" + this.myProvider.getName() + "', login='" + this.myLogin + "'";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "login";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "password";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/commands/GitHttpGuiAuthenticator$ProviderAndData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/commands/GitHttpGuiAuthenticator$ProviderAndData";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProvider";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLogin";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPassword";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class CancelledProvider
    extends AuthDataProvider {
        CancelledProvider(@NotNull String url) {
            if (url == null) {
                CancelledProvider.$$$reportNull$$$0(0);
            }
            super(url);
        }

        @Override
        @NotNull
        String getName() {
            return "Cancelled";
        }

        @Override
        @Nullable
        AuthData getData() {
            return new AuthData("", "");
        }

        @Override
        @Nullable
        AuthData getDataForKnownLogin(@NotNull String login) {
            if (login == null) {
                CancelledProvider.$$$reportNull$$$0(1);
            }
            return new AuthData("", "");
        }

        @Override
        void onAuthSuccess() {
        }

        @Override
        void onAuthFailure() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "login";
                    break;
                }
            }
            objectArray2[1] = "git4idea/commands/GitHttpGuiAuthenticator$CancelledProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getDataForKnownLogin";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @VisibleForTesting
    static class PasswordSafeProvider
    extends AuthDataProvider {
        @NotNull
        private final DvcsRememberedInputs myRememberedInputs;
        @NotNull
        private final PasswordSafe myPasswordSafe;
        private AuthData myData;
        private boolean mySavePassword;

        PasswordSafeProvider(@NotNull String url, @NotNull DvcsRememberedInputs gitRememberedInputs, @NotNull PasswordSafe passwordSafe) {
            if (url == null) {
                PasswordSafeProvider.$$$reportNull$$$0(0);
            }
            if (gitRememberedInputs == null) {
                PasswordSafeProvider.$$$reportNull$$$0(1);
            }
            if (passwordSafe == null) {
                PasswordSafeProvider.$$$reportNull$$$0(2);
            }
            super(url);
            this.mySavePassword = false;
            this.myRememberedInputs = gitRememberedInputs;
            this.myPasswordSafe = passwordSafe;
        }

        @Override
        @NotNull
        public String getName() {
            return "Password Safe";
        }

        @Override
        @Nullable
        public AuthData getData() {
            String rememberedLogin = this.getRememberedLogin(this.myUrl);
            if (rememberedLogin == null) {
                return null;
            }
            return this.getDataForKnownLogin(rememberedLogin);
        }

        @Nullable
        public String getRememberedLogin(@NotNull String url) {
            if (url == null) {
                PasswordSafeProvider.$$$reportNull$$$0(3);
            }
            return this.myRememberedInputs.getUserNameForUrl(url);
        }

        @Override
        @Nullable
        public AuthData getDataForKnownLogin(@NotNull String login) {
            if (login == null) {
                PasswordSafeProvider.$$$reportNull$$$0(4);
            }
            String key = PasswordSafeProvider.makeKey(this.myUrl, login);
            Credentials credentials = PasswordSafe.getInstance().get(PasswordSafeProvider.credentialAttributes(key));
            String password = StringUtil.nullize((String)(credentials == null ? null : credentials.getPasswordAsString()));
            this.myData = new AuthData(login, password);
            return this.myData;
        }

        @Override
        public void onAuthSuccess() {
        }

        @Override
        public void onAuthFailure() {
            if (this.myData == null) {
                return;
            }
            String key = PasswordSafeProvider.makeKey(this.myUrl, this.myData.getLogin());
            CredentialAttributes attributes = PasswordSafeProvider.credentialAttributes(key);
            LOG.debug("forgetPassword. key=" + attributes.getUserName());
            this.myPasswordSafe.set(attributes, null);
        }

        public void setData(@NotNull AuthData data) {
            if (data == null) {
                PasswordSafeProvider.$$$reportNull$$$0(5);
            }
            this.myData = data;
        }

        public void setRememberPassword(boolean remember) {
            this.mySavePassword = remember;
            this.myPasswordSafe.setRememberPasswordByDefault(remember);
        }

        public boolean isRememberPasswordByDefault() {
            return this.myPasswordSafe.isRememberPasswordByDefault();
        }

        public void savePassword(@NotNull String url) {
            if (url == null) {
                PasswordSafeProvider.$$$reportNull$$$0(6);
            }
            if (this.myData == null || this.myData.getPassword() == null) {
                return;
            }
            this.myRememberedInputs.addUrl(url, this.myData.getLogin());
            if (!this.mySavePassword) {
                return;
            }
            String key = PasswordSafeProvider.makeKey(url, this.myData.getLogin());
            Credentials credentials = new Credentials(key, this.myData.getPassword());
            this.myPasswordSafe.set(PasswordSafeProvider.credentialAttributes(key), credentials);
        }

        @VisibleForTesting
        @NotNull
        static CredentialAttributes credentialAttributes(@NotNull String key) {
            if (key == null) {
                PasswordSafeProvider.$$$reportNull$$$0(7);
            }
            return new CredentialAttributes(CredentialAttributesKt.generateServiceName((String)GitBundle.message("label.credential.store.key.http.password", new Object[0]), (String)key), key);
        }

        @VisibleForTesting
        @NotNull
        static String makeKey(@NotNull String url, @Nullable String login) {
            if (url == null) {
                PasswordSafeProvider.$$$reportNull$$$0(8);
            }
            if (login == null) {
                String string = url;
                if (string == null) {
                    PasswordSafeProvider.$$$reportNull$$$0(9);
                }
                return string;
            }
            Couple pair = UriUtil.splitScheme((String)url);
            String scheme = (String)pair.getFirst();
            if (!StringUtil.isEmpty((String)scheme)) {
                String string = scheme + "://" + login + "@" + (String)pair.getSecond();
                if (string == null) {
                    PasswordSafeProvider.$$$reportNull$$$0(10);
                }
                return string;
            }
            String string = login + "@" + url;
            if (string == null) {
                PasswordSafeProvider.$$$reportNull$$$0(11);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gitRememberedInputs";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "passwordSafe";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "login";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/commands/GitHttpGuiAuthenticator$PasswordSafeProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/commands/GitHttpGuiAuthenticator$PasswordSafeProvider";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "makeKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getRememberedLogin";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getDataForKnownLogin";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setData";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "savePassword";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "credentialAttributes";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "makeKey";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DialogProvider
    extends AuthDataProvider {
        @NotNull
        private final Project myProject;
        @NotNull
        private final PasswordSafeProvider myPasswordSafeDelegate;
        private final boolean showActionForGitHelper;
        private boolean myCancelled;
        private boolean myDataForSession;

        protected DialogProvider(@NotNull String url, @NotNull Project project, @NotNull PasswordSafeProvider passwordSafeDelegate, boolean showActionForGitHelper) {
            if (url == null) {
                DialogProvider.$$$reportNull$$$0(0);
            }
            if (project == null) {
                DialogProvider.$$$reportNull$$$0(1);
            }
            if (passwordSafeDelegate == null) {
                DialogProvider.$$$reportNull$$$0(2);
            }
            super(url);
            this.myDataForSession = false;
            this.myProject = project;
            this.myPasswordSafeDelegate = passwordSafeDelegate;
            this.showActionForGitHelper = showActionForGitHelper;
        }

        @Override
        @NotNull
        public String getName() {
            return this.myDataForSession ? "Session Provider" : "Dialog";
        }

        @Override
        @Nullable
        public AuthData getData() {
            return this.getDataFromDialog(this.myUrl, this.myPasswordSafeDelegate.getRememberedLogin(this.myUrl), true);
        }

        @Override
        @Nullable
        public AuthData getDataForKnownLogin(@NotNull String login) {
            if (login == null) {
                DialogProvider.$$$reportNull$$$0(3);
            }
            return this.getDataFromDialog(this.myUrl, login, false);
        }

        @Override
        public void onAuthSuccess() {
            if (this.myDataForSession) {
                return;
            }
            this.myPasswordSafeDelegate.onAuthSuccess();
        }

        @Override
        public void onAuthFailure() {
            if (this.myDataForSession) {
                return;
            }
            this.myPasswordSafeDelegate.onAuthFailure();
        }

        @NotNull
        private AuthData getDataFromDialog(@NotNull String url, @Nullable String username, boolean editableUsername) {
            if (url == null) {
                DialogProvider.$$$reportNull$$$0(4);
            }
            HashMap<String, InteractiveGitHttpAuthDataProvider> providers = new HashMap<String, InteractiveGitHttpAuthDataProvider>();
            for (GitRepositoryHostingService service : (GitRepositoryHostingService[])GitRepositoryHostingService.EP_NAME.getExtensions()) {
                InteractiveGitHttpAuthDataProvider provider;
                InteractiveGitHttpAuthDataProvider interactiveGitHttpAuthDataProvider = provider = editableUsername || username == null ? service.getInteractiveAuthDataProvider(this.myProject, url) : service.getInteractiveAuthDataProvider(this.myProject, url, username);
                if (provider == null) continue;
                providers.put(service.getServiceDisplayName(), provider);
            }
            GitHttpLoginDialog dialog2 = this.showAuthDialog((String)UriUtil.splitScheme((String)url).second, username, editableUsername, providers);
            LOG.debug("Showed dialog:" + (dialog2.isOK() ? "OK" : "Cancel"));
            if (!dialog2.isOK()) {
                this.myCancelled = true;
                if (dialog2.getExitCode() == 2) {
                    LOG.debug("Credential helper is enabled");
                    GitVcsApplicationSettings.getInstance().setUseCredentialHelper(true);
                    throw new CredentialHelperShouldBeUsedException();
                }
                throw new ProcessCanceledException();
            }
            this.myPasswordSafeDelegate.setRememberPassword(dialog2.getRememberPassword());
            AuthData sessionAuthData = dialog2.getExternalAuthData();
            if (sessionAuthData != null) {
                this.myDataForSession = true;
                AuthData authData = sessionAuthData;
                if (authData == null) {
                    DialogProvider.$$$reportNull$$$0(5);
                }
                return authData;
            }
            AuthData authData = new AuthData(dialog2.getUsername(), dialog2.getPassword());
            this.myPasswordSafeDelegate.setData(authData);
            this.myPasswordSafeDelegate.savePassword(url);
            AuthData authData2 = authData;
            if (authData2 == null) {
                DialogProvider.$$$reportNull$$$0(6);
            }
            return authData2;
        }

        @NotNull
        private GitHttpLoginDialog showAuthDialog(@NotNull String url, @Nullable String username, boolean editableUsername, @NotNull Map<String, ? extends InteractiveGitHttpAuthDataProvider> interactiveProviders) {
            if (url == null) {
                DialogProvider.$$$reportNull$$$0(7);
            }
            if (interactiveProviders == null) {
                DialogProvider.$$$reportNull$$$0(8);
            }
            Ref dialogRef = Ref.create();
            ApplicationManager.getApplication().invokeAndWait(() -> {
                GitHttpLoginDialog dialog2 = new GitHttpLoginDialog(this.myProject, url, this.myPasswordSafeDelegate.isRememberPasswordByDefault(), username, editableUsername, this.showActionForGitHelper);
                dialog2.setInteractiveDataProviders(interactiveProviders);
                dialogRef.set((Object)dialog2);
                DialogManager.show(dialog2);
            }, ModalityState.any());
            GitHttpLoginDialog gitHttpLoginDialog = (GitHttpLoginDialog)((Object)dialogRef.get());
            if (gitHttpLoginDialog == null) {
                DialogProvider.$$$reportNull$$$0(9);
            }
            return gitHttpLoginDialog;
        }

        public boolean isCancelled() {
            return this.myCancelled;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "passwordSafeDelegate";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "login";
                    break;
                }
                case 5: 
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/commands/GitHttpGuiAuthenticator$DialogProvider";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interactiveProviders";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/commands/GitHttpGuiAuthenticator$DialogProvider";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataFromDialog";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "showAuthDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getDataForKnownLogin";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getDataFromDialog";
                    break;
                }
                case 5: 
                case 6: 
                case 9: {
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "showAuthDialog";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ExtensionAdapterProvider
    extends AuthDataProvider {
        @NotNull
        private final Project myProject;
        @NotNull
        private final GitHttpAuthDataProvider myDelegate;
        private AuthData myData;

        protected ExtensionAdapterProvider(@NotNull String url, @NotNull Project project, @NotNull GitHttpAuthDataProvider provider) {
            if (url == null) {
                ExtensionAdapterProvider.$$$reportNull$$$0(0);
            }
            if (project == null) {
                ExtensionAdapterProvider.$$$reportNull$$$0(1);
            }
            if (provider == null) {
                ExtensionAdapterProvider.$$$reportNull$$$0(2);
            }
            super(url);
            this.myData = null;
            this.myProject = project;
            this.myDelegate = provider;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myDelegate.getClass().getName();
            if (string == null) {
                ExtensionAdapterProvider.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        public AuthData getData() {
            this.myData = this.myDelegate.getAuthData(this.myProject, this.myUrl);
            return this.myData;
        }

        @Override
        public AuthData getDataForKnownLogin(@NotNull String login) {
            if (login == null) {
                ExtensionAdapterProvider.$$$reportNull$$$0(4);
            }
            this.myData = this.myDelegate.getAuthData(this.myProject, this.myUrl, login);
            return this.myData;
        }

        @Override
        public void onAuthSuccess() {
        }

        @Override
        public void onAuthFailure() {
            if (this.myData != null) {
                this.myDelegate.forgetPassword(this.myProject, this.myUrl, this.myData);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/commands/GitHttpGuiAuthenticator$ExtensionAdapterProvider";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "login";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/commands/GitHttpGuiAuthenticator$ExtensionAdapterProvider";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getDataForKnownLogin";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class AuthDataProvider {
        @NotNull
        protected final String myUrl;

        protected AuthDataProvider(@NotNull String url) {
            if (url == null) {
                AuthDataProvider.$$$reportNull$$$0(0);
            }
            this.myUrl = url;
        }

        @NonNls
        @NotNull
        abstract String getName();

        @Nullable
        abstract AuthData getData();

        @Nullable
        abstract AuthData getDataForKnownLogin(@NotNull String var1);

        abstract void onAuthSuccess();

        abstract void onAuthFailure();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "git4idea/commands/GitHttpGuiAuthenticator$AuthDataProvider", "<init>"));
        }
    }

    static class CredentialHelperShouldBeUsedException
    extends RuntimeException
    implements ControlFlowException {
        CredentialHelperShouldBeUsedException() {
        }
    }
}

