/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.amazonaws.retry.internal;

import org.gradle.internal.impldep.com.amazonaws.annotation.SdkInternalApi;
import org.gradle.internal.impldep.com.amazonaws.annotation.SdkTestInternalApi;
import org.gradle.internal.impldep.com.amazonaws.auth.profile.internal.BasicProfile;
import org.gradle.internal.impldep.com.amazonaws.auth.profile.internal.BasicProfileConfigFileLoader;
import org.gradle.internal.impldep.com.amazonaws.profile.path.AwsProfileFileLocationProvider;
import org.gradle.internal.impldep.com.amazonaws.retry.RetryMode;

@SdkInternalApi
public final class RetryModeResolver {
    private static final String PROFILE_PROPERTY = "retry_mode";
    private final BasicProfileConfigFileLoader configFileLoader;
    private final RetryMode retryMode;

    public RetryModeResolver() {
        this.configFileLoader = BasicProfileConfigFileLoader.INSTANCE;
        this.retryMode = this.resolveRetryMode();
    }

    @SdkTestInternalApi
    RetryModeResolver(AwsProfileFileLocationProvider configFileLocationProvider) {
        this.configFileLoader = new BasicProfileConfigFileLoader(configFileLocationProvider);
        this.retryMode = this.resolveRetryMode();
    }

    public RetryMode retryMode() {
        return this.retryMode;
    }

    private RetryMode systemProperty() {
        return RetryMode.fromName(System.getProperty("org.gradle.internal.impldep.com.amazonaws.sdk.retryMode"));
    }

    private RetryMode envVar() {
        return RetryMode.fromName(System.getenv("AWS_RETRY_MODE"));
    }

    private RetryMode resolveRetryMode() {
        RetryMode mode = this.envVar();
        if (mode != null) {
            return mode;
        }
        mode = this.systemProperty();
        if (mode != null) {
            return mode;
        }
        mode = this.profile();
        if (mode != null) {
            return mode;
        }
        return RetryMode.LEGACY;
    }

    private RetryMode profile() {
        BasicProfile profile = this.configFileLoader.getProfile();
        if (profile == null) {
            return null;
        }
        String val = profile.getPropertyValue(PROFILE_PROPERTY);
        return RetryMode.fromName(val);
    }
}

