/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.amazonaws.services.kms.model.transform;

import org.gradle.internal.impldep.com.amazonaws.SdkClientException;
import org.gradle.internal.impldep.com.amazonaws.annotation.SdkInternalApi;
import org.gradle.internal.impldep.com.amazonaws.protocol.MarshallLocation;
import org.gradle.internal.impldep.com.amazonaws.protocol.MarshallingInfo;
import org.gradle.internal.impldep.com.amazonaws.protocol.MarshallingType;
import org.gradle.internal.impldep.com.amazonaws.protocol.ProtocolMarshaller;
import org.gradle.internal.impldep.com.amazonaws.services.kms.model.Tag;

@SdkInternalApi
public class TagMarshaller {
    private static final MarshallingInfo<String> TAGKEY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TagKey").build();
    private static final MarshallingInfo<String> TAGVALUE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TagValue").build();
    private static final TagMarshaller instance = new TagMarshaller();

    public static TagMarshaller getInstance() {
        return instance;
    }

    public void marshall(Tag tag, ProtocolMarshaller protocolMarshaller) {
        if (tag == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(tag.getTagKey(), TAGKEY_BINDING);
            protocolMarshaller.marshall(tag.getTagValue(), TAGVALUE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

