/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.DependencyResolutionListener;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.ConfigurationResolver;
import org.gradle.api.internal.artifacts.configurations.ConfigurationsProvider;
import org.gradle.api.internal.artifacts.configurations.DefaultConfiguration;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.configurations.ProjectDependencyObservedListener;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyInternal;
import org.gradle.api.internal.artifacts.dsl.CapabilityNotationParserFactory;
import org.gradle.api.internal.artifacts.dsl.PublishArtifactNotationParserFactory;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.RootComponentMetadataBuilder;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.collections.DomainObjectCollectionFactory;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.configuration.internal.UserCodeApplicationContext;
import org.gradle.internal.Factory;
import org.gradle.internal.event.AnonymousListenerBroadcast;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.work.WorkerThreadRegistry;

@ThreadSafe
public class DefaultConfigurationFactory {
    private final Instantiator instantiator;
    private final ConfigurationResolver resolver;
    private final ListenerManager listenerManager;
    private final DependencyMetaDataProvider metaDataProvider;
    private final DomainObjectContext domainObjectContext;
    private final FileCollectionFactory fileCollectionFactory;
    private final BuildOperationExecutor buildOperationExecutor;
    private final NotationParser<Object, ConfigurablePublishArtifact> artifactNotationParser;
    private final NotationParser<Object, Capability> capabilityNotationParser;
    private final ImmutableAttributesFactory attributesFactory;
    private final DocumentationRegistry documentationRegistry;
    private final UserCodeApplicationContext userCodeApplicationContext;
    private final ProjectStateRegistry projectStateRegistry;
    private final WorkerThreadRegistry workerThreadRegistry;
    private final DomainObjectCollectionFactory domainObjectCollectionFactory;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;

    @Inject
    public DefaultConfigurationFactory(Instantiator instantiator, ConfigurationResolver resolver, ListenerManager listenerManager, DependencyMetaDataProvider metaDataProvider, DomainObjectContext domainObjectContext, FileCollectionFactory fileCollectionFactory, BuildOperationExecutor buildOperationExecutor, PublishArtifactNotationParserFactory artifactNotationParserFactory, ImmutableAttributesFactory attributesFactory, DocumentationRegistry documentationRegistry, UserCodeApplicationContext userCodeApplicationContext, ProjectStateRegistry projectStateRegistry, WorkerThreadRegistry workerThreadRegistry, DomainObjectCollectionFactory domainObjectCollectionFactory, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        this.instantiator = instantiator;
        this.resolver = resolver;
        this.listenerManager = listenerManager;
        this.metaDataProvider = metaDataProvider;
        this.domainObjectContext = domainObjectContext;
        this.fileCollectionFactory = fileCollectionFactory;
        this.buildOperationExecutor = buildOperationExecutor;
        this.artifactNotationParser = artifactNotationParserFactory.create();
        this.capabilityNotationParser = new CapabilityNotationParserFactory(true).create();
        this.attributesFactory = attributesFactory;
        this.documentationRegistry = documentationRegistry;
        this.userCodeApplicationContext = userCodeApplicationContext;
        this.projectStateRegistry = projectStateRegistry;
        this.workerThreadRegistry = workerThreadRegistry;
        this.domainObjectCollectionFactory = domainObjectCollectionFactory;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
    }

    DefaultConfiguration create(String name, ConfigurationsProvider configurationsProvider, Factory<ResolutionStrategyInternal> resolutionStrategyFactory, RootComponentMetadataBuilder rootComponentMetadataBuilder) {
        AnonymousListenerBroadcast<DependencyResolutionListener> dependencyResolutionListeners = this.listenerManager.createAnonymousBroadcaster(DependencyResolutionListener.class);
        return this.instantiator.newInstance(DefaultConfiguration.class, this.domainObjectContext, name, configurationsProvider, this.resolver, dependencyResolutionListeners, this.listenerManager.getBroadcaster(ProjectDependencyObservedListener.class), this.metaDataProvider, resolutionStrategyFactory, this.fileCollectionFactory, this.buildOperationExecutor, this.instantiator, this.artifactNotationParser, this.capabilityNotationParser, this.attributesFactory, rootComponentMetadataBuilder, this.documentationRegistry, this.userCodeApplicationContext, this.projectStateRegistry, this.workerThreadRegistry, this.domainObjectCollectionFactory, this.calculatedValueContainerFactory, this);
    }
}

