/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.maven;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.repositories.maven.MavenMetadata;
import org.gradle.api.internal.artifacts.repositories.maven.MavenMetadataLoader;
import org.gradle.api.internal.artifacts.repositories.resolver.ResourcePattern;
import org.gradle.api.resources.MissingResourceException;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.resolve.result.BuildableModuleVersionListingResolveResult;
import org.gradle.internal.resource.ExternalResourceName;

public class MavenVersionLister {
    private final MavenMetadataLoader mavenMetadataLoader;

    public MavenVersionLister(MavenMetadataLoader mavenMetadataLoader) {
        this.mavenMetadataLoader = mavenMetadataLoader;
    }

    public void listVersions(ModuleIdentifier module, List<ResourcePattern> patterns, BuildableModuleVersionListingResolveResult result2) {
        HashSet searched = Sets.newHashSet();
        ArrayList versions = Lists.newArrayList();
        boolean hasResult = false;
        for (ResourcePattern pattern : patterns) {
            ExternalResourceName metadataLocation = pattern.toModulePath(module).resolve("maven-metadata.xml");
            if (!searched.add(metadataLocation)) continue;
            result2.attempted(metadataLocation);
            try {
                MavenMetadata mavenMetaData = this.mavenMetadataLoader.load(metadataLocation);
                versions.addAll(mavenMetaData.versions);
                hasResult = true;
            }
            catch (MissingResourceException missingResourceException) {}
        }
        if (hasResult) {
            result2.listed(versions);
        }
    }
}

