/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality;

import java.io.File;
import org.gradle.api.Plugin;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.plugins.GroovyBasePlugin;
import org.gradle.api.plugins.quality.CodeNarc;
import org.gradle.api.plugins.quality.CodeNarcExtension;
import org.gradle.api.plugins.quality.CodeQualityExtension;
import org.gradle.api.plugins.quality.internal.AbstractCodeQualityPlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.GroovySourceDirectorySet;
import org.gradle.api.tasks.SourceSet;

public class CodeNarcPlugin
extends AbstractCodeQualityPlugin<CodeNarc> {
    public static final String DEFAULT_CODENARC_VERSION = "2.0.0";
    private CodeNarcExtension extension;

    @Override
    protected String getToolName() {
        return "CodeNarc";
    }

    @Override
    protected Class<CodeNarc> getTaskType() {
        return CodeNarc.class;
    }

    @Override
    protected Class<? extends Plugin> getBasePlugin() {
        return GroovyBasePlugin.class;
    }

    @Override
    protected CodeQualityExtension createExtension() {
        this.extension = this.project.getExtensions().create("codenarc", CodeNarcExtension.class, this.project);
        this.extension.setToolVersion(DEFAULT_CODENARC_VERSION);
        this.extension.setConfig(this.project.getResources().getText().fromFile(this.project.getRootProject().file("config/codenarc/codenarc.xml")));
        this.extension.setMaxPriority1Violations(0);
        this.extension.setMaxPriority2Violations(0);
        this.extension.setMaxPriority3Violations(0);
        this.extension.setReportFormat("html");
        return this.extension;
    }

    @Override
    protected void configureConfiguration(Configuration configuration2) {
        this.configureDefaultDependencies(configuration2);
    }

    @Override
    protected void configureTaskDefaults(CodeNarc task, String baseName) {
        Configuration configuration2 = this.project.getConfigurations().getAt(this.getConfigurationName());
        this.configureTaskConventionMapping(configuration2, task);
        this.configureReportsConventionMapping(task, baseName);
    }

    private void configureDefaultDependencies(Configuration configuration2) {
        configuration2.defaultDependencies(dependencies -> dependencies.add(this.project.getDependencies().create("org.codenarc:CodeNarc:" + this.extension.getToolVersion())));
    }

    private void configureTaskConventionMapping(Configuration configuration2, CodeNarc task) {
        ConventionMapping taskMapping = task.getConventionMapping();
        taskMapping.map("codenarcClasspath", () -> configuration2);
        taskMapping.map("config", () -> this.extension.getConfig());
        taskMapping.map("maxPriority1Violations", () -> this.extension.getMaxPriority1Violations());
        taskMapping.map("maxPriority2Violations", () -> this.extension.getMaxPriority2Violations());
        taskMapping.map("maxPriority3Violations", () -> this.extension.getMaxPriority3Violations());
        taskMapping.map("ignoreFailures", () -> this.extension.isIgnoreFailures());
    }

    private void configureReportsConventionMapping(CodeNarc task, String baseName) {
        ProjectLayout layout2 = this.project.getLayout();
        ProviderFactory providers = this.project.getProviders();
        Provider<String> reportFormat = providers.provider(() -> this.extension.getReportFormat());
        Provider<RegularFile> reportsDir = layout2.file(providers.provider(() -> this.extension.getReportsDir()));
        task.getReports().all(SerializableLambdas.action(report2 -> {
            report2.getRequired().convention(providers.provider(() -> report2.getName().equals(reportFormat.get())));
            report2.getOutputLocation().convention(layout2.getProjectDirectory().file(providers.provider(() -> {
                String fileSuffix = report2.getName().equals("text") ? "txt" : report2.getName();
                return new File(((RegularFile)reportsDir.get()).getAsFile(), baseName + "." + fileSuffix).getAbsolutePath();
            })));
        }));
    }

    @Override
    protected void configureForSourceSet(SourceSet sourceSet, CodeNarc task) {
        task.setDescription("Run CodeNarc analysis for " + sourceSet.getName() + " classes");
        SourceDirectorySet groovySourceSet = sourceSet.getExtensions().getByType(GroovySourceDirectorySet.class);
        task.setSource(groovySourceSet.matching(filter -> filter.include("**/*.groovy")));
    }
}

