/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.diagnostics.ProjectBasedReportTask;
import org.gradle.api.tasks.diagnostics.internal.ConfigurationFinder;
import org.gradle.api.tasks.diagnostics.internal.DependencyReportRenderer;
import org.gradle.api.tasks.diagnostics.internal.ReportRenderer;
import org.gradle.api.tasks.diagnostics.internal.dependencies.AsciiDependencyReportRenderer;
import org.gradle.api.tasks.options.Option;
import org.gradle.internal.deprecation.DeprecatableConfiguration;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Abstract super-class, not to be instantiated directly")
public abstract class AbstractDependencyReportTask
extends ProjectBasedReportTask {
    private DependencyReportRenderer renderer = new AsciiDependencyReportRenderer();
    private Set<Configuration> configurations;

    @Override
    public ReportRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(DependencyReportRenderer renderer) {
        this.renderer = renderer;
    }

    @Override
    public void generate(Project project) throws IOException {
        TreeSet<Configuration> sortedConfigurations = new TreeSet<Configuration>(Comparator.comparing(Configuration::getName));
        sortedConfigurations.addAll(this.getReportConfigurations());
        for (Configuration configuration2 : sortedConfigurations) {
            this.renderer.startConfiguration(configuration2);
            this.renderer.render(configuration2);
            this.renderer.completeConfiguration(configuration2);
        }
    }

    private Set<Configuration> getReportConfigurations() {
        return this.configurations != null ? this.configurations : this.getNonDeprecatedTaskConfigurations();
    }

    @Internal
    public Set<Configuration> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(Set<Configuration> configurations) {
        this.configurations = configurations;
    }

    @Option(option="configuration", description="The configuration to generate the report for.")
    public void setConfiguration(String configurationName) {
        this.configurations = Collections.singleton(ConfigurationFinder.find(this.getTaskConfigurations(), configurationName));
    }

    private Set<Configuration> getNonDeprecatedTaskConfigurations() {
        HashSet<Configuration> filteredConfigurations = new HashSet<Configuration>();
        for (Configuration configuration2 : this.getTaskConfigurations()) {
            if (((DeprecatableConfiguration)configuration2).isFullyDeprecated()) continue;
            filteredConfigurations.add(configuration2);
        }
        return filteredConfigurations;
    }

    @Internal
    public abstract ConfigurationContainer getTaskConfigurations();
}

