/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.gradle.api.CircularReferenceException;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.TaskInternal;
import org.gradle.composite.internal.BuildController;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.TaskNode;
import org.gradle.execution.plan.TaskNodeFactory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.build.BuildLifecycleController;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildWorkGraph;
import org.gradle.internal.build.ExecutionResult;
import org.gradle.internal.build.ExportedTaskNode;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.graph.CachingDirectedGraphWalker;
import org.gradle.internal.graph.DirectedGraphRenderer;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.work.WorkerLeaseService;

class DefaultBuildController
implements BuildController,
Stoppable {
    private final BuildWorkGraph workGraph;
    private final Set<ExportedTaskNode> scheduled = new LinkedHashSet<ExportedTaskNode>();
    private final Set<ExportedTaskNode> queuedForExecution = new LinkedHashSet<ExportedTaskNode>();
    private final WorkerLeaseService workerLeaseService;
    private State state = State.DiscoveringTasks;
    private final Lock lock = new ReentrantLock();
    private final Condition stateChange = this.lock.newCondition();
    private boolean finished;
    private final List<Throwable> executionFailures = new ArrayList<Throwable>();

    public DefaultBuildController(BuildState build, WorkerLeaseService workerLeaseService) {
        this.workerLeaseService = workerLeaseService;
        this.workGraph = build.getWorkGraph().newWorkGraph();
    }

    @Override
    public void queueForExecution(ExportedTaskNode taskNode) {
        this.assertInState(State.DiscoveringTasks);
        this.queuedForExecution.add(taskNode);
    }

    @Override
    public void populateWorkGraph(Consumer<? super BuildLifecycleController.WorkGraphBuilder> action) {
        this.assertInState(State.DiscoveringTasks);
        this.workGraph.populateWorkGraph(action);
    }

    @Override
    public boolean scheduleQueuedTasks() {
        this.assertInState(State.DiscoveringTasks);
        this.queuedForExecution.removeAll(this.scheduled);
        if (this.queuedForExecution.isEmpty()) {
            return false;
        }
        boolean added = this.workGraph.schedule(this.queuedForExecution);
        this.scheduled.addAll(this.queuedForExecution);
        this.queuedForExecution.clear();
        return added;
    }

    @Override
    public void finalizeWorkGraph() {
        this.assertInState(State.DiscoveringTasks);
        if (!this.queuedForExecution.isEmpty()) {
            throw new IllegalStateException("Queued tasks have not been scheduled.");
        }
        HashSet<TaskInternal> visited = new HashSet<TaskInternal>();
        HashSet<TaskInternal> visiting = new HashSet<TaskInternal>();
        for (ExportedTaskNode node : this.scheduled) {
            this.checkForCyclesFor(node.getTask(), visited, visiting);
        }
        this.workGraph.finalizeGraph();
        this.state = State.ReadyToRun;
    }

    @Override
    public void startExecution(ExecutorService executorService) {
        this.assertInState(State.ReadyToRun);
        executorService.submit(new BuildOpRunnable(CurrentBuildOperationRef.instance().get()));
        this.state = State.RunningTasks;
    }

    @Override
    public ExecutionResult<Void> awaitCompletion() {
        this.assertInState(State.RunningTasks);
        this.doAwaitCompletion();
        this.state = State.Finished;
        this.lock.lock();
        try {
            ExecutionResult<Void> executionResult = ExecutionResult.maybeFailed(this.executionFailures);
            return executionResult;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void stop() {
        if (this.state == State.RunningTasks) {
            throw new IllegalStateException("Build is currently running tasks.");
        }
    }

    private void doAwaitCompletion() {
        this.workerLeaseService.blocking(() -> {
            this.lock.lock();
            try {
                while (!this.finished) {
                    this.awaitStateChange();
                }
            }
            finally {
                this.lock.unlock();
            }
        });
    }

    private void assertInState(State expectedState) {
        if (this.state != expectedState) {
            throw new IllegalStateException("Build is in unexpected state: " + (Object)((Object)this.state));
        }
    }

    private void checkForCyclesFor(TaskInternal task, Set<TaskInternal> visited, Set<TaskInternal> visiting) {
        if (visited.contains(task)) {
            return;
        }
        if (!visiting.add(task)) {
            CachingDirectedGraphWalker graphWalker = new CachingDirectedGraphWalker((node, values, connectedNodes) -> this.visitDependenciesOf((TaskInternal)node, connectedNodes::add));
            graphWalker.add((TaskInternal[])new TaskInternal[]{task});
            List<Set<TaskInternal>> cycles = graphWalker.findCycles();
            Set<TaskInternal> cycle = cycles.get(0);
            DirectedGraphRenderer<TaskInternal> graphRenderer = new DirectedGraphRenderer<TaskInternal>((node, output) -> output.withStyle(StyledTextOutput.Style.Identifier).text(node.getIdentityPath()), (node, values, connectedNodes) -> this.visitDependenciesOf((TaskInternal)node, dep -> {
                if (cycle.contains(dep)) {
                    connectedNodes.add(dep);
                }
            }));
            StringWriter writer2 = new StringWriter();
            graphRenderer.renderTo(task, writer2);
            throw new CircularReferenceException(String.format("Circular dependency between the following tasks:%n%s", writer2.toString()));
        }
        this.visitDependenciesOf(task, dep -> this.checkForCyclesFor((TaskInternal)dep, visited, visiting));
        visiting.remove(task);
        visited.add(task);
    }

    private void visitDependenciesOf(TaskInternal task, Consumer<TaskInternal> consumer) {
        TaskNodeFactory taskNodeFactory = ((GradleInternal)task.getProject().getGradle()).getServices().get(TaskNodeFactory.class);
        TaskNode node = taskNodeFactory.getOrCreateNode(task, -1);
        for (Node dependency : node.getAllSuccessors()) {
            if (!(dependency instanceof TaskNode)) continue;
            consumer.accept(((TaskNode)dependency).getTask());
        }
    }

    private void doRun() {
        try {
            this.workerLeaseService.runAsWorkerThread(this::doBuild);
        }
        catch (Throwable t) {
            this.executionFailed(t);
        }
        finally {
            this.markFinished();
        }
    }

    private void markFinished() {
        this.lock.lock();
        try {
            this.finished = true;
            this.stateChange.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void awaitStateChange() {
        try {
            this.stateChange.await();
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    private void doBuild() {
        ExecutionResult<Void> result2 = this.workGraph.runWork();
        this.executionFinished(result2);
    }

    private void executionFinished(ExecutionResult<Void> result2) {
        this.lock.lock();
        try {
            this.executionFailures.addAll(result2.getFailures());
        }
        finally {
            this.lock.unlock();
        }
    }

    private void executionFailed(Throwable failure) {
        this.lock.lock();
        try {
            this.executionFailures.add(failure);
        }
        finally {
            this.lock.unlock();
        }
    }

    private class BuildOpRunnable
    implements Runnable {
        private final BuildOperationRef parentBuildOperation;

        BuildOpRunnable(BuildOperationRef parentBuildOperation) {
            this.parentBuildOperation = parentBuildOperation;
        }

        @Override
        public void run() {
            CurrentBuildOperationRef.instance().set(this.parentBuildOperation);
            try {
                DefaultBuildController.this.doRun();
            }
            finally {
                CurrentBuildOperationRef.instance().set(null);
            }
        }
    }

    private static enum State {
        DiscoveringTasks,
        ReadyToRun,
        RunningTasks,
        Finished;

    }
}

