/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal.plugins;

import java.util.Optional;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectPublicationRegistry;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.plugin.use.PluginId;
import org.gradle.plugin.use.resolve.internal.PluginResolution;
import org.gradle.plugin.use.resolve.internal.PluginResolveContext;
import org.gradle.plugin.use.resolve.internal.local.PluginPublication;

class LocalPluginResolution
implements PluginResolution {
    private final PluginId pluginId;
    private final ProjectInternal producingProject;

    private LocalPluginResolution(PluginId pluginId, ProjectInternal producingProject) {
        this.pluginId = pluginId;
        this.producingProject = producingProject;
    }

    @Override
    public PluginId getPluginId() {
        return this.pluginId;
    }

    @Override
    public String getPluginVersion() {
        return this.producingProject.getVersion().toString();
    }

    @Override
    public void execute(PluginResolveContext context) {
        context.addLegacy(this.pluginId, this.producingProject.getDependencies().create(this.producingProject));
    }

    static Optional<PluginResolution> resolvePlugin(GradleInternal gradle, PluginId requestedPluginId) {
        ProjectPublicationRegistry publicationRegistry = gradle.getServices().get(ProjectPublicationRegistry.class);
        for (ProjectPublicationRegistry.Reference<PluginPublication> reference : publicationRegistry.getPublications(PluginPublication.class)) {
            PluginId pluginId = reference.get().getPluginId();
            if (!pluginId.equals(requestedPluginId)) continue;
            return Optional.of(new LocalPluginResolution(pluginId, reference.getProducingProject()));
        }
        return Optional.empty();
    }
}

