/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.changes;

import org.gradle.api.Describable;
import org.gradle.internal.execution.history.changes.ChangeContainer;
import org.gradle.internal.execution.history.changes.ChangeVisitor;
import org.gradle.internal.execution.history.changes.DescriptiveChange;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;
import org.gradle.internal.snapshot.impl.KnownImplementationSnapshot;

public class ImplementationChanges
implements ChangeContainer {
    private final ImplementationSnapshot previousImplementation;
    private final ImmutableList<ImplementationSnapshot> previousAdditionalImplementations;
    private final KnownImplementationSnapshot currentImplementation;
    private final ImmutableList<KnownImplementationSnapshot> currentAdditionalImplementations;
    private final Describable executable;

    public ImplementationChanges(ImplementationSnapshot previousImplementation, ImmutableList<ImplementationSnapshot> previousAdditionalImplementations, KnownImplementationSnapshot currentImplementation, ImmutableList<KnownImplementationSnapshot> currentAdditionalImplementations, Describable executable) {
        this.previousImplementation = previousImplementation;
        this.previousAdditionalImplementations = previousAdditionalImplementations;
        this.currentImplementation = currentImplementation;
        this.currentAdditionalImplementations = currentAdditionalImplementations;
        this.executable = executable;
    }

    @Override
    public boolean accept(ChangeVisitor visitor) {
        if (!this.currentImplementation.getTypeName().equals(this.previousImplementation.getTypeName())) {
            return visitor.visitChange(new DescriptiveChange("The type of %s has changed from '%s' to '%s'.", this.executable.getDisplayName(), this.previousImplementation.getTypeName(), this.currentImplementation.getTypeName()));
        }
        if (this.previousImplementation.isUnknown()) {
            return visitor.visitChange(new DescriptiveChange("The implementation of %s has changed.", this.executable.getDisplayName()));
        }
        if (!this.currentImplementation.getClassLoaderHash().equals(this.previousImplementation.getClassLoaderHash())) {
            return visitor.visitChange(new DescriptiveChange("Class path of %s has changed from %s to %s.", this.executable.getDisplayName(), this.previousImplementation.getClassLoaderHash(), this.currentImplementation.getClassLoaderHash()));
        }
        if (!this.currentAdditionalImplementations.equals(this.previousAdditionalImplementations)) {
            return visitor.visitChange(new DescriptiveChange("One or more additional actions for %s have changed.", this.executable.getDisplayName()));
        }
        return true;
    }
}

