/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.filewatch.jdk7;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.WatchService;
import java.util.concurrent.ExecutorService;
import org.gradle.api.Action;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.filewatch.FileWatcher;
import org.gradle.internal.filewatch.FileWatcherFactory;
import org.gradle.internal.filewatch.FileWatcherListener;
import org.gradle.internal.filewatch.jdk7.WatchServiceFileWatcherBacking;
import org.gradle.internal.impldep.com.google.common.util.concurrent.ListeningExecutorService;
import org.gradle.internal.impldep.com.google.common.util.concurrent.MoreExecutors;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;

public class Jdk7FileWatcherFactory
implements FileWatcherFactory {
    private final ListeningExecutorService executor;
    private final FileSystem fileSystem;

    public Jdk7FileWatcherFactory(ExecutorService executor, FileSystem fileSystem) {
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)executor);
        this.fileSystem = fileSystem;
    }

    @Override
    public FileWatcher watch(Action<? super Throwable> onError, FileWatcherListener listener2) {
        try {
            WatchService watchService = FileSystems.getDefault().newWatchService();
            WatchServiceFileWatcherBacking backing = new WatchServiceFileWatcherBacking(onError, listener2, watchService);
            return backing.start(this.executor);
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }
}

