/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.scala.tasks;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Incubating;
import org.gradle.api.JavaVersion;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.tasks.compile.CleaningJavaCompiler;
import org.gradle.api.internal.tasks.compile.CompilerForkUtils;
import org.gradle.api.internal.tasks.compile.HasCompileOptions;
import org.gradle.api.internal.tasks.compile.MinimalJavaCompilerDaemonForkOptions;
import org.gradle.api.internal.tasks.scala.DefaultScalaJavaJointCompileSpec;
import org.gradle.api.internal.tasks.scala.DefaultScalaJavaJointCompileSpecFactory;
import org.gradle.api.internal.tasks.scala.MinimalScalaCompileOptions;
import org.gradle.api.internal.tasks.scala.ScalaCompileSpec;
import org.gradle.api.internal.tasks.scala.ScalaJavaJointCompileSpec;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.LocalState;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.scala.IncrementalCompileOptions;
import org.gradle.internal.buildevents.BuildStartedTime;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.impldep.com.google.common.io.Files;
import org.gradle.internal.jvm.Jvm;
import org.gradle.jvm.toolchain.JavaInstallationMetadata;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.scala.tasks.BaseScalaCompileOptions;
import org.gradle.util.internal.GFileUtils;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Abstract super-class, not to be instantiated directly")
public abstract class AbstractScalaCompile
extends AbstractCompile
implements HasCompileOptions {
    protected static final Logger LOGGER = Logging.getLogger(AbstractScalaCompile.class);
    private final BaseScalaCompileOptions scalaCompileOptions;
    private final CompileOptions compileOptions;
    private final RegularFileProperty analysisMappingFile;
    private final ConfigurableFileCollection analysisFiles;
    private final Property<JavaLauncher> javaLauncher;

    protected AbstractScalaCompile(BaseScalaCompileOptions scalaCompileOptions) {
        ObjectFactory objectFactory = this.getObjectFactory();
        this.analysisMappingFile = objectFactory.fileProperty();
        this.analysisFiles = this.getProject().files(new Object[0]);
        this.compileOptions = objectFactory.newInstance(CompileOptions.class, new Object[0]);
        this.scalaCompileOptions = scalaCompileOptions;
        this.scalaCompileOptions.setIncrementalOptions(objectFactory.newInstance(IncrementalCompileOptions.class, new Object[0]));
        this.javaLauncher = objectFactory.property(JavaLauncher.class);
        CompilerForkUtils.doNotCacheIfForkingViaExecutable(this.compileOptions, this.getOutputs());
    }

    @Nested
    public BaseScalaCompileOptions getScalaCompileOptions() {
        return this.scalaCompileOptions;
    }

    @Override
    @Nested
    public CompileOptions getOptions() {
        return this.compileOptions;
    }

    protected abstract Compiler<ScalaJavaJointCompileSpec> getCompiler(ScalaJavaJointCompileSpec var1);

    @TaskAction
    public void compile() {
        ScalaJavaJointCompileSpec spec = this.createSpec();
        this.configureIncrementalCompilation(spec);
        Compiler<ScalaJavaJointCompileSpec> compiler = this.getCompiler(spec);
        if (this.isNonIncrementalCompilation()) {
            compiler = new CleaningJavaCompiler<ScalaJavaJointCompileSpec>(compiler, this.getOutputs(), this.getDeleter());
        }
        compiler.execute(spec);
    }

    @Incubating
    @Internal
    public Property<JavaLauncher> getJavaLauncher() {
        return this.javaLauncher;
    }

    private boolean isNonIncrementalCompilation() {
        File analysisFile = this.getScalaCompileOptions().getIncrementalOptions().getAnalysisFile().getAsFile().get();
        if (!analysisFile.exists()) {
            LOGGER.info("Zinc is doing a full recompile since the analysis file doesn't exist");
            return true;
        }
        return false;
    }

    @Nullable
    @Internal
    protected JavaInstallationMetadata getToolchain() {
        return this.javaLauncher.map(JavaLauncher::getMetadata).getOrNull();
    }

    protected ScalaJavaJointCompileSpec createSpec() {
        this.validateConfiguration();
        DefaultScalaJavaJointCompileSpec spec = (DefaultScalaJavaJointCompileSpec)new DefaultScalaJavaJointCompileSpecFactory(this.compileOptions, this.getToolchain()).create();
        spec.setSourceFiles(this.getSource().getFiles());
        spec.setDestinationDir(this.getDestinationDirectory().getAsFile().get());
        spec.setWorkingDir(this.getProjectLayout().getProjectDirectory().getAsFile());
        spec.setTempDir(this.getTemporaryDir());
        spec.setCompileClasspath((List<File>)ImmutableList.copyOf((Iterable)this.getClasspath()));
        this.configureCompatibilityOptions(spec);
        spec.setCompileOptions(this.getOptions());
        spec.setScalaCompileOptions(new MinimalScalaCompileOptions(this.scalaCompileOptions));
        spec.setAnnotationProcessorPath((List<File>)(this.compileOptions.getAnnotationProcessorPath() == null ? ImmutableList.of() : ImmutableList.copyOf((Iterable)this.compileOptions.getAnnotationProcessorPath())));
        spec.setBuildStartTimestamp(this.getServices().get(BuildStartedTime.class).getStartTime());
        this.configureExecutable(spec.getCompileOptions().getForkOptions());
        return spec;
    }

    private void configureExecutable(MinimalJavaCompilerDaemonForkOptions forkOptions) {
        if (this.javaLauncher.isPresent()) {
            forkOptions.setExecutable(((JavaLauncher)this.javaLauncher.get()).getExecutablePath().getAsFile().getAbsolutePath());
        } else {
            forkOptions.setExecutable(Jvm.current().getJavaExecutable().getAbsolutePath());
        }
    }

    private void configureCompatibilityOptions(DefaultScalaJavaJointCompileSpec spec) {
        JavaInstallationMetadata toolchain = this.getToolchain();
        if (toolchain != null) {
            boolean isSourceOrTargetConfigured = false;
            if (super.getSourceCompatibility() != null) {
                spec.setSourceCompatibility(this.getSourceCompatibility());
                isSourceOrTargetConfigured = true;
            }
            if (super.getTargetCompatibility() != null) {
                spec.setTargetCompatibility(this.getTargetCompatibility());
                isSourceOrTargetConfigured = true;
            }
            if (!isSourceOrTargetConfigured) {
                String languageVersion = toolchain.getLanguageVersion().toString();
                spec.setSourceCompatibility(languageVersion);
                spec.setTargetCompatibility(languageVersion);
            }
        } else {
            spec.setSourceCompatibility(this.getSourceCompatibility());
            spec.setTargetCompatibility(this.getTargetCompatibility());
        }
    }

    private void validateConfiguration() {
        if (this.javaLauncher.isPresent()) {
            Preconditions.checkState((this.getOptions().getForkOptions().getJavaHome() == null ? 1 : 0) != 0, (Object)"Must not use `javaHome` property on `ForkOptions` together with `javaLauncher` property");
            Preconditions.checkState((this.getOptions().getForkOptions().getExecutable() == null ? 1 : 0) != 0, (Object)"Must not use `executable` property on `ForkOptions` together with `javaLauncher` property");
        }
    }

    private void configureIncrementalCompilation(ScalaCompileSpec spec) {
        IncrementalCompileOptions incrementalOptions = this.scalaCompileOptions.getIncrementalOptions();
        File analysisFile = incrementalOptions.getAnalysisFile().getAsFile().get();
        File classpathBackupDir = incrementalOptions.getClassfileBackupDir().getAsFile().get();
        Map<File, File> globalAnalysisMap = this.resolveAnalysisMappingsForOtherProjects();
        spec.setAnalysisMap(globalAnalysisMap);
        spec.setAnalysisFile(analysisFile);
        spec.setClassfileBackupDir(classpathBackupDir);
        if (incrementalOptions.getPublishedCode().isPresent()) {
            File publishedCode = incrementalOptions.getPublishedCode().getAsFile().get();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("scala-incremental Analysis file: {}", analysisFile);
                LOGGER.debug("scala-incremental Classfile backup dir: {}", classpathBackupDir);
                LOGGER.debug("scala-incremental Published code: {}", publishedCode);
            }
            File analysisMapping = this.getAnalysisMappingFile().getAsFile().get();
            GFileUtils.writeFile(publishedCode.getAbsolutePath() + "\n" + analysisFile.getAbsolutePath(), analysisMapping);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("scala-incremental Analysis map: {}", globalAnalysisMap);
        }
    }

    private Map<File, File> resolveAnalysisMappingsForOtherProjects() {
        HashMap analysisMap = Maps.newHashMap();
        for (File mapping : this.analysisFiles.getFiles()) {
            if (!mapping.exists()) continue;
            try {
                List lines = Files.readLines((File)mapping, (Charset)Charset.defaultCharset());
                assert (lines.size() == 2);
                analysisMap.put(new File((String)lines.get(0)), new File((String)lines.get(1)));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return analysisMap;
    }

    @Override
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileTree getSource() {
        return super.getSource();
    }

    @Input
    protected String getJvmVersion() {
        if (this.javaLauncher.isPresent()) {
            return ((JavaLauncher)this.javaLauncher.get()).getMetadata().getLanguageVersion().toString();
        }
        return JavaVersion.current().getMajorVersion();
    }

    @Internal
    public ConfigurableFileCollection getAnalysisFiles() {
        return this.analysisFiles;
    }

    @LocalState
    public RegularFileProperty getAnalysisMappingFile() {
        return this.analysisMappingFile;
    }

    @Inject
    protected Deleter getDeleter() {
        throw new UnsupportedOperationException("Decorator takes care of injection");
    }

    @Inject
    protected ProjectLayout getProjectLayout() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ObjectFactory getObjectFactory() {
        throw new UnsupportedOperationException();
    }
}

