/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class UnsignedShortArrayList
implements Cloneable {
    private char[] myData;
    private int mySize;

    public UnsignedShortArrayList(int initialCapacity) {
        this.myData = new char[initialCapacity];
    }

    public UnsignedShortArrayList() {
        this(10);
    }

    public void trimToSize() {
        if (this.mySize < this.myData.length) {
            this.myData = ArrayUtil.realloc(this.myData, this.mySize);
        }
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.myData.length;
        if (minCapacity > oldCapacity) {
            char[] oldData = this.myData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.myData = new char[newCapacity];
            System.arraycopy(oldData, 0, this.myData, 0, this.mySize);
        }
    }

    public void fill(int fromIndex, int toIndex, int value) {
        UnsignedShortArrayList.assertShort(value);
        if (toIndex > this.mySize) {
            this.ensureCapacity(toIndex);
            this.mySize = toIndex;
        }
        Arrays.fill(this.myData, fromIndex, toIndex, (char)value);
    }

    public int size() {
        return this.mySize;
    }

    public boolean isEmpty() {
        return this.mySize == 0;
    }

    public boolean contains(int element) {
        UnsignedShortArrayList.assertShort(element);
        return this.indexOf(element) >= 0;
    }

    public int indexOf(int element) {
        UnsignedShortArrayList.assertShort(element);
        return this.indexOf(element, 0, this.mySize);
    }

    public int indexOf(int element, int startIndex, int endIndex) {
        UnsignedShortArrayList.assertShort(element);
        if (startIndex < 0 || endIndex < startIndex || endIndex > this.mySize) {
            throw new IndexOutOfBoundsException("startIndex: " + startIndex + "; endIndex: " + endIndex + "; mySize: " + this.mySize);
        }
        for (int i = startIndex; i < endIndex; ++i) {
            if (element != this.myData[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(int element) {
        UnsignedShortArrayList.assertShort(element);
        for (int i = this.mySize - 1; i >= 0; --i) {
            if (element != this.myData[i]) continue;
            return i;
        }
        return -1;
    }

    public Object clone() {
        try {
            UnsignedShortArrayList v = (UnsignedShortArrayList)super.clone();
            v.myData = (char[])this.myData.clone();
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public int @NotNull [] toArray() {
        int[] nArray = this.toArray(0, this.mySize);
        if (nArray == null) {
            UnsignedShortArrayList.$$$reportNull$$$0(0);
        }
        return nArray;
    }

    public int @NotNull [] toArray(int @NotNull [] a) {
        if (a == null) {
            UnsignedShortArrayList.$$$reportNull$$$0(1);
        }
        if (a.length < this.mySize) {
            a = new int[this.mySize];
        }
        for (int i = 0; i < this.mySize; ++i) {
            int c;
            a[i] = c = this.myData[i];
        }
        if (a == null) {
            UnsignedShortArrayList.$$$reportNull$$$0(2);
        }
        return a;
    }

    public int @NotNull [] toArray(int startIndex, int length) {
        int[] result = new int[length];
        for (int i = startIndex; i < length; ++i) {
            int c;
            result[i - startIndex] = c = this.myData[i];
        }
        if (result == null) {
            UnsignedShortArrayList.$$$reportNull$$$0(3);
        }
        return result;
    }

    public int get(int index) {
        this.checkRange(index);
        return this.myData[index];
    }

    public int getQuick(int index) {
        return this.myData[index];
    }

    public int set(int index, int element) {
        this.checkRange(index);
        char oldValue = this.myData[index];
        this.setQuick(index, element);
        return oldValue;
    }

    public void setQuick(int index, int element) {
        UnsignedShortArrayList.assertShort(element);
        this.myData[index] = (char)element;
    }

    private static void assertShort(int element) {
        assert (element >= 0 && element < 65536) : element;
    }

    public void add(int element) {
        this.ensureCapacity(this.mySize + 1);
        this.setQuick(this.mySize++, element);
    }

    public void add(int index, int element) {
        if (index > this.mySize || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.mySize);
        }
        this.ensureCapacity(this.mySize + 1);
        System.arraycopy(this.myData, index, this.myData, index + 1, this.mySize - index);
        this.setQuick(index, element);
        ++this.mySize;
    }

    public int remove(int index) {
        this.checkRange(index);
        char oldValue = this.myData[index];
        int numMoved = this.mySize - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.myData, index + 1, this.myData, index, numMoved);
        }
        --this.mySize;
        return oldValue;
    }

    public void clear() {
        this.mySize = 0;
    }

    public void removeRange(int fromIndex, int toIndex) {
        int numMoved = this.mySize - toIndex;
        System.arraycopy(this.myData, toIndex, this.myData, fromIndex, numMoved);
        this.mySize -= toIndex - fromIndex;
    }

    public void copyRange(int fromIndex, int length, int toIndex) {
        if (length < 0 || fromIndex < 0 || fromIndex + length > this.mySize || toIndex < 0 || toIndex + length > this.mySize) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + "; length: " + length + "; toIndex: " + toIndex + "; mySize: " + this.mySize);
        }
        System.arraycopy(this.myData, fromIndex, this.myData, toIndex, length);
    }

    private void checkRange(int index) {
        if (index >= this.mySize || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.mySize);
        }
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/UnsignedShortArrayList";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/UnsignedShortArrayList";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

