/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.WriteActionAware;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UastContextKt;

public class ActionIsNotPreviewFriendlyInspection
extends DevKitUastInspectionBase {
    private static final String[] METHODS_TO_IGNORE_CLASS = new String[]{"generatePreview", "getFileModifierForPreview", "applyFixForPreview", "startInWriteAction"};
    private static final Set<String> ALLOWED_METHOD_LOCATIONS = Set.of(LocalQuickFix.class.getName(), FileModifier.class.getName(), LocalQuickFixOnPsiElement.class.getName(), WriteActionAware.class.getName());
    private static final Set<String> ALLOWED_FIELD_TYPES = Set.of(String.class.getName(), Class.class.getName(), Integer.class.getName(), Boolean.class.getName());

    public ActionIsNotPreviewFriendlyInspection() {
        super(UClass.class);
    }

    public ProblemDescriptor @Nullable [] checkClass(@NotNull UClass node, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiElement sourcePsi;
        if (node == null) {
            ActionIsNotPreviewFriendlyInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            ActionIsNotPreviewFriendlyInspection.$$$reportNull$$$0(1);
        }
        if ((sourcePsi = node.getSourcePsi()) == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        PsiClass psiClass = node.getJavaPsi();
        if (psiClass.isInterface()) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (!InheritanceUtil.isInheritor((PsiClass)psiClass, (String)LocalQuickFix.class.getName())) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (ActionIsNotPreviewFriendlyInspection.hasCustomPreviewStrategy(psiClass)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, sourcePsi.getContainingFile(), isOnTheFly);
        for (PsiField field : psiClass.getFields()) {
            PsiElement psiAnchor;
            UElement anchor;
            UField uField;
            String name;
            PsiClass fieldClass;
            PsiType type;
            if (field.hasModifierProperty("static") || field.hasAnnotation(FileModifier.SafeFieldForPreview.class.getCanonicalName()) || (type = field.getType().getDeepComponentType()) instanceof PsiPrimitiveType || !(type instanceof PsiClassType) || (fieldClass = ((PsiClassType)type).resolve()) == null || fieldClass.isEnum() || (name = fieldClass.getQualifiedName()) != null && ALLOWED_FIELD_TYPES.contains(name) || (uField = (UField)UastContextKt.toUElement((PsiElement)field, UField.class)) == null || (anchor = uField.getUastAnchor()) == null || (psiAnchor = anchor.getSourcePsi()) == null) continue;
            holder.registerProblem(psiAnchor, DevKitBundle.message("inspection.message.field.may.prevent.intention.preview.to.work.properly", new Object[0]), new LocalQuickFix[0]);
        }
        return holder.getResultsArray();
    }

    private static boolean hasCustomPreviewStrategy(PsiClass psiClass) {
        for (String methodName : METHODS_TO_IGNORE_CLASS) {
            for (PsiMethod method : psiClass.findMethodsByName(methodName, true)) {
                String className;
                PsiClass containingClass = method.getContainingClass();
                if (containingClass == null || (className = containingClass.getQualifiedName()) == null || ALLOWED_METHOD_LOCATIONS.contains(className)) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "node";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/devkit/inspections/ActionIsNotPreviewFriendlyInspection";
        objectArray[2] = "checkClass";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

