/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;

public class SerializableCtorInspection
extends DevKitUastInspectionBase {
    private static final String PROPERTY_MAPPING_ANNOTATION = "com.intellij.serialization.PropertyMapping";

    public SerializableCtorInspection() {
        super(UClass.class);
    }

    @Override
    protected boolean isAllowed(@NotNull ProblemsHolder holder) {
        if (holder == null) {
            SerializableCtorInspection.$$$reportNull$$$0(0);
        }
        return super.isAllowed(holder) && SerializableCtorInspection.propertyMappingAnnotationPresent(holder);
    }

    private static boolean propertyMappingAnnotationPresent(@NotNull ProblemsHolder holder) {
        Project project;
        if (holder == null) {
            SerializableCtorInspection.$$$reportNull$$$0(1);
        }
        return JavaPsiFacade.getInstance((Project)(project = holder.getProject())).findClass(PROPERTY_MAPPING_ANNOTATION, holder.getFile().getResolveScope()) != null;
    }

    public ProblemDescriptor @Nullable [] checkClass(@NotNull UClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            SerializableCtorInspection.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            SerializableCtorInspection.$$$reportNull$$$0(3);
        }
        if (!InheritanceUtil.isInheritor((PsiClass)aClass.getJavaPsi(), (String)"java.io.Serializable")) {
            return null;
        }
        if (!SerializableCtorInspection.hasFieldWithName(aClass, "serialVersionUID")) {
            return null;
        }
        ProblemsHolder holder = SerializableCtorInspection.createProblemsHolder(aClass, manager, isOnTheFly);
        for (UMethod constructor : SerializableCtorInspection.getConstructors(aClass)) {
            PsiElement constructorAnchor;
            if (SerializableCtorInspection.isAnnotatedWithPropertyMapping(constructor) || (constructorAnchor = UElementKt.getSourcePsiElement((UElement)constructor.getUastAnchor())) == null) continue;
            holder.registerProblem(constructorAnchor, DevKitBundle.message("inspection.serializable.constructor.message", new Object[0]), SerializableCtorInspection.createFixes(aClass, holder, constructor));
        }
        return holder.getResultsArray();
    }

    private static boolean hasFieldWithName(@NotNull UClass aClass, @NotNull String name) {
        if (aClass == null) {
            SerializableCtorInspection.$$$reportNull$$$0(4);
        }
        if (name == null) {
            SerializableCtorInspection.$$$reportNull$$$0(5);
        }
        return ContainerUtil.exists((Object[])aClass.getFields(), field -> name.equals(field.getName()));
    }

    private static ProblemsHolder createProblemsHolder(@NotNull UClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiElement sourcePsi;
        if (aClass == null) {
            SerializableCtorInspection.$$$reportNull$$$0(6);
        }
        if (manager == null) {
            SerializableCtorInspection.$$$reportNull$$$0(7);
        }
        if ((sourcePsi = aClass.getSourcePsi()) != null) {
            return new ProblemsHolder(manager, sourcePsi.getContainingFile(), isOnTheFly);
        }
        throw new IllegalStateException("Could not create problems holder");
    }

    @NotNull
    private static List<UMethod> getConstructors(@NotNull UClass aClass) {
        if (aClass == null) {
            SerializableCtorInspection.$$$reportNull$$$0(8);
        }
        List list = ContainerUtil.filter((Object[])aClass.getMethods(), method -> method.isConstructor());
        if (list == null) {
            SerializableCtorInspection.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static boolean isAnnotatedWithPropertyMapping(UMethod constructor) {
        return ContainerUtil.exists((Iterable)constructor.getUAnnotations(), annotation -> PROPERTY_MAPPING_ANNOTATION.equals(annotation.getQualifiedName()));
    }

    private static LocalQuickFix[] createFixes(@NotNull UClass aClass, ProblemsHolder holder, UMethod constructor) {
        LocalQuickFix[] localQuickFixArray;
        if (aClass == null) {
            SerializableCtorInspection.$$$reportNull$$$0(10);
        }
        if (JavaLanguage.INSTANCE.is(aClass.getLang())) {
            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
            localQuickFixArray = localQuickFixArray2;
            localQuickFixArray2[0] = new AddAnnotationPsiFix(PROPERTY_MAPPING_ANNOTATION, (PsiModifierListOwner)constructor.getJavaPsi(), SerializableCtorInspection.createExpectedAnnotationAttributes(holder.getProject(), aClass, constructor), new String[0]);
        } else {
            localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
        }
        return localQuickFixArray;
    }

    private static PsiNameValuePair @NotNull [] createExpectedAnnotationAttributes(Project project, UClass aClass, UMethod constructor) {
        @NonNls StringBuilder builder = new StringBuilder("@PropertyMapping({");
        List parameters = constructor.getUastParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            Object name;
            if (i > 0) {
                builder.append(',');
            }
            if (!SerializableCtorInspection.hasFieldWithName(aClass, (String)(name = Objects.requireNonNull(((UParameter)parameters.get(i)).getName())))) {
                name = "my" + StringUtil.capitalize((String)name);
            }
            if (!SerializableCtorInspection.hasFieldWithName(aClass, (String)name)) {
                name = "??" + (String)name;
            }
            builder.append('\"').append((String)name).append('\"');
        }
        builder.append("})");
        PsiAnnotation annotation = JavaPsiFacade.getElementFactory((Project)project).createAnnotationFromText(builder.toString(), aClass.getSourcePsi());
        PsiNameValuePair[] psiNameValuePairArray = annotation.getParameterList().getAttributes();
        if (psiNameValuePairArray == null) {
            SerializableCtorInspection.$$$reportNull$$$0(11);
        }
        return psiNameValuePairArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/inspections/internal/SerializableCtorInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/internal/SerializableCtorInspection";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructors";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpectedAnnotationAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAllowed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "propertyMappingAnnotationPresent";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasFieldWithName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createProblemsHolder";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getConstructors";
                break;
            }
            case 9: 
            case 11: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createFixes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

