/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.references;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.find.FindModel;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.ide.presentation.Presentation;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.patterns.uast.UExpressionPattern;
import com.intellij.patterns.uast.UastPatterns;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.PsiType;
import com.intellij.psi.UastReferenceProvider;
import com.intellij.psi.UastReferenceRegistrar;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceUtil;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.ProjectIconsAccessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.util.PsiUtil;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

public class IconsReferencesContributor
extends PsiReferenceContributor
implements QueryExecutor<PsiReference, ReferencesSearch.SearchParameters> {
    @NonNls
    private static final String ALL_ICONS_FQN = "com.intellij.icons.AllIcons";
    @NonNls
    private static final String ALL_ICONS_NAME = "AllIcons";
    @NonNls
    private static final String PLATFORM_ICONS_MODULE = "intellij.platform.icons";
    @NonNls
    private static final String ICONS_MODULE = "icons";
    @NonNls
    private static final String ICONS_PACKAGE_PREFIX = "icons.";
    @NonNls
    private static final String COM_INTELLIJ_ICONS_PREFIX = "com.intellij.icons.";
    @NonNls
    private static final String ICONS_CLASSNAME_SUFFIX = "Icons";

    public boolean execute(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        PsiElement file;
        if (queryParameters == null) {
            IconsReferencesContributor.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            IconsReferencesContributor.$$$reportNull$$$0(1);
        }
        if ((file = queryParameters.getElementToSearch()) instanceof PsiBinaryFile) {
            Module module = (Module)ReadAction.compute(() -> ModuleUtilCore.findModuleForPsiElement((PsiElement)file));
            VirtualFile image = ((PsiBinaryFile)file).getVirtualFile();
            if (IconsReferencesContributor.isImage(image) && IconsReferencesContributor.isIconsModule(module)) {
                Project project = file.getProject();
                FindModel model = new FindModel();
                String path = IconsReferencesContributor.getPathToImage(image, module);
                model.setStringToFind(path);
                model.setCaseSensitive(true);
                model.setFindAll(true);
                model.setWholeWordsOnly(true);
                FindInProjectUtil.findUsages((FindModel)model, (Project)project, usage -> {
                    ApplicationManager.getApplication().runReadAction(() -> {
                        PsiElement element = usage.getElement();
                        ProperTextRange textRange = usage.getRangeInElement();
                        if (element != null && textRange != null) {
                            PsiElement start = element.findElementAt(textRange.getStartOffset());
                            PsiElement end = element.findElementAt(textRange.getEndOffset());
                            if (start != null && end != null) {
                                PsiFileReference reference;
                                PsiElement value = PsiTreeUtil.findCommonParent((PsiElement)start, (PsiElement)end);
                                if (value instanceof PsiJavaToken) {
                                    value = value.getParent();
                                }
                                if (value != null && (reference = FileReferenceUtil.findFileReference((PsiElement)value)) != null) {
                                    consumer.process((Object)reference);
                                }
                            }
                        }
                    });
                    return true;
                }, (FindUsagesProcessPresentation)new FindUsagesProcessPresentation(new UsageViewPresentation()));
            }
        }
        return true;
    }

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            IconsReferencesContributor.$$$reportNull$$$0(2);
        }
        IconsReferencesContributor.registerForPresentationAnnotation(registrar);
        IconsReferencesContributor.registerForIconLoaderMethods(registrar);
        IconsReferencesContributor.registerForIconXmlAttribute(registrar);
    }

    private static void registerForIconXmlAttribute(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            IconsReferencesContributor.$$$reportNull$$$0(3);
        }
        registrar.registerReferenceProvider((ElementPattern)XmlPatterns.xmlAttributeValue().withLocalName(new String[]{"icon"}), new PsiReferenceProvider(){

            public PsiReference @NotNull [] getReferencesByElement(final @NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!PsiUtil.isPluginXmlPsiElement(element)) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                PsiReference[] psiReferenceArray = new PsiReference[]{new IconPsiReferenceBase(element){

                    public PsiElement resolve() {
                        String value = ((XmlAttributeValue)element).getValue();
                        if (value.startsWith("/")) {
                            FileReference lastRef = new FileReferenceSet(element).getLastReference();
                            return lastRef != null ? lastRef.resolve() : null;
                        }
                        return IconsReferencesContributor.resolveIconPath(value, element);
                    }

                    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
                        PsiElement element2;
                        PsiElement resultForFile;
                        if (newElementName == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if ((resultForFile = this.handleFile(element2 = this.resolve(), lastRef -> lastRef.handleElementRename(newElementName))) != null) {
                            return resultForFile;
                        }
                        PsiElement resultForField = this.handleField(element2, newElementName);
                        if (resultForField != null) {
                            return resultForField;
                        }
                        return super.handleElementRename(newElementName);
                    }

                    public PsiElement bindToElement(@NotNull PsiElement element2) throws IncorrectOperationException {
                        PsiElement resultForFile;
                        if (element2 == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if ((resultForFile = this.handleFile(element2, lastRef -> lastRef.bindToElement(element2))) != null) {
                            return resultForFile;
                        }
                        PsiElement resultForField = this.handleField(element2, null);
                        if (resultForField != null) {
                            return resultForField;
                        }
                        return super.bindToElement(element2);
                    }

                    private PsiElement handleFile(PsiElement element2, Function<FileReference, PsiElement> callback) {
                        FileReference lastRef;
                        if (element2 instanceof PsiFile && (lastRef = new FileReferenceSet(element2).getLastReference()) != null) {
                            return callback.apply(lastRef);
                        }
                        return null;
                    }

                    @Nullable
                    private PsiElement handleField(PsiElement element2, @Nullable String newElementName) {
                        String classQualifiedName;
                        PsiClass containingClass;
                        if (element2 instanceof PsiField && (containingClass = ((PsiField)element2).getContainingClass()) != null && (classQualifiedName = containingClass.getQualifiedName()) != null) {
                            if (newElementName == null) {
                                newElementName = ((PsiField)element2).getName();
                            }
                            if (classQualifiedName.startsWith(IconsReferencesContributor.COM_INTELLIJ_ICONS_PREFIX)) {
                                return this.replace(classQualifiedName, newElementName, IconsReferencesContributor.COM_INTELLIJ_ICONS_PREFIX);
                            }
                            if (classQualifiedName.startsWith(IconsReferencesContributor.ICONS_PACKAGE_PREFIX)) {
                                return this.replace(classQualifiedName, newElementName, IconsReferencesContributor.ICONS_PACKAGE_PREFIX);
                            }
                            return ElementManipulators.handleContentChange((PsiElement)this.myElement, (String)(classQualifiedName + "." + newElementName));
                        }
                        return null;
                    }

                    private PsiElement replace(@NonNls String fqn, @NonNls String newName, @NonNls String pckg) {
                        XmlAttribute parent = (XmlAttribute)this.getElement().getParent();
                        parent.setValue(fqn.substring(pckg.length()) + "." + newName);
                        return parent.getValueElement();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "newElementName";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "element";
                                break;
                            }
                        }
                        objectArray2[1] = "org/jetbrains/idea/devkit/references/IconsReferencesContributor$1$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "handleElementRename";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "bindToElement";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }};
                if (psiReferenceArray == null) {
                    1.$$$reportNull$$$0(3);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/idea/devkit/references/IconsReferencesContributor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/idea/devkit/references/IconsReferencesContributor$1";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    private static void registerForIconLoaderMethods(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            IconsReferencesContributor.$$$reportNull$$$0(4);
        }
        PsiMethodPattern method = ((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("load")).definedInClass(ALL_ICONS_FQN);
        PsiJavaElementPattern.Capture findGetIconPattern = (PsiJavaElementPattern.Capture)PsiJavaPatterns.literalExpression().and((ElementPattern)PsiJavaPatterns.psiExpression().methodCallParameter(0, (ElementPattern)method));
        registrar.registerReferenceProvider((ElementPattern)findGetIconPattern, new PsiReferenceProvider(){

            public PsiReference @NotNull [] getReferencesByElement(final @NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (!PsiUtil.isIdeaProject(element.getProject())) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                FileReference[] fileReferenceArray = new FileReferenceSet(element){

                    protected Collection<PsiFileSystemItem> getExtraContexts() {
                        Module iconsModule = ModuleManager.getInstance((Project)element.getProject()).findModuleByName(IconsReferencesContributor.PLATFORM_ICONS_MODULE);
                        if (iconsModule == null) {
                            iconsModule = ModuleManager.getInstance((Project)element.getProject()).findModuleByName(IconsReferencesContributor.ICONS_MODULE);
                        }
                        if (iconsModule == null) {
                            return super.getExtraContexts();
                        }
                        SmartList result = new SmartList();
                        VirtualFile[] roots = ModuleRootManager.getInstance((Module)iconsModule).getSourceRoots();
                        PsiManager psiManager = element.getManager();
                        for (VirtualFile root : roots) {
                            PsiDirectory directory = psiManager.findDirectory(root);
                            ContainerUtil.addIfNotNull((Collection)result, (Object)directory);
                        }
                        return result;
                    }
                }.getAllReferences();
                if (fileReferenceArray == null) {
                    2.$$$reportNull$$$0(3);
                }
                return fileReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/idea/devkit/references/IconsReferencesContributor$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/idea/devkit/references/IconsReferencesContributor$2";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, 100.0);
    }

    private static void registerForPresentationAnnotation(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            IconsReferencesContributor.$$$reportNull$$$0(5);
        }
        UastReferenceRegistrar.registerUastReferenceProvider((PsiReferenceRegistrar)registrar, (ElementPattern)((UExpressionPattern)UastPatterns.injectionHostUExpression().sourcePsiFilter(psi -> PsiUtil.isPluginProject(psi.getProject()))).annotationParam(Presentation.class.getName(), "icon"), (UastReferenceProvider)UastReferenceRegistrar.uastInjectionHostReferenceProvider((uElement, referencePsiElement) -> new PsiReference[]{new IconPsiReferenceBase((PsiElement)referencePsiElement, (UExpression)uElement, (PsiLanguageInjectionHost)referencePsiElement){
            final /* synthetic */ UExpression val$uElement;
            final /* synthetic */ PsiLanguageInjectionHost val$referencePsiElement;
            {
                this.val$uElement = uExpression;
                this.val$referencePsiElement = psiLanguageInjectionHost;
                super(element);
            }

            public PsiElement resolve() {
                String value = UastUtils.evaluateString((UExpression)this.val$uElement);
                return IconsReferencesContributor.resolveIconPath(value, (PsiElement)this.val$referencePsiElement);
            }

            public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
                PsiElement field;
                PsiElement result;
                if (newElementName == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((result = this.handleElement(field = this.resolve(), newElementName)) != null) {
                    return result;
                }
                return super.handleElementRename(newElementName);
            }

            @Nullable
            private PsiElement handleElement(PsiElement element, @Nullable String newElementName) {
                String classQualifiedName;
                PsiClass containingClass;
                if (element instanceof PsiField && (containingClass = ((PsiField)element).getContainingClass()) != null && (classQualifiedName = containingClass.getQualifiedName()) != null) {
                    if (newElementName == null) {
                        newElementName = ((PsiField)element).getName();
                    }
                    if (classQualifiedName.startsWith(IconsReferencesContributor.COM_INTELLIJ_ICONS_PREFIX)) {
                        return this.replace(newElementName, classQualifiedName, IconsReferencesContributor.COM_INTELLIJ_ICONS_PREFIX);
                    }
                    if (classQualifiedName.startsWith(IconsReferencesContributor.ICONS_PACKAGE_PREFIX)) {
                        return this.replace(newElementName, classQualifiedName, IconsReferencesContributor.ICONS_PACKAGE_PREFIX);
                    }
                    return ElementManipulators.handleContentChange((PsiElement)this.myElement, (String)(classQualifiedName + "." + newElementName));
                }
                return null;
            }

            private PsiElement replace(@NonNls String newElementName, @NonNls String fqn, @NonNls String packageName) {
                String newValue = fqn.substring(packageName.length()) + "." + newElementName;
                return ElementManipulators.handleContentChange((PsiElement)this.getElement(), (String)newValue);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElementName", "org/jetbrains/idea/devkit/references/IconsReferencesContributor$3", "handleElementRename"));
            }
        }}), (double)100.0);
    }

    @NotNull
    @NonNls
    private static String getPathToImage(VirtualFile image, Module module) {
        String path = ModuleRootManager.getInstance((Module)module).getSourceRoots()[0].getPath();
        String string = "/" + FileUtil.getRelativePath((String)path, (String)image.getPath(), (char)'/');
        if (string == null) {
            IconsReferencesContributor.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static boolean isIconsModule(Module module) {
        return module != null && (ICONS_MODULE.equals(module.getName()) || PLATFORM_ICONS_MODULE.equals(module.getName())) && ModuleRootManager.getInstance((Module)module).getSourceRoots().length == 1;
    }

    private static boolean isImage(VirtualFile image) {
        FileTypeManager mgr = FileTypeManager.getInstance();
        return image != null && mgr.getFileTypeByFile(image) == mgr.getFileTypeByExtension("png");
    }

    @Nullable
    private static PsiField resolveIconPath(@NonNls @Nullable String path, PsiElement element) {
        if (path == null) {
            return null;
        }
        @NonNls List pathElements = StringUtil.split((String)path, (String)".");
        if (pathElements.size() < 2) {
            return null;
        }
        int iconsClassNameIdx = ContainerUtil.lastIndexOf((List)pathElements, s -> s.endsWith(ICONS_CLASSNAME_SUFFIX));
        if (iconsClassNameIdx == -1) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return null;
        }
        PsiClass iconClass = IconsReferencesContributor.findIconClass(module, StringUtil.join((Collection)ContainerUtil.getFirstItems((List)pathElements, (int)(iconsClassNameIdx + 1)), (String)"."), iconsClassNameIdx != 0);
        if (iconClass == null) {
            return null;
        }
        for (int i = iconsClassNameIdx + 1; i < pathElements.size() - 1; ++i) {
            if ((iconClass = iconClass.findInnerClassByName((String)pathElements.get(i), false)) != null) continue;
            return null;
        }
        return iconClass.findFieldByName((String)pathElements.get(pathElements.size() - 1), false);
    }

    @Nullable
    private static PsiClass findIconClass(Module module, @NonNls @NotNull String iconClass, boolean isQualifiedFqn) {
        if (iconClass == null) {
            IconsReferencesContributor.$$$reportNull$$$0(7);
        }
        Object adjustedIconClassFqn = isQualifiedFqn ? iconClass : (ALL_ICONS_NAME.equals(iconClass) ? ALL_ICONS_FQN : ICONS_PACKAGE_PREFIX + iconClass);
        GlobalSearchScope iconSearchScope = isQualifiedFqn ? GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)false) : GlobalSearchScope.allScope((Project)module.getProject());
        return JavaPsiFacade.getInstance((Project)module.getProject()).findClass((String)adjustedIconClassFqn, iconSearchScope);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryParameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/references/IconsReferencesContributor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/references/IconsReferencesContributor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathToImage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerReferenceProviders";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerForIconXmlAttribute";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerForIconLoaderMethods";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerForPresentationAnnotation";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findIconClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class IconPsiReferenceBase
    extends PsiReferenceBase<PsiElement>
    implements EmptyResolveMessageProvider {
        IconPsiReferenceBase(@NotNull PsiElement element) {
            if (element == null) {
                IconPsiReferenceBase.$$$reportNull$$$0(0);
            }
            super(element, true);
        }

        public Object @NotNull [] getVariants() {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myElement);
            if (module == null) {
                if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                    IconPsiReferenceBase.$$$reportNull$$$0(1);
                }
                return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
            }
            Project project = module.getProject();
            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
            GlobalSearchScope productionScope = GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)false);
            ArrayList<LookupElement> variants = new ArrayList<LookupElement>();
            IconPsiReferenceBase.addIconVariants(variants, javaPsiFacade.findClass(IconsReferencesContributor.ALL_ICONS_FQN, productionScope), false, Collections.emptyList());
            PsiPackage iconsPackage = javaPsiFacade.findPackage(IconsReferencesContributor.ICONS_MODULE);
            if (iconsPackage != null) {
                for (PsiClass psiClass2 : iconsPackage.getClasses(productionScope)) {
                    String className = psiClass2.getName();
                    if (className == null || !StringUtil.endsWith((CharSequence)className, (CharSequence)IconsReferencesContributor.ICONS_CLASSNAME_SUFFIX)) continue;
                    IconPsiReferenceBase.addIconVariants(variants, psiClass2, false, Collections.emptyList());
                }
            }
            GlobalSearchScope notIconsPackageScope = iconsPackage != null ? PackageScope.packageScope((PsiPackage)iconsPackage, (boolean)false) : GlobalSearchScope.EMPTY_SCOPE;
            Query allIconsSearch = AllClassesSearch.search((SearchScope)productionScope.intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)notIconsPackageScope)), (Project)project, s -> StringUtil.endsWith((CharSequence)s, (CharSequence)IconsReferencesContributor.ICONS_CLASSNAME_SUFFIX) && !s.equals(IconsReferencesContributor.ICONS_CLASSNAME_SUFFIX));
            allIconsSearch.forEach(psiClass -> {
                if (IconsReferencesContributor.ALL_ICONS_FQN.equals(psiClass.getQualifiedName()) || psiClass.isInterface() || psiClass.getContainingClass() != null || !psiClass.hasModifier(JvmModifier.PUBLIC)) {
                    return;
                }
                IconPsiReferenceBase.addIconVariants(variants, psiClass, true, Collections.emptyList());
            });
            Object[] objectArray = variants.toArray();
            if (objectArray == null) {
                IconPsiReferenceBase.$$$reportNull$$$0(2);
            }
            return objectArray;
        }

        private static void addIconVariants(List<LookupElement> variants, @Nullable PsiClass iconClass, boolean useFqn, List<PsiClass> containingClasses) {
            if (iconClass == null) {
                return;
            }
            Object classNamePrefix = useFqn ? (containingClasses.isEmpty() ? iconClass.getQualifiedName() : ((PsiClass)ContainerUtil.getLastItem(containingClasses)).getQualifiedName() + "." + iconClass.getName()) : (containingClasses.isEmpty() ? iconClass.getName() : StringUtil.join(containingClasses, aClass -> aClass.getName(), (String)".") + "." + iconClass.getName());
            for (PsiField field : iconClass.getFields()) {
                if (!ProjectIconsAccessor.isIconClassType((PsiType)field.getType())) continue;
                String iconPath = (String)classNamePrefix + "." + field.getName();
                LookupElementBuilder builder = LookupElementBuilder.create((Object)field, (String)iconPath).withRenderer((LookupElementRenderer)IconPathLookupElementRenderer.INSTANCE);
                variants.add((LookupElement)builder);
            }
            SmartList parents = new SmartList(containingClasses);
            parents.add(iconClass);
            for (PsiClass innerClass : iconClass.getInnerClasses()) {
                IconPsiReferenceBase.addIconVariants(variants, innerClass, useFqn, (List<PsiClass>)parents);
            }
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = DevKitBundle.message("inspections.presentation.cannot.resolve.icon", new Object[0]);
            if (string == null) {
                IconPsiReferenceBase.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/devkit/references/IconsReferencesContributor$IconPsiReferenceBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/devkit/references/IconsReferencesContributor$IconPsiReferenceBase";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedMessagePattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class IconPathLookupElementRenderer
        extends LookupElementRenderer<LookupElement> {
            private static final IconPathLookupElementRenderer INSTANCE = new IconPathLookupElementRenderer();

            private IconPathLookupElementRenderer() {
            }

            public void renderElement(LookupElement element, LookupElementPresentation presentation) {
                PsiField field = (PsiField)ObjectUtils.tryCast((Object)element.getPsiElement(), PsiField.class);
                assert (field != null);
                String iconPath = element.getLookupString();
                presentation.setItemText(iconPath);
                presentation.setStrikeout(field.isDeprecated());
                Icon resolveIcon = IconPathLookupElementRenderer.resolveIcon(field, iconPath);
                if (resolveIcon != null) {
                    if (ProjectIconsAccessor.hasProperSize((Icon)resolveIcon)) {
                        presentation.setIcon(resolveIcon);
                    } else {
                        presentation.setTailText(" (" + resolveIcon.getIconWidth() + "x" + resolveIcon.getIconHeight() + ")", true);
                    }
                }
            }

            @Nullable
            private static Icon resolveIcon(PsiField field, @NotNull String iconPath) {
                if (iconPath == null) {
                    IconPathLookupElementRenderer.$$$reportNull$$$0(0);
                }
                UField uField = (UField)UastContextKt.toUElement((PsiElement)field, UField.class);
                assert (uField != null);
                UExpression expression = uField.getUastInitializer();
                if (expression == null) {
                    return IconLoader.findIcon((String)iconPath, IconPsiReferenceBase.class, (boolean)false, (boolean)false);
                }
                ProjectIconsAccessor iconsAccessor = ProjectIconsAccessor.getInstance((Project)field.getProject());
                VirtualFile iconFile = iconsAccessor.resolveIconFile((UElement)expression);
                return iconFile == null ? null : iconsAccessor.getIcon(iconFile);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iconPath", "org/jetbrains/idea/devkit/references/IconsReferencesContributor$IconPsiReferenceBase$IconPathLookupElementRenderer", "resolveIcon"));
            }
        }
    }
}

