/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.run;

import com.google.common.io.PatternFilenameFilter;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;

public final class IdeaLicenseHelper {
    private static final Logger LOG = Logger.getInstance(IdeaLicenseHelper.class);
    @NonNls
    private static final String IDEA_KEY_FILE_PATTERN = "idea\\d+\\.key";

    public static void copyIDEALicense(String sandboxHome) {
        File sandboxSystemPath = new File(sandboxHome, "system");
        File systemPath = new File(PathManager.getSystemPath());
        File[] runningIdeaLicenses = systemPath.listFiles((FilenameFilter)new PatternFilenameFilter(IDEA_KEY_FILE_PATTERN));
        if (runningIdeaLicenses != null) {
            for (File license : runningIdeaLicenses) {
                File devIdeaLicense = new File(sandboxSystemPath, license.getName());
                if (devIdeaLicense.exists()) continue;
                try {
                    FileUtil.copy((File)license, (File)devIdeaLicense);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
    }
}

