/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.run;

import com.intellij.application.options.ModulesComboBox;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ui.DefaultJreSelector;
import com.intellij.execution.ui.JrePathEditor;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.run.PluginRunConfiguration;

public class PluginRunConfigurationEditor
extends SettingsEditor<PluginRunConfiguration>
implements PanelWithAnchor {
    private final ModulesComboBox myModules = new ModulesComboBox();
    private final JBLabel myModuleLabel = new JBLabel(ExecutionBundle.message((String)"application.configuration.use.classpath.and.jdk.of.module.label", (Object[])new Object[0]));
    private final LabeledComponent<RawCommandLineEditor> myVMParameters = new LabeledComponent();
    private final LabeledComponent<RawCommandLineEditor> myProgramParameters = new LabeledComponent();
    private JComponent anchor;
    private final JrePathEditor myJrePathEditor;
    private final PluginRunConfiguration myPRC;

    public PluginRunConfigurationEditor(PluginRunConfiguration prc) {
        this.myPRC = prc;
        this.setAnchor((JComponent)this.myModuleLabel);
        this.myJrePathEditor = new JrePathEditor(DefaultJreSelector.fromModuleDependencies((ModulesComboBox)this.myModules, (boolean)true));
        this.myJrePathEditor.setAnchor((JComponent)this.myModuleLabel);
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(@Nullable JComponent anchor) {
        this.anchor = anchor;
        this.myModuleLabel.setAnchor(anchor);
        this.myVMParameters.setAnchor(anchor);
        this.myProgramParameters.setAnchor(anchor);
    }

    public void resetEditorFrom(@NotNull PluginRunConfiguration prc) {
        if (prc == null) {
            PluginRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        this.myModules.setSelectedModule(prc.getModule());
        this.getVMParameters().setText(prc.VM_PARAMETERS);
        this.getProgramParameters().setText(prc.PROGRAM_PARAMETERS);
        this.myJrePathEditor.setPathOrName(prc.getAlternativeJrePath(), prc.isAlternativeJreEnabled());
    }

    public void applyEditorTo(@NotNull PluginRunConfiguration prc) {
        if (prc == null) {
            PluginRunConfigurationEditor.$$$reportNull$$$0(1);
        }
        prc.setModule(this.myModules.getSelectedModule());
        prc.VM_PARAMETERS = this.getVMParameters().getText();
        prc.PROGRAM_PARAMETERS = this.getProgramParameters().getText();
        prc.setAlternativeJrePath(this.myJrePathEditor.getJrePathOrName());
        prc.setAlternativeJreEnabled(this.myJrePathEditor.isAlternativeJreSelected());
    }

    @NotNull
    public JComponent createEditor() {
        this.myModules.fillModules(this.myPRC.getProject(), (ModuleType)PluginModuleType.getInstance());
        JPanel wholePanel = new JPanel(new GridBagLayout());
        this.myVMParameters.setText(DevKitBundle.message("vm.parameters", new Object[0]));
        this.myVMParameters.setComponent((JComponent)new RawCommandLineEditor());
        ((RawCommandLineEditor)this.myVMParameters.getComponent()).setDialogCaption(this.myVMParameters.getRawText());
        this.myVMParameters.setLabelLocation("West");
        this.myVMParameters.setAnchor((JComponent)this.myModuleLabel);
        this.myProgramParameters.setText(DevKitBundle.message("program.parameters", new Object[0]));
        this.myProgramParameters.setComponent((JComponent)new RawCommandLineEditor());
        ((RawCommandLineEditor)this.myProgramParameters.getComponent()).setDialogCaption(this.myProgramParameters.getRawText());
        this.myProgramParameters.setLabelLocation("West");
        this.myProgramParameters.setAnchor((JComponent)this.myModuleLabel);
        GridBagConstraints gc = new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 17, 2, (Insets)JBUI.insets((int)2, (int)0, (int)0, (int)0), 10, 0);
        wholePanel.add((Component)this.myVMParameters, gc);
        wholePanel.add((Component)this.myProgramParameters, gc);
        gc.gridwidth = 1;
        gc.gridy = 3;
        gc.weightx = 0.0;
        wholePanel.add((Component)this.myModuleLabel, gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        wholePanel.add((Component)this.myModules, gc);
        gc.gridx = 0;
        gc.gridy = 4;
        gc.gridwidth = 2;
        wholePanel.add((Component)this.myJrePathEditor, gc);
        gc.weighty = 1.0;
        gc.gridy = 5;
        wholePanel.add((Component)Box.createVerticalBox(), gc);
        JPanel jPanel = wholePanel;
        if (jPanel == null) {
            PluginRunConfigurationEditor.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    public RawCommandLineEditor getVMParameters() {
        return (RawCommandLineEditor)this.myVMParameters.getComponent();
    }

    public RawCommandLineEditor getProgramParameters() {
        return (RawCommandLineEditor)this.myProgramParameters.getComponent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prc";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/run/PluginRunConfigurationEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/run/PluginRunConfigurationEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

