/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.themes.metadata;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.extension.SchemaType;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/idea/devkit/themes/metadata/ThemeMetadataJsonSchemaProviderFactory;", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaProviderFactory;", "()V", "getProviders", "", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaFileProvider;", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.devkit"})
public final class ThemeMetadataJsonSchemaProviderFactory
implements JsonSchemaProviderFactory {
    @NonNls
    @NotNull
    public static final String EXTENSION = "themeMetadata.json";
    @NonNls
    private static final String DOT_EXTENSION = ".themeMetadata.json";
    @NonNls
    private static final String THEME_METADATA_SCHEMA = "/schemes/themeMetadata.schema.json";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public List<JsonSchemaFileProvider> getProviders(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List<JsonSchemaFileProvider> list = Collections.singletonList(new JsonSchemaFileProvider(){

            @NotNull
            public String getName() {
                String string = DevKitBundle.message("theme.metadata.json.display.name", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DevKitBundle.message(\"th\u2026adata.json.display.name\")");
                return string;
            }

            public boolean isAvailable(@NotNull VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                CharSequence charSequence = file.getNameSequence();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"file.nameSequence");
                return StringsKt.endsWith$default((CharSequence)charSequence, (CharSequence)".themeMetadata.json", (boolean)false, (int)2, null);
            }

            @Nullable
            public VirtualFile getSchemaFile() {
                return VfsUtil.findFileByURL((URL)this.getClass().getResource("/schemes/themeMetadata.schema.json"));
            }

            @NotNull
            public SchemaType getSchemaType() {
                return SchemaType.embeddedSchema;
            }
        });
        Intrinsics.checkNotNullExpressionValue(list, (String)"Collections.singletonLis\u2026ype.embeddedSchema\n    })");
        return list;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/idea/devkit/themes/metadata/ThemeMetadataJsonSchemaProviderFactory$Companion;", "", "()V", "DOT_EXTENSION", "", "EXTENSION", "THEME_METADATA_SCHEMA", "intellij.devkit"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

