/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.issue;

import com.intellij.build.BuildConsoleUtils;
import com.intellij.build.FileNavigatable;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.build.issue.quickfix.OpenFileQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.util.PlatformUtils;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.initialization.BuildLayoutParameters;
import org.gradle.tooling.GradleConnectionException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.issue.quickfix.GradleSettingsQuickFix;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSystemSettings;
import org.jetbrains.plugins.gradle.util.GradleBundle;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/gradle/issue/GradleOutOfMemoryIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "()V", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "intellij.gradle.common"})
@ApiStatus.Experimental
public final class GradleOutOfMemoryIssueChecker
implements GradleIssueChecker {
    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        CharSequence charSequence;
        StringBuilder stringBuilder;
        String fileTypePrefix;
        CharSequence fileName;
        Path commonGradleProperties;
        Object gradleUserHomeDir;
        Object object;
        Intrinsics.checkNotNullParameter((Object)issueData, (String)"issueData");
        if (!(issueData.getError() instanceof GradleConnectionException)) {
            return null;
        }
        Throwable rootCause = (Throwable)GradleExecutionErrorHandler.getRootCauseAndLocation((Throwable)issueData.getError()).first;
        if (!(rootCause instanceof OutOfMemoryError)) {
            return null;
        }
        StringBuilder quickFixDescription = new StringBuilder();
        ArrayList<Object> quickFixes = new ArrayList<Object>();
        Path projectGradleProperties = Paths.get(issueData.getProjectPath(), "gradle.properties");
        String subItemPadding = "   ";
        Path path = projectGradleProperties;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"projectGradleProperties");
        if (PathKt.isFile((Path)path)) {
            OpenFileQuickFix openFileQuickFix = new OpenFileQuickFix(projectGradleProperties, "org.gradle.jvmargs");
            quickFixDescription.append(subItemPadding + "<a href=\"" + openFileQuickFix.getId() + "\">gradle.properties</a> in project root directory\n");
            quickFixes.add(openFileQuickFix);
        }
        if ((object = issueData.getBuildEnvironment()) == null || (object = object.getGradle()) == null || (object = object.getGradleUserHome()) == null) {
            object = new BuildLayoutParameters().getGradleUserHomeDir();
        }
        Object object2 = gradleUserHomeDir = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"gradleUserHomeDir");
        Path path2 = commonGradleProperties = Paths.get(((File)object2).getPath(), "gradle.properties");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"commonGradleProperties");
        if (PathKt.isFile((Path)path2)) {
            OpenFileQuickFix openFileQuickFix = new OpenFileQuickFix(commonGradleProperties, "org.gradle.jvmargs");
            quickFixDescription.append(subItemPadding + "<a href=\"" + openFileQuickFix.getId() + "\">gradle.properties</a> in GRADLE_USER_HOME directory\n");
            quickFixes.add(openFileQuickFix);
        }
        GradleSystemSettings gradleSystemSettings = GradleSystemSettings.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)gradleSystemSettings, (String)"GradleSystemSettings.getInstance()");
        String gradleVmOptions = gradleSystemSettings.getGradleVmOptions();
        CharSequence charSequence2 = gradleVmOptions;
        if (!(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) && Intrinsics.areEqual((Object)"AndroidStudio", (Object)PlatformUtils.getPlatformPrefix()) ^ true) {
            GradleSettingsQuickFix gradleSettingsFix2 = new GradleSettingsQuickFix(issueData.getProjectPath(), true, new BiPredicate(gradleVmOptions){
                final /* synthetic */ String $gradleVmOptions;

                public final boolean test(@NotNull GradleProjectSettings $noName_0, @NotNull GradleProjectSettings $noName_1) {
                    Intrinsics.checkNotNullParameter((Object)((Object)$noName_0), (String)"<anonymous parameter 0>");
                    Intrinsics.checkNotNullParameter((Object)((Object)$noName_1), (String)"<anonymous parameter 1>");
                    GradleSystemSettings gradleSystemSettings = GradleSystemSettings.getInstance();
                    Intrinsics.checkNotNullExpressionValue((Object)gradleSystemSettings, (String)"GradleSystemSettings.getInstance()");
                    return Intrinsics.areEqual((Object)this.$gradleVmOptions, (Object)gradleSystemSettings.getGradleVmOptions()) ^ true;
                }
                {
                    this.$gradleVmOptions = string2;
                }
            }, GradleBundle.message("gradle.settings.text.vm.options", new Object[0]));
            quickFixes.add(gradleSettingsFix2);
            quickFixDescription.append(subItemPadding + "<a href=\"" + gradleSettingsFix2.getId() + "\">IDE Gradle VM options</a> \n");
        }
        StringBuilder issueDescription = new StringBuilder();
        if (issueData.getFilePosition() != null) {
            File file = issueData.getFilePosition().getFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"issueData.filePosition.file");
            CharSequence charSequence3 = fileName = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence3, (String)"fileName");
            fileTypePrefix = StringsKt.endsWith((String)charSequence3, (String)"gradle", (boolean)true) || StringsKt.endsWith((String)fileName, (String)"gradle.kts", (boolean)true) ? "Build file " : "";
            stringBuilder = issueDescription;
            File file2 = issueData.getFilePosition().getFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"issueData.filePosition.file");
            charSequence = StringsKt.trimIndent((String)("\n      * Where:\n      " + fileTypePrefix + "'" + file2.getPath() + "' line: " + (issueData.getFilePosition().getStartLine() + 1) + "\n\n    "));
            StringBuilder stringBuilder2 = stringBuilder.append((String)charSequence);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            StringBuilder stringBuilder3 = stringBuilder2.append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append('\\n')");
        }
        fileName = issueDescription;
        fileTypePrefix = StringsKt.trimIndent((String)("\n      * What went wrong:\n      Out of memory. " + rootCause.getMessage() + "\n    "));
        stringBuilder = ((StringBuilder)fileName).append(fileTypePrefix);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
        charSequence = stringBuilder.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"append('\\n')");
        fileName = quickFixDescription;
        if (fileName.length() > 0) {
            issueDescription.append("\nPossible solution:\n");
            issueDescription.append(" - Check the JVM memory arguments defined for the gradle process in:\n");
            issueDescription.append((CharSequence)quickFixDescription);
        }
        String string2 = issueDescription.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"issueDescription.toString()");
        String description = string2;
        String string3 = rootCause.getMessage();
        if (string3 == null) {
            string3 = description;
        }
        String string4 = BuildConsoleUtils.getMessageTitle((String)string3);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getMessageTitle(rootCause.message ?: description)");
        String title = string4;
        return new BuildIssue(issueData, title, description, quickFixes){
            @NotNull
            private final String title;
            @NotNull
            private final String description;
            @NotNull
            private final ArrayList<BuildIssueQuickFix> quickFixes;
            final /* synthetic */ GradleIssueData $issueData;
            final /* synthetic */ String $title;
            final /* synthetic */ String $description;
            final /* synthetic */ ArrayList $quickFixes;

            @NotNull
            public String getTitle() {
                return this.title;
            }

            @NotNull
            public String getDescription() {
                return this.description;
            }

            @NotNull
            public ArrayList<BuildIssueQuickFix> getQuickFixes() {
                return this.quickFixes;
            }

            @Nullable
            public Navigatable getNavigatable(@NotNull Project project) {
                FileNavigatable fileNavigatable;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                FilePosition filePosition = this.$issueData.getFilePosition();
                if (filePosition != null) {
                    FilePosition filePosition2;
                    FilePosition $this$run = filePosition2 = filePosition;
                    boolean bl = false;
                    fileNavigatable = new FileNavigatable(project, this.$issueData.getFilePosition());
                } else {
                    fileNavigatable = null;
                }
                return (Navigatable)fileNavigatable;
            }
            {
                this.$issueData = $captured_local_variable$0;
                this.$title = $captured_local_variable$1;
                this.$description = $captured_local_variable$2;
                this.$quickFixes = $captured_local_variable$3;
                this.title = $captured_local_variable$1;
                this.description = $captured_local_variable$2;
                this.quickFixes = $captured_local_variable$3;
            }
        };
    }

    @Override
    public boolean consumeBuildOutputFailureMessage(@NotNull String message, @NotNull String failureCause, @Nullable String stacktrace, @Nullable FilePosition location, @NotNull Object parentEventId, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)failureCause, (String)"failureCause");
        Intrinsics.checkNotNullParameter((Object)parentEventId, (String)"parentEventId");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        return GradleIssueChecker.DefaultImpls.consumeBuildOutputFailureMessage(this, message, failureCause, stacktrace, location, parentEventId, messageConsumer);
    }
}

