/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model.data;

import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractExternalEntityData;
import com.intellij.serialization.PropertyMapping;
import com.intellij.util.containers.Interner;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BuildScriptClasspathData
extends AbstractExternalEntityData {
    @NotNull
    public static final Key<BuildScriptClasspathData> KEY = Key.create(BuildScriptClasspathData.class, (int)(ProjectKeys.LIBRARY_DEPENDENCY.getProcessingWeight() + 1));
    @Nullable
    private File gradleHomeDir;
    @NotNull
    private final List<ClasspathEntry> classpathEntries;

    @PropertyMapping(value={"owner", "classpathEntries"})
    public BuildScriptClasspathData(@NotNull ProjectSystemId owner, @NotNull List<ClasspathEntry> classpathEntries) {
        if (owner == null) {
            BuildScriptClasspathData.$$$reportNull$$$0(0);
        }
        if (classpathEntries == null) {
            BuildScriptClasspathData.$$$reportNull$$$0(1);
        }
        super(owner);
        this.classpathEntries = classpathEntries;
    }

    @Nullable
    public File getGradleHomeDir() {
        return this.gradleHomeDir;
    }

    public void setGradleHomeDir(@Nullable File gradleHomeDir) {
        this.gradleHomeDir = gradleHomeDir;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildScriptClasspathData data = (BuildScriptClasspathData)((Object)o);
        return Objects.equals(this.gradleHomeDir, data.gradleHomeDir) && this.classpathEntries.equals(data.classpathEntries);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.gradleHomeDir, this.classpathEntries);
    }

    @NotNull
    public List<ClasspathEntry> getClasspathEntries() {
        List<ClasspathEntry> list2 = this.classpathEntries;
        if (list2 == null) {
            BuildScriptClasspathData.$$$reportNull$$$0(2);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classpathEntries";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/model/data/BuildScriptClasspathData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/model/data/BuildScriptClasspathData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasspathEntries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class ClasspathEntry {
        private static final Interner<ClasspathEntry> ourEntryInterner = Interner.createWeakInterner();
        @NotNull
        private final Set<String> classesFile;
        @NotNull
        private final Set<String> sourcesFile;
        @NotNull
        private final Set<String> javadocFile;

        public static ClasspathEntry create(@NotNull Set<String> classesFile, @NotNull Set<String> sourcesFile, @NotNull Set<String> javadocFile) {
            if (classesFile == null) {
                ClasspathEntry.$$$reportNull$$$0(0);
            }
            if (sourcesFile == null) {
                ClasspathEntry.$$$reportNull$$$0(1);
            }
            if (javadocFile == null) {
                ClasspathEntry.$$$reportNull$$$0(2);
            }
            return (ClasspathEntry)ourEntryInterner.intern((Object)new ClasspathEntry(classesFile, sourcesFile, javadocFile));
        }

        @Deprecated(forRemoval=true)
        @PropertyMapping(value={"classesFile", "sourcesFile", "javadocFile"})
        public ClasspathEntry(@NotNull Set<String> classesFile, @NotNull Set<String> sourcesFile, @NotNull Set<String> javadocFile) {
            if (classesFile == null) {
                ClasspathEntry.$$$reportNull$$$0(3);
            }
            if (sourcesFile == null) {
                ClasspathEntry.$$$reportNull$$$0(4);
            }
            if (javadocFile == null) {
                ClasspathEntry.$$$reportNull$$$0(5);
            }
            this.classesFile = classesFile;
            this.sourcesFile = sourcesFile;
            this.javadocFile = javadocFile;
        }

        @NotNull
        public Set<String> getClassesFile() {
            Set<String> set = this.classesFile;
            if (set == null) {
                ClasspathEntry.$$$reportNull$$$0(6);
            }
            return set;
        }

        @NotNull
        public Set<String> getSourcesFile() {
            Set<String> set = this.sourcesFile;
            if (set == null) {
                ClasspathEntry.$$$reportNull$$$0(7);
            }
            return set;
        }

        @NotNull
        public Set<String> getJavadocFile() {
            Set<String> set = this.javadocFile;
            if (set == null) {
                ClasspathEntry.$$$reportNull$$$0(8);
            }
            return set;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClasspathEntry)) {
                return false;
            }
            ClasspathEntry entry = (ClasspathEntry)o;
            if (!this.classesFile.equals(entry.classesFile)) {
                return false;
            }
            if (!this.javadocFile.equals(entry.javadocFile)) {
                return false;
            }
            return this.sourcesFile.equals(entry.sourcesFile);
        }

        public int hashCode() {
            int result = this.classesFile.hashCode();
            result = 31 * result + this.sourcesFile.hashCode();
            result = 31 * result + this.javadocFile.hashCode();
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classesFile";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourcesFile";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "javadocFile";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/gradle/model/data/BuildScriptClasspathData$ClasspathEntry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/gradle/model/data/BuildScriptClasspathData$ClasspathEntry";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClassesFile";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSourcesFile";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getJavadocFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

