/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service;

import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemExecutionAware;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.SdkLookupProvider;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.target.GradleTargetUtil;
import org.jetbrains.plugins.gradle.service.execution.BuildLayoutParameters;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionAware;
import org.jetbrains.plugins.gradle.service.execution.LocalBuildLayoutParameters;
import org.jetbrains.plugins.gradle.service.execution.LocalGradleExecutionAware;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleEnvironment;
import org.jetbrains.plugins.gradle.util.GradleJvmResolutionUtil;
import org.jetbrains.plugins.gradle.util.GradleJvmUtil;
import org.jetbrains.plugins.gradle.util.GradleLog;

public class GradleInstallationManager
implements Disposable {
    public static final Pattern GRADLE_JAR_FILE_PATTERN;
    public static final Pattern ANY_GRADLE_JAR_FILE_PATTERN;
    public static final Pattern ANT_JAR_PATTERN;
    public static final Pattern IVY_JAR_PATTERN;
    private static final String[] GRADLE_START_FILE_NAMES;
    @NonNls
    private static final String GRADLE_ENV_PROPERTY_NAME;
    private static final Path BREW_GRADLE_LOCATION;
    private static final String LIBEXEC = "libexec";
    @Nullable
    private Ref<File> myCachedGradleHomeFromPath;
    private final Map<String, BuildLayoutParameters> myBuildLayoutParametersCache = new ConcurrentHashMap<String, BuildLayoutParameters>();

    public void dispose() {
    }

    public static GradleInstallationManager getInstance() {
        return (GradleInstallationManager)ApplicationManager.getApplication().getService(GradleInstallationManager.class);
    }

    public GradleInstallationManager() {
        final ExternalSystemTaskNotificationListenerAdapter listener2 = new ExternalSystemTaskNotificationListenerAdapter(){

            public void onStart(@NotNull ExternalSystemTaskId id, String workingDir) {
                if (id == null) {
                    1.$$$reportNull$$$0(0);
                }
                GradleInstallationManager.this.myBuildLayoutParametersCache.remove(workingDir);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/plugins/gradle/service/GradleInstallationManager$1", "onStart"));
            }
        };
        ExternalSystemProgressNotificationManager.getInstance().addNotificationListener((ExternalSystemTaskNotificationListener)listener2, (Disposable)this);
        final AtomicBoolean listenerAdded = new AtomicBoolean(true);
        MessageBusConnection appConnection = ApplicationManager.getApplication().getMessageBus().connect();
        appConnection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project) {
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (listenerAdded.compareAndSet(false, true)) {
                    ExternalSystemProgressNotificationManager.getInstance().addNotificationListener((ExternalSystemTaskNotificationListener)listener2, (Disposable)GradleInstallationManager.this);
                }
            }

            public void projectClosed(@NotNull Project project) {
                if (project == null) {
                    2.$$$reportNull$$$0(1);
                }
                GradleInstallationManager.this.myBuildLayoutParametersCache.clear();
                if (listenerAdded.compareAndSet(true, false)) {
                    ExternalSystemProgressNotificationManager.getInstance().removeNotificationListener((ExternalSystemTaskNotificationListener)listener2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "project";
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/GradleInstallationManager$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectOpened";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectClosed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        appConnection.subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    3.$$$reportNull$$$0(0);
                }
                GradleInstallationManager.this.myBuildLayoutParametersCache.clear();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "org/jetbrains/plugins/gradle/service/GradleInstallationManager$3", "beforePluginUnload"));
            }
        });
    }

    @ApiStatus.Experimental
    @NotNull
    public static BuildLayoutParameters defaultBuildLayoutParameters(@NotNull Project project) {
        if (project == null) {
            GradleInstallationManager.$$$reportNull$$$0(0);
        }
        BuildLayoutParameters buildLayoutParameters = GradleInstallationManager.getInstance().guessBuildLayoutParameters(project, null);
        if (buildLayoutParameters == null) {
            GradleInstallationManager.$$$reportNull$$$0(1);
        }
        return buildLayoutParameters;
    }

    @ApiStatus.Experimental
    @NotNull
    public BuildLayoutParameters guessBuildLayoutParameters(@NotNull Project project, @Nullable String projectPath) {
        if (project == null) {
            GradleInstallationManager.$$$reportNull$$$0(2);
        }
        BuildLayoutParameters buildLayoutParameters = this.myBuildLayoutParametersCache.computeIfAbsent((String)ObjectUtils.notNull((Object)projectPath, (Object)project.getLocationHash()), p -> {
            for (ExternalSystemExecutionAware executionAware : ExternalSystemExecutionAware.getExtensions((ProjectSystemId)GradleConstants.SYSTEM_ID)) {
                if (!(executionAware instanceof GradleExecutionAware)) continue;
                GradleExecutionAware gradleExecutionAware = (GradleExecutionAware)executionAware;
                BuildLayoutParameters buildLayoutParameters = projectPath == null ? gradleExecutionAware.getDefaultBuildLayoutParameters(project) : gradleExecutionAware.getBuildLayoutParameters(project, projectPath);
                if (buildLayoutParameters == null) continue;
                return buildLayoutParameters;
            }
            return new LocalGradleExecutionAware().getBuildLayoutParameters(project, projectPath);
        });
        if (buildLayoutParameters == null) {
            GradleInstallationManager.$$$reportNull$$$0(3);
        }
        return buildLayoutParameters;
    }

    @Nullable
    public Collection<File> getAllLibraries(@Nullable File gradleHome2) {
        File plugins;
        if (gradleHome2 == null || !gradleHome2.isDirectory()) {
            return null;
        }
        ArrayList<File> result = new ArrayList<File>();
        File libs = new File(gradleHome2, "lib");
        File[] files = libs.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.getName().endsWith(".jar")) continue;
                result.add(file);
            }
        }
        if ((files = (plugins = new File(libs, "plugins")).listFiles()) != null) {
            for (File file : files) {
                if (!file.getName().endsWith(".jar")) continue;
                result.add(file);
            }
        }
        return result.isEmpty() ? null : result;
    }

    @Nullable
    public File getGradleHome(@Nullable Project project, @NotNull String linkedProjectPath) {
        if (linkedProjectPath == null) {
            GradleInstallationManager.$$$reportNull$$$0(4);
        }
        if (project == null) {
            return null;
        }
        BuildLayoutParameters buildLayoutParameters = this.guessBuildLayoutParameters(project, linkedProjectPath);
        String gradleHome2 = GradleTargetUtil.maybeGetLocalValue(buildLayoutParameters.getGradleHome());
        return gradleHome2 != null ? new File(gradleHome2) : null;
    }

    @Nullable
    public String getGradleJvmPath(@NotNull Project project, @NotNull String linkedProjectPath) {
        GradleProjectSettings settings2;
        if (project == null) {
            GradleInstallationManager.$$$reportNull$$$0(5);
        }
        if (linkedProjectPath == null) {
            GradleInstallationManager.$$$reportNull$$$0(6);
        }
        if ((settings2 = (GradleProjectSettings)GradleSettings.getInstance(project).getLinkedProjectSettings(linkedProjectPath)) == null) {
            return GradleInstallationManager.getAvailableJavaHome(project);
        }
        String gradleJvm = settings2.getGradleJvm();
        SdkLookupProvider sdkLookupProvider = GradleJvmResolutionUtil.getGradleJvmLookupProvider(project, settings2);
        SdkLookupProvider.SdkInfo sdkInfo2 = GradleJvmUtil.nonblockingResolveGradleJvmInfo(sdkLookupProvider, project, linkedProjectPath, gradleJvm);
        if (sdkInfo2 instanceof SdkLookupProvider.SdkInfo.Resolved) {
            return ((SdkLookupProvider.SdkInfo.Resolved)sdkInfo2).getHomePath();
        }
        return null;
    }

    @Nullable
    private static String getAvailableJavaHome(@NotNull Project project) {
        if (project == null) {
            GradleInstallationManager.$$$reportNull$$$0(7);
        }
        Pair sdkPair = ExternalSystemJdkUtil.getAvailableJdk((Project)project);
        if (ExternalSystemJdkUtil.isValidJdk((Sdk)((Sdk)sdkPair.second))) {
            return ((Sdk)sdkPair.second).getHomePath();
        }
        return null;
    }

    @Nullable
    public File getAutodetectedGradleHome(@Nullable Project project) {
        File result = this.getGradleHomeFromPath(project);
        if (result != null) {
            return result;
        }
        result = this.getGradleHomeFromEnvProperty(project);
        if (result != null) {
            return result;
        }
        if (SystemInfo.isMac) {
            return GradleInstallationManager.getGradleHomeFromBrew();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static File getGradleHomeFromBrew() {
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(BREW_GRADLE_LOCATION);){
            Path bestPath = null;
            Version highestVersion = null;
            for (Path path : ds) {
                String fileName = path.getFileName().toString();
                try {
                    Version version = Version.parseVersion((String)fileName);
                    if (version == null || highestVersion != null && version.compareTo(highestVersion) <= 0) continue;
                    highestVersion = version;
                    bestPath = path;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (bestPath == null) return null;
            Path libexecPath = bestPath.resolve(LIBEXEC);
            if (!Files.exists(libexecPath, new LinkOption[0])) return null;
            File file = libexecPath.toFile();
            return file;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String suggestBetterGradleHomePath(@NotNull String homePath) {
        if (homePath == null) {
            GradleInstallationManager.$$$reportNull$$$0(8);
        }
        return this.suggestBetterGradleHomePath(null, homePath);
    }

    @NlsSafe
    public String suggestBetterGradleHomePath(@Nullable Project project, @NotNull String homePath) {
        Path libexecPath;
        File libexecFile;
        Path path;
        if (homePath == null) {
            GradleInstallationManager.$$$reportNull$$$0(9);
        }
        if ((path = Paths.get(homePath, new String[0])).startsWith(BREW_GRADLE_LOCATION) && this.isGradleSdkHome(project, libexecFile = (libexecPath = path.resolve(LIBEXEC)).toFile())) {
            return libexecPath.toString();
        }
        return null;
    }

    @Nullable
    public File getGradleHomeFromPath(@Nullable Project project) {
        Ref<File> ref = this.myCachedGradleHomeFromPath;
        if (ref != null) {
            return (File)ref.get();
        }
        String path = System.getenv("PATH");
        if (path == null) {
            return null;
        }
        for (String pathEntry : path.split(File.pathSeparator)) {
            File dir = new File(pathEntry);
            if (!dir.isDirectory()) continue;
            for (String fileName : GRADLE_START_FILE_NAMES) {
                File candidate;
                File startFile = new File(dir, fileName);
                if (!startFile.isFile() || !this.isGradleSdkHome(project, candidate = dir.getParentFile())) continue;
                this.myCachedGradleHomeFromPath = new Ref((Object)candidate);
                return candidate;
            }
        }
        return null;
    }

    @Nullable
    public File getGradleHomeFromEnvProperty(@Nullable Project project) {
        String path = System.getenv(GRADLE_ENV_PROPERTY_NAME);
        if (path == null) {
            return null;
        }
        File candidate = new File(path);
        return this.isGradleSdkHome(project, candidate) ? candidate : null;
    }

    public boolean isGradleSdkHome(@Nullable Project project, @Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        return this.isGradleSdkHome(project, new File(file.getPath()));
    }

    public boolean isGradleSdkHome(@Nullable File file) {
        return this.isGradleSdkHome(null, file);
    }

    public boolean isGradleSdkHome(@Nullable Project project, @Nullable File file) {
        if (file == null) {
            return false;
        }
        if (project == null) {
            ProjectManager projectManager = ProjectManager.getInstance();
            Project[] openProjects = projectManager.getOpenProjects();
            project = openProjects.length > 0 ? openProjects[0] : projectManager.getDefaultProject();
        }
        for (ExternalSystemExecutionAware executionAware : ExternalSystemExecutionAware.getExtensions((ProjectSystemId)GradleConstants.SYSTEM_ID)) {
            GradleExecutionAware gradleExecutionAware;
            if (!(executionAware instanceof GradleExecutionAware) || !(gradleExecutionAware = (GradleExecutionAware)executionAware).isGradleInstallationHomeDir(project, file.getPath())) continue;
            return true;
        }
        return false;
    }

    public boolean isGradleSdkHome(@Nullable Project project, String gradleHomePath) {
        return this.isGradleSdkHome(project, new File(gradleHomePath));
    }

    public boolean isGradleSdk(VirtualFile ... files) {
        if (files == null) {
            return false;
        }
        File[] arg = new File[files.length];
        for (int i = 0; i < files.length; ++i) {
            arg[i] = new File(files[i].getPath());
        }
        return GradleInstallationManager.isGradleSdk(arg);
    }

    private static boolean isGradleSdk(File ... files) {
        return GradleInstallationManager.findGradleJar(files) != null;
    }

    @Nullable
    private static File findGradleJar(File ... files) {
        if (files == null) {
            return null;
        }
        for (File file : files) {
            if (!GRADLE_JAR_FILE_PATTERN.matcher(file.getName()).matches()) continue;
            return file;
        }
        if (GradleEnvironment.DEBUG_GRADLE_HOME_PROCESSING) {
            StringBuilder filesInfo = new StringBuilder();
            for (File file : files) {
                filesInfo.append(file.getAbsolutePath()).append(';');
            }
            if (filesInfo.length() > 0) {
                filesInfo.setLength(filesInfo.length() - 1);
            }
            GradleLog.LOG.info(String.format("Gradle sdk check fails. Reason: no one of the given files matches gradle JAR pattern (%s). Files: %s", GRADLE_JAR_FILE_PATTERN.toString(), filesInfo));
        }
        return null;
    }

    @Nullable
    public List<VirtualFile> getClassRoots(@Nullable Project project) {
        List<File> files = this.getClassRoots(project, null);
        if (files == null) {
            return null;
        }
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        JarFileSystem jarFileSystem = JarFileSystem.getInstance();
        return ContainerUtil.mapNotNull(files, file -> {
            VirtualFile virtualFile = localFileSystem.refreshAndFindFileByIoFile(file);
            return virtualFile != null ? jarFileSystem.getJarRootForLocalFile(virtualFile) : null;
        });
    }

    @Nullable
    public List<File> getClassRoots(@Nullable Project project, @Nullable String rootProjectPath) {
        if (project == null) {
            return null;
        }
        if (rootProjectPath == null) {
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                rootProjectPath = ExternalSystemModulePropertyManager.getInstance((Module)module).getRootProjectPath();
                List<File> result = this.findGradleSdkClasspath(project, rootProjectPath);
                if (result.isEmpty()) continue;
                return result;
            }
        } else {
            return this.findGradleSdkClasspath(project, rootProjectPath);
        }
        return null;
    }

    @Nullable
    public static String getGradleVersion(@Nullable String gradleHome2) {
        if (gradleHome2 == null) {
            return null;
        }
        File libs = new File(gradleHome2, "lib");
        if (!libs.isDirectory()) {
            return null;
        }
        File[] files = libs.listFiles();
        if (files != null) {
            for (File file : files) {
                Matcher matcher = GRADLE_JAR_FILE_PATTERN.matcher(file.getName());
                if (!matcher.matches()) continue;
                return matcher.group(2);
            }
        }
        return null;
    }

    private List<File> findGradleSdkClasspath(Project project, String rootProjectPath) {
        Collection<File> libraries;
        ArrayList<File> result = new ArrayList<File>();
        if (StringUtil.isEmpty((String)rootProjectPath)) {
            return result;
        }
        File gradleHome2 = this.getGradleHome(project, rootProjectPath);
        if (gradleHome2 == null || !gradleHome2.isDirectory()) {
            return result;
        }
        File src = new File(gradleHome2, "src");
        if (src.isDirectory()) {
            if (new File(src, "org").isDirectory()) {
                GradleInstallationManager.addRoots(result, src);
            } else {
                GradleInstallationManager.addRoots(result, src.listFiles());
            }
        }
        if ((libraries = this.getAllLibraries(gradleHome2)) == null) {
            return result;
        }
        for (File file : libraries) {
            if (!GradleInstallationManager.isGradleBuildClasspathLibrary(file)) continue;
            ContainerUtil.addIfNotNull(result, (Object)file);
        }
        return result;
    }

    private static boolean isGradleBuildClasspathLibrary(File file) {
        String fileName = file.getName();
        return ANY_GRADLE_JAR_FILE_PATTERN.matcher(fileName).matches() || ANT_JAR_PATTERN.matcher(fileName).matches() || IVY_JAR_PATTERN.matcher(fileName).matches() || GradleInstallationManager.isGroovyJar(fileName);
    }

    private static void addRoots(@NotNull List<? super File> result, File ... files) {
        if (result == null) {
            GradleInstallationManager.$$$reportNull$$$0(10);
        }
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file == null || !file.isDirectory()) continue;
            result.add(file);
        }
    }

    private static boolean isGroovyJar(@NotNull String name2) {
        if (name2 == null) {
            GradleInstallationManager.$$$reportNull$$$0(11);
        }
        return (name2 = StringUtil.toLowerCase((String)name2)).startsWith("groovy-all-") && name2.endsWith(".jar") && !name2.contains("src") && !name2.contains("doc");
    }

    @Nullable
    public static GradleVersion guessGradleVersion(final @NotNull GradleProjectSettings settings2) {
        BuildLayoutParameters buildLayoutParameters;
        DistributionType distributionType;
        if (settings2 == null) {
            GradleInstallationManager.$$$reportNull$$$0(12);
        }
        if ((distributionType = settings2.getDistributionType()) == null) {
            return null;
        }
        Project project = GradleInstallationManager.findProject(settings2);
        if (project == null) {
            Project defaultProject = ProjectManager.getInstance().getDefaultProject();
            buildLayoutParameters = new LocalBuildLayoutParameters(defaultProject, settings2.getExternalProjectPath()){

                @Override
                public GradleProjectSettings getGradleProjectSettings() {
                    return settings2;
                }
            };
        } else {
            buildLayoutParameters = GradleInstallationManager.getInstance().guessBuildLayoutParameters(project, settings2.getExternalProjectPath());
        }
        return buildLayoutParameters.getGradleVersion();
    }

    @Nullable
    public static GradleVersion parseDistributionVersion(@NotNull String path) {
        if (path == null) {
            GradleInstallationManager.$$$reportNull$$$0(13);
        }
        if ((path = StringUtil.substringAfterLast((String)path, (String)"/")) == null) {
            return null;
        }
        if ((path = StringUtil.substringAfterLast((String)path, (String)"gradle-")) == null) {
            return null;
        }
        int i = path.lastIndexOf(45);
        if (i <= 0) {
            return null;
        }
        return GradleInstallationManager.getGradleVersionSafe(path.substring(0, i));
    }

    @Nullable
    public static GradleVersion getGradleVersionSafe(String gradleVersion2) {
        try {
            return GradleVersion.version((String)gradleVersion2);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Nullable
    private static Project findProject(@NotNull GradleProjectSettings settings2) {
        if (settings2 == null) {
            GradleInstallationManager.$$$reportNull$$$0(14);
        }
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            GradleProjectSettings linkedProjectSettings = (GradleProjectSettings)GradleSettings.getInstance(project).getLinkedProjectSettings(settings2.getExternalProjectPath());
            if (linkedProjectSettings != settings2) continue;
            return project;
        }
        return null;
    }

    static {
        ANT_JAR_PATTERN = Pattern.compile("ant(-(.*))?\\.jar");
        IVY_JAR_PATTERN = Pattern.compile("ivy(-(.*))?\\.jar");
        BREW_GRADLE_LOCATION = Paths.get("/usr/local/Cellar/gradle/", new String[0]);
        GRADLE_JAR_FILE_PATTERN = Pattern.compile(System.getProperty("gradle.pattern.core.jar", "gradle-(core-)?(\\d.*)\\.jar"));
        ANY_GRADLE_JAR_FILE_PATTERN = Pattern.compile(System.getProperty("gradle.pattern.core.jar", "gradle-(.*)\\.jar"));
        GRADLE_START_FILE_NAMES = System.getProperty("gradle.start.file.names", "gradle:gradle.cmd:gradle.sh").split(":");
        GRADLE_ENV_PROPERTY_NAME = System.getProperty("gradle.home.env.key", "GRADLE_HOME");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/GradleInstallationManager";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkedProjectPath";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/GradleInstallationManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultBuildLayoutParameters";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "guessBuildLayoutParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "defaultBuildLayoutParameters";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "guessBuildLayoutParameters";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getGradleHome";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getGradleJvmPath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableJavaHome";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "suggestBetterGradleHomePath";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addRoots";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isGroovyJar";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "guessGradleVersion";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseDistributionVersion";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findProject";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

