/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang.java6;

import com.intellij.openapi.util.io.DataInputOutputUtilRt;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;

public class BloomFilterBase {
    private final int myHashFunctionCount;
    private final int myBitsCount;
    private final long[] myElementsSet;
    private static final int BITS_PER_ELEMENT = 6;

    protected BloomFilterBase(int _maxElementCount, double probability) {
        int bitsPerElementFactor = (int)Math.ceil(-Math.log(probability) / (Math.log(2.0) * Math.log(2.0)));
        this.myHashFunctionCount = (int)Math.ceil((double)bitsPerElementFactor * Math.log(2.0));
        int bitsCount = _maxElementCount * bitsPerElementFactor;
        if ((bitsCount & 1) == 0) {
            ++bitsCount;
        }
        while (!BloomFilterBase.isPrime(bitsCount)) {
            bitsCount += 2;
        }
        this.myBitsCount = bitsCount;
        this.myElementsSet = new long[(bitsCount >> 6) + 1];
    }

    private static boolean isPrime(int bits) {
        if ((bits & 1) == 0 || bits % 3 == 0) {
            return false;
        }
        int sqrt = (int)Math.sqrt(bits);
        for (int i = 6; i <= sqrt; i += 6) {
            if (bits % (i - 1) != 0 && bits % (i + 1) != 0) continue;
            return false;
        }
        return true;
    }

    protected final void addIt(int prime, int prime2) {
        for (int i = 0; i < this.myHashFunctionCount; ++i) {
            int abs = Math.abs((i * prime + prime2 * (this.myHashFunctionCount - i)) % this.myBitsCount);
            int n = abs >> 6;
            this.myElementsSet[n] = this.myElementsSet[n] | 1L << abs;
        }
    }

    protected final boolean maybeContains(int prime, int prime2) {
        for (int i = 0; i < this.myHashFunctionCount; ++i) {
            int abs = Math.abs((i * prime + prime2 * (this.myHashFunctionCount - i)) % this.myBitsCount);
            if ((this.myElementsSet[abs >> 6] & 1L << abs) != 0L) continue;
            return false;
        }
        return true;
    }

    protected BloomFilterBase(@NotNull DataInput input) throws IOException {
        if (input == null) {
            BloomFilterBase.$$$reportNull$$$0(0);
        }
        this.myHashFunctionCount = DataInputOutputUtilRt.readINT((DataInput)input);
        this.myBitsCount = DataInputOutputUtilRt.readINT((DataInput)input);
        this.myElementsSet = new long[(this.myBitsCount >> 6) + 1];
        for (int i = 0; i < this.myElementsSet.length; ++i) {
            this.myElementsSet[i] = input.readLong();
        }
    }

    protected BloomFilterBase(@NotNull ByteBuffer buffer) throws IOException {
        if (buffer == null) {
            BloomFilterBase.$$$reportNull$$$0(1);
        }
        this.myHashFunctionCount = buffer.getInt();
        this.myBitsCount = buffer.getInt();
        this.myElementsSet = new long[(this.myBitsCount >> 6) + 1];
        buffer.asLongBuffer().get(this.myElementsSet);
    }

    public int sizeInBytes() {
        return 8 + this.myElementsSet.length * 8;
    }

    public void save(@NotNull ByteBuffer buffer) {
        if (buffer == null) {
            BloomFilterBase.$$$reportNull$$$0(2);
        }
        buffer.putInt(this.myHashFunctionCount);
        buffer.putInt(this.myBitsCount);
        buffer.asLongBuffer().put(this.myElementsSet);
        buffer.position(buffer.position() + this.myElementsSet.length * 8);
    }

    protected void save(@NotNull DataOutput output) throws IOException {
        if (output == null) {
            BloomFilterBase.$$$reportNull$$$0(3);
        }
        DataInputOutputUtilRt.writeINT((DataOutput)output, (int)this.myHashFunctionCount);
        DataInputOutputUtilRt.writeINT((DataOutput)output, (int)this.myBitsCount);
        for (long l : this.myElementsSet) {
            output.writeLong(l);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/lang/java6/BloomFilterBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "save";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

