/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutlib;

import com.android.ide.common.rendering.api.Bridge;
import com.android.ide.common.rendering.api.DrawableParams;
import com.android.ide.common.rendering.api.ILayoutLog;
import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.SessionParams;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.PluginId;
import java.io.File;
import java.util.Map;

public class LayoutLibrary
implements Disposable {
    public static final String LAYOUTLIB_NATIVE_PLUGIN = "com.android.layoutlib";
    public static final String LAYOUTLIB_STANDARD_PLUGIN = "com.android.layoutlib.legacy";
    private final Bridge mBridge;
    private final ClassLoader mClassLoader;
    private boolean mIsDisposed;

    public ClassLoader getClassLoader() {
        return this.mClassLoader;
    }

    static LayoutLibrary load(Bridge bridge, ClassLoader classLoader) {
        return new LayoutLibrary(bridge, classLoader);
    }

    private LayoutLibrary(Bridge bridge, ClassLoader classLoader) {
        this.mBridge = bridge;
        this.mClassLoader = classLoader;
    }

    public static boolean isNative() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        IdeaPluginDescriptor nativePlugin = PluginManagerCore.getPlugin((PluginId)PluginId.findId((String)LAYOUTLIB_NATIVE_PLUGIN));
        return nativePlugin != null && nativePlugin.isEnabled();
    }

    public boolean init(Map<String, String> platformProperties, File fontLocation, String nativeLibDirPath, String icuDataPath, Map<String, Map<String, Integer>> enumValueMap, ILayoutLog log) {
        if (this.mBridge != null) {
            return this.mBridge.init(platformProperties, fontLocation, nativeLibDirPath, icuDataPath, enumValueMap, log);
        }
        return false;
    }

    public void dispose() {
        if (this.mBridge != null) {
            this.mIsDisposed = this.mBridge.dispose();
        }
    }

    public boolean isDisposed() {
        return this.mIsDisposed;
    }

    public RenderSession createSession(SessionParams params) {
        if (this.mBridge != null) {
            return this.mBridge.createSession(params);
        }
        return null;
    }

    public Result renderDrawable(DrawableParams params) {
        if (this.mBridge != null) {
            return this.mBridge.renderDrawable(params);
        }
        return Result.Status.NOT_IMPLEMENTED.createResult();
    }

    public void clearResourceCaches(Object projectKey) {
        if (this.mBridge != null) {
            this.mBridge.clearResourceCaches(projectKey);
        }
    }

    public void clearFontCache(String path) {
        if (this.mBridge != null) {
            this.mBridge.clearFontCache(path);
        }
    }

    public void clearAllCaches(Object projectKey) {
        if (this.mBridge != null) {
            this.mBridge.clearAllCaches(projectKey);
        }
    }

    public Result getViewParent(Object viewObject) {
        if (this.mBridge != null) {
            return this.mBridge.getViewParent(viewObject);
        }
        return Result.Status.ERROR_UNKNOWN.createResult();
    }

    public boolean isRtl(String locale) {
        return this.mBridge != null && this.mBridge.isRtl(locale);
    }

    @VisibleForTesting
    protected LayoutLibrary() {
        this.mBridge = null;
        this.mClassLoader = null;
    }
}

