/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponent;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponentKt;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.PrivateForInline;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeUnexpectedTypeArgumentsError;
import org.jetbrains.kotlin.fir.resolve.FirTypeResolver;
import org.jetbrains.kotlin.fir.resolve.FirTypeResolverKt;
import org.jetbrains.kotlin.fir.resolve.SupertypeSupplier;
import org.jetbrains.kotlin.fir.resolve.transformers.FirAbstractTreeTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.ScopeClassDeclaration;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirFunctionTypeRef;
import org.jetbrains.kotlin.fir.types.FirImplicitTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.builder.FirErrorTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.builder.FirResolvedTypeRefBuilder;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0002H\u0016J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u0002H\u0016J\u0018\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u0002H\u0016J\"\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*H\u0002J\u0018\u0010+\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020\u0002H\u0016J/\u0010,\u001a\u0002H-\"\u0004\b\u0000\u0010-2\b\b\u0002\u0010.\u001a\u00020\u00062\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H-00H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u00101J:\u00102\u001a\u0002H-\"\u0004\b\u0000\u0010-2\b\u00103\u001a\u0004\u0018\u00010\u00112\u0017\u0010/\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002H-04\u00a2\u0006\u0002\b5H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u00106J%\u00107\u001a\u0002H-\"\u0004\b\u0000\u0010-2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H-00H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u00108J\u000e\u00109\u001a\u0004\u0018\u00010(*\u00020(H\u0002R$\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0014\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000fR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006:"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirSpecificTypeResolverTransformer;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirAbstractTreeTransformer;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/ScopeClassDeclaration;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "errorTypeAsResolved", "", "supertypeSupplier", "Lorg/jetbrains/kotlin/fir/resolve/SupertypeSupplier;", "(Lorg/jetbrains/kotlin/fir/FirSession;ZLorg/jetbrains/kotlin/fir/resolve/SupertypeSupplier;)V", "<set-?>", "areBareTypesAllowed", "getAreBareTypesAllowed", "()Z", "setAreBareTypesAllowed", "(Z)V", "currentFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "getCurrentFile$annotations", "()V", "isOperandOfIsOperator", "setOperandOfIsOperator", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "typeResolver", "Lorg/jetbrains/kotlin/fir/resolve/FirTypeResolver;", "transformFunctionTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "functionTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirFunctionTypeRef;", "data", "transformImplicitTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "implicitTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirImplicitTypeRef;", "transformResolvedTypeRef", "resolvedTypeRef", "transformType", "typeRef", "resolvedType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "diagnostic", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "transformTypeRef", "withBareTypes", "R", "allowed", "block", "Lkotlin/Function0;", "(ZLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "withFile", "file", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "withIsOperandOfIsOperator", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "takeIfAcceptable", "resolve"})
public final class FirSpecificTypeResolverTransformer
extends FirAbstractTreeTransformer<ScopeClassDeclaration> {
    @NotNull
    private final FirSession session;
    private final boolean errorTypeAsResolved;
    @NotNull
    private final SupertypeSupplier supertypeSupplier;
    @NotNull
    private final FirTypeResolver typeResolver;
    private boolean areBareTypesAllowed;
    private boolean isOperandOfIsOperator;
    @JvmField
    @Nullable
    public FirFile currentFile;

    public FirSpecificTypeResolverTransformer(@NotNull FirSession session2, boolean errorTypeAsResolved, @NotNull SupertypeSupplier supertypeSupplier) {
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(supertypeSupplier, "supertypeSupplier");
        super(FirResolvePhase.SUPER_TYPES);
        this.session = session2;
        this.errorTypeAsResolved = errorTypeAsResolved;
        this.supertypeSupplier = supertypeSupplier;
        this.typeResolver = FirTypeResolverKt.getTypeResolver(this.getSession());
    }

    public /* synthetic */ FirSpecificTypeResolverTransformer(FirSession firSession, boolean bl, SupertypeSupplier supertypeSupplier, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            supertypeSupplier = SupertypeSupplier.Default.INSTANCE;
        }
        this(firSession, bl, supertypeSupplier);
    }

    @Override
    @NotNull
    public FirSession getSession() {
        return this.session;
    }

    public final boolean getAreBareTypesAllowed() {
        return this.areBareTypesAllowed;
    }

    @PrivateForInline
    public final void setAreBareTypesAllowed(boolean bl) {
        this.areBareTypesAllowed = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R> R withBareTypes(boolean allowed, @NotNull Function0<? extends R> block) {
        R r;
        Intrinsics.checkNotNullParameter(block, "block");
        boolean $i$f$withBareTypes = false;
        boolean oldValue = this.getAreBareTypesAllowed();
        this.setAreBareTypesAllowed(allowed);
        try {
            r = block.invoke();
        }
        finally {
            InlineMarker.finallyStart(1);
            this.setAreBareTypesAllowed(oldValue);
            InlineMarker.finallyEnd(1);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static /* synthetic */ Object withBareTypes$default(FirSpecificTypeResolverTransformer this_, boolean allowed, Function0 block, int n, Object object) {
        Object r;
        if ((n & 1) != 0) {
            allowed = true;
        }
        Intrinsics.checkNotNullParameter(block, "block");
        boolean $i$f$withBareTypes = false;
        boolean oldValue = this_.getAreBareTypesAllowed();
        this_.setAreBareTypesAllowed(allowed);
        try {
            r = block.invoke();
        }
        finally {
            InlineMarker.finallyStart(1);
            this_.setAreBareTypesAllowed(oldValue);
            InlineMarker.finallyEnd(1);
        }
        return r;
    }

    public final boolean isOperandOfIsOperator() {
        return this.isOperandOfIsOperator;
    }

    @PrivateForInline
    public final void setOperandOfIsOperator(boolean bl) {
        this.isOperandOfIsOperator = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R> R withIsOperandOfIsOperator(@NotNull Function0<? extends R> block) {
        R r;
        Intrinsics.checkNotNullParameter(block, "block");
        boolean $i$f$withIsOperandOfIsOperator = false;
        boolean oldValue = this.isOperandOfIsOperator();
        this.setOperandOfIsOperator(true);
        try {
            r = block.invoke();
        }
        finally {
            InlineMarker.finallyStart(1);
            this.setOperandOfIsOperator(oldValue);
            InlineMarker.finallyEnd(1);
        }
        return r;
    }

    @PrivateForInline
    public static /* synthetic */ void getCurrentFile$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R> R withFile(@Nullable FirFile file2, @NotNull Function1<? super FirSpecificTypeResolverTransformer, ? extends R> block) {
        R r;
        Intrinsics.checkNotNullParameter(block, "block");
        boolean $i$f$withFile = false;
        FirFile oldValue = this.currentFile;
        this.currentFile = file2;
        try {
            r = block.invoke(this);
        }
        finally {
            InlineMarker.finallyStart(1);
            this.currentFile = oldValue;
            InlineMarker.finallyEnd(1);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public FirResolvedTypeRef transformTypeRef(@NotNull FirTypeRef typeRef, @NotNull ScopeClassDeclaration data) {
        void this_$iv;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(typeRef, "typeRef");
        Intrinsics.checkNotNullParameter(data, "data");
        Object $this$flatMap$iv = data.getScopes();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            FirScope it = (FirScope)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getScopeOwnerLookupNames();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List scopeOwnerLookupNames2 = (List)destination$iv$iv;
        FirLookupTrackerComponent firLookupTrackerComponent = FirLookupTrackerComponentKt.getLookupTracker(this.getSession());
        if (firLookupTrackerComponent != null) {
            FirFile firFile = this.currentFile;
            FirLookupTrackerComponentKt.recordTypeLookup(firLookupTrackerComponent, typeRef, scopeOwnerLookupNames2, firFile != null ? firFile.getSource() : null);
        }
        $this$flatMap$iv = this;
        boolean allowed$iv = false;
        boolean $i$f$withBareTypes = false;
        boolean oldValue$iv = this_$iv.getAreBareTypesAllowed();
        this_$iv.setAreBareTypesAllowed(allowed$iv);
        try {
            boolean bl = false;
            FirElement firElement = typeRef.transformChildren(this, data);
        }
        finally {
            this_$iv.setAreBareTypesAllowed(oldValue$iv);
        }
        Pair<ConeKotlinType, ConeDiagnostic> pair = this.typeResolver.resolveType(typeRef, data, this.areBareTypesAllowed, this.isOperandOfIsOperator, this.currentFile, this.supertypeSupplier);
        ConeKotlinType resolvedType = pair.component1();
        ConeDiagnostic diagnostic = pair.component2();
        return this.transformType(typeRef, resolvedType, diagnostic);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public FirResolvedTypeRef transformFunctionTypeRef(@NotNull FirFunctionTypeRef functionTypeRef, @NotNull ScopeClassDeclaration data) {
        FirResolvedTypeRef firResolvedTypeRef;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(functionTypeRef, "functionTypeRef");
        Intrinsics.checkNotNullParameter(data, "data");
        functionTypeRef.transformChildren(this, data);
        Iterable $this$flatMap$iv = data.getScopes();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            FirScope it = (FirScope)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getScopeOwnerLookupNames();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List scopeOwnerLookupNames2 = (List)destination$iv$iv;
        FirLookupTrackerComponent firLookupTrackerComponent = FirLookupTrackerComponentKt.getLookupTracker(this.getSession());
        if (firLookupTrackerComponent != null) {
            FirFile firFile = this.currentFile;
            FirLookupTrackerComponentKt.recordTypeLookup(firLookupTrackerComponent, functionTypeRef, scopeOwnerLookupNames2, firFile != null ? firFile.getSource() : null);
        }
        Pair<ConeKotlinType, ConeDiagnostic> resolvedTypeWithDiagnostic = this.typeResolver.resolveType(functionTypeRef, data, this.areBareTypesAllowed, this.isOperandOfIsOperator, this.currentFile, this.supertypeSupplier);
        ConeKotlinType resolvedType = this.takeIfAcceptable(resolvedTypeWithDiagnostic.getFirst());
        ConeDiagnostic diagnostic = resolvedTypeWithDiagnostic.getSecond();
        if (resolvedType != null && !(resolvedType instanceof ConeClassErrorType) && diagnostic == null) {
            FirResolvedTypeRefBuilder firResolvedTypeRefBuilder;
            boolean $i$f$buildResolvedTypeRef = false;
            FirResolvedTypeRefBuilder $this$transformFunctionTypeRef_u24lambda_u2d3 = firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
            boolean bl = false;
            $this$transformFunctionTypeRef_u24lambda_u2d3.setSource(functionTypeRef.getSource());
            $this$transformFunctionTypeRef_u24lambda_u2d3.setType(resolvedType);
            CollectionsKt.addAll((Collection)$this$transformFunctionTypeRef_u24lambda_u2d3.getAnnotations(), (Iterable)functionTypeRef.getAnnotations());
            $this$transformFunctionTypeRef_u24lambda_u2d3.setDelegatedTypeRef(functionTypeRef);
            firResolvedTypeRef = firResolvedTypeRefBuilder.build();
        } else {
            ConeDiagnostic coneDiagnostic;
            FirErrorTypeRefBuilder firErrorTypeRefBuilder;
            boolean $i$f$buildErrorTypeRef = false;
            FirErrorTypeRefBuilder $this$transformFunctionTypeRef_u24lambda_u2d4 = firErrorTypeRefBuilder = new FirErrorTypeRefBuilder();
            boolean bl = false;
            $this$transformFunctionTypeRef_u24lambda_u2d4.setSource(functionTypeRef.getSource());
            if (resolvedType != null) {
                $this$transformFunctionTypeRef_u24lambda_u2d4.setType(resolvedType);
            }
            if ((coneDiagnostic = diagnostic) == null) {
                ConeClassErrorType coneClassErrorType = resolvedType instanceof ConeClassErrorType ? (ConeClassErrorType)resolvedType : null;
                coneDiagnostic = coneClassErrorType != null ? coneClassErrorType.getDiagnostic() : null;
                if (coneDiagnostic == null) {
                    coneDiagnostic = new ConeSimpleDiagnostic("Unresolved functional type: " + FirRendererKt.render$default(functionTypeRef, null, 1, null), null, 2, null);
                }
            }
            $this$transformFunctionTypeRef_u24lambda_u2d4.setDiagnostic(coneDiagnostic);
            firResolvedTypeRef = firErrorTypeRefBuilder.build();
        }
        return firResolvedTypeRef;
    }

    private final FirResolvedTypeRef transformType(FirTypeRef typeRef, ConeKotlinType resolvedType, ConeDiagnostic diagnostic) {
        FirResolvedTypeRef firResolvedTypeRef;
        if (resolvedType instanceof ConeClassErrorType) {
            KtSourceElement diagnosticSource;
            ConeUnexpectedTypeArgumentsError coneUnexpectedTypeArgumentsError;
            FirErrorTypeRefBuilder firErrorTypeRefBuilder;
            boolean $i$f$buildErrorTypeRef = false;
            FirErrorTypeRefBuilder $this$transformType_u24lambda_u2d5 = firErrorTypeRefBuilder = new FirErrorTypeRefBuilder();
            boolean bl = false;
            KtSourceElement ktSourceElement = typeRef.getSource();
            KtSourceElementKind typeRefSourceKind = ktSourceElement != null ? ktSourceElement.getKind() : null;
            ConeDiagnostic $this$safeAs$iv = ((ConeClassErrorType)resolvedType).getDiagnostic();
            boolean $i$f$safeAs = false;
            ConeDiagnostic coneDiagnostic = $this$safeAs$iv;
            if (!(coneDiagnostic instanceof ConeUnexpectedTypeArgumentsError)) {
                coneDiagnostic = null;
            }
            KtSourceElement $this$safeAs$iv2 = (coneUnexpectedTypeArgumentsError = (ConeUnexpectedTypeArgumentsError)coneDiagnostic) != null ? coneUnexpectedTypeArgumentsError.getSource() : null;
            boolean $i$f$safeAs2 = false;
            KtSourceElement ktSourceElement2 = $this$safeAs$iv2;
            if (!(ktSourceElement2 instanceof KtSourceElement)) {
                ktSourceElement2 = null;
            }
            $this$transformType_u24lambda_u2d5.setSource((diagnosticSource = ktSourceElement2) != null ? (typeRefSourceKind instanceof KtFakeSourceElementKind ? KtSourceElementKt.fakeElement(diagnosticSource, (KtFakeSourceElementKind)typeRefSourceKind) : diagnosticSource) : typeRef.getSource());
            $this$transformType_u24lambda_u2d5.setDelegatedTypeRef(typeRef);
            $this$transformType_u24lambda_u2d5.setType(resolvedType);
            $this$transformType_u24lambda_u2d5.setDiagnostic(((ConeClassErrorType)resolvedType).getDiagnostic());
            firResolvedTypeRef = firErrorTypeRefBuilder.build();
        } else if (diagnostic != null) {
            FirErrorTypeRefBuilder firErrorTypeRefBuilder;
            boolean $i$f$buildErrorTypeRef = false;
            FirErrorTypeRefBuilder $this$transformType_u24lambda_u2d6 = firErrorTypeRefBuilder = new FirErrorTypeRefBuilder();
            boolean bl = false;
            $this$transformType_u24lambda_u2d6.setSource(typeRef.getSource());
            $this$transformType_u24lambda_u2d6.setDiagnostic(diagnostic);
            $this$transformType_u24lambda_u2d6.setType(resolvedType);
            $this$transformType_u24lambda_u2d6.setDelegatedTypeRef(typeRef);
            firResolvedTypeRef = firErrorTypeRefBuilder.build();
        } else {
            FirResolvedTypeRefBuilder firResolvedTypeRefBuilder;
            boolean $i$f$buildResolvedTypeRef = false;
            FirResolvedTypeRefBuilder $this$transformType_u24lambda_u2d7 = firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
            boolean bl = false;
            $this$transformType_u24lambda_u2d7.setSource(typeRef.getSource());
            $this$transformType_u24lambda_u2d7.setType(resolvedType);
            CollectionsKt.addAll((Collection)$this$transformType_u24lambda_u2d7.getAnnotations(), (Iterable)typeRef.getAnnotations());
            $this$transformType_u24lambda_u2d7.setDelegatedTypeRef(typeRef);
            firResolvedTypeRef = firResolvedTypeRefBuilder.build();
        }
        return firResolvedTypeRef;
    }

    private final ConeKotlinType takeIfAcceptable(ConeKotlinType $this$takeIfAcceptable) {
        ConeKotlinType coneKotlinType;
        ConeKotlinType it = coneKotlinType = $this$takeIfAcceptable;
        boolean bl = false;
        return !(!this.errorTypeAsResolved && it instanceof ConeClassErrorType) ? coneKotlinType : null;
    }

    @Override
    @NotNull
    public FirTypeRef transformResolvedTypeRef(@NotNull FirResolvedTypeRef resolvedTypeRef, @NotNull ScopeClassDeclaration data) {
        Intrinsics.checkNotNullParameter(resolvedTypeRef, "resolvedTypeRef");
        Intrinsics.checkNotNullParameter(data, "data");
        return resolvedTypeRef;
    }

    @Override
    @NotNull
    public FirTypeRef transformImplicitTypeRef(@NotNull FirImplicitTypeRef implicitTypeRef, @NotNull ScopeClassDeclaration data) {
        Intrinsics.checkNotNullParameter(implicitTypeRef, "implicitTypeRef");
        Intrinsics.checkNotNullParameter(data, "data");
        return implicitTypeRef;
    }
}

