/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.activities.loginActivity.src.app_package.data;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u00a8\u0006\u0003"}, d2={"loginRepositoryJava", "", "packageName", "intellij.android.wizardTemplate.impl"})
public final class LoginRepositoryJavaKt {
    @NotNull
    public static final String loginRepositoryJava(@NotNull String packageName) {
        Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
        return "package " + packageName + ".data;\n\nimport " + packageName + ".data.model.LoggedInUser;\n\n/**\n * Class that requests authentication and user information from the remote data source and\n * maintains an in-memory cache of login status and user credentials information.\n */\npublic class LoginRepository {\n\n    private static volatile LoginRepository instance;\n\n    private LoginDataSource dataSource;\n\n    // If user credentials will be cached in local storage, it is recommended it be encrypted\n    // @see https://developer.android.com/training/articles/keystore\n    private LoggedInUser user = null;\n\n    // private constructor : singleton access\n    private LoginRepository(LoginDataSource dataSource) {\n        this.dataSource = dataSource;\n    }\n\n    public static LoginRepository getInstance(LoginDataSource dataSource) {\n        if(instance == null){\n            instance = new LoginRepository(dataSource);\n        }\n        return instance;\n    }\n\n    public boolean isLoggedIn() {\n        return user != null;\n    }\n\n    public void logout() {\n        user = null;\n        dataSource.logout();\n    }\n\n    private void setLoggedInUser(LoggedInUser user) {\n        this.user = user;\n        // If user credentials will be cached in local storage, it is recommended it be encrypted\n        // @see https://developer.android.com/training/articles/keystore\n    }\n\n    public Result<LoggedInUser> login(String username, String password) {\n        // handle login\n        Result<LoggedInUser> result = dataSource.login(username, password);\n        if (result instanceof Result.Success) {\n            setLoggedInUser(((Result.Success<LoggedInUser>) result).getData());\n        }\n        return result;\n    }\n}\n";
    }
}

