/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.activities.loginActivity.src.app_package.ui.login;

import com.android.tools.idea.wizard.template.TemplateHelpersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"loginViewModelJava", "", "packageName", "useAndroidX", "", "intellij.android.wizardTemplate.impl"})
public final class LoginViewModelJavaKt {
    @NotNull
    public static final String loginViewModelJava(@NotNull String packageName, boolean useAndroidX) {
        Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
        return "package " + packageName + ".ui.login;\n\nimport " + TemplateHelpersKt.getMaterialComponentName("android.arch.lifecycle.LiveData", useAndroidX) + ";\nimport " + TemplateHelpersKt.getMaterialComponentName("android.arch.lifecycle.MutableLiveData", useAndroidX) + ";\nimport " + TemplateHelpersKt.getMaterialComponentName("android.arch.lifecycle.ViewModel", useAndroidX) + ";\nimport android.util.Patterns;\n\nimport " + packageName + ".data.LoginRepository;\nimport " + packageName + ".data.Result;\nimport " + packageName + ".data.model.LoggedInUser;\nimport " + packageName + ".R;\n\npublic class LoginViewModel extends ViewModel {\n\n    private MutableLiveData<LoginFormState> loginFormState = new MutableLiveData<>();\n    private MutableLiveData<LoginResult> loginResult = new MutableLiveData<>();\n    private LoginRepository loginRepository;\n\n    LoginViewModel(LoginRepository loginRepository) {\n        this.loginRepository = loginRepository;\n    }\n\n    LiveData<LoginFormState> getLoginFormState() {\n        return loginFormState;\n    }\n\n    LiveData<LoginResult> getLoginResult() {\n        return loginResult;\n    }\n\n    public void login(String username, String password) {\n        // can be launched in a separate asynchronous job\n        Result<LoggedInUser> result = loginRepository.login(username, password);\n\n        if (result instanceof Result.Success) {\n            LoggedInUser data = ((Result.Success<LoggedInUser>) result).getData();\n            loginResult.setValue(new LoginResult(new LoggedInUserView(data.getDisplayName())));\n        } else {\n            loginResult.setValue(new LoginResult(R.string.login_failed));\n        }\n    }\n\n    public void loginDataChanged(String username, String password) {\n        if (!isUserNameValid(username)) {\n            loginFormState.setValue(new LoginFormState(R.string.invalid_username, null));\n        } else if (!isPasswordValid(password)) {\n            loginFormState.setValue(new LoginFormState(null, R.string.invalid_password));\n        } else {\n            loginFormState.setValue(new LoginFormState(true));\n        }\n    }\n\n    // A placeholder username validation check\n    private boolean isUserNameValid(String username) {\n        if (username == null) {\n            return false;\n        }\n        if (username.contains(\"@\")) {\n            return Patterns.EMAIL_ADDRESS.matcher(username).matches();\n        } else {\n            return !username.trim().isEmpty();\n        }\n    }\n\n    // A placeholder password validation check\n    private boolean isPasswordValid(String password) {\n        return password != null && password.trim().length() > 5;\n    }\n}\n";
    }
}

