/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.declaration;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.naming.NameSuggestion;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.declaration.PropertyTranslatorKt;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DelegationResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001$B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J(\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J \u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0006\u0010\u001f\u001a\u00020\u0011J \u0010 \u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\u000fH\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\t\u001a\r\u0012\t\u0012\u00070\u000b\u00a2\u0006\u0002\b\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/js/translate/declaration/DelegationTranslator;", "Lorg/jetbrains/kotlin/js/translate/general/AbstractTranslator;", "classDeclaration", "Lorg/jetbrains/kotlin/psi/KtPureClassOrObject;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "(Lorg/jetbrains/kotlin/psi/KtPureClassOrObject;Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "delegationBySpecifiers", "", "Lorg/jetbrains/kotlin/psi/KtDelegatedSuperTypeEntry;", "Lkotlin/internal/NoInfer;", "fields", "", "Lorg/jetbrains/kotlin/js/translate/declaration/DelegationTranslator$Field;", "addInitCode", "", "statements", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "generateDelegateCallForFunctionMember", "specifier", "Lorg/jetbrains/kotlin/psi/KtSuperTypeListEntry;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "overriddenDescriptor", "delegateName", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "generateDelegateCallForPropertyMember", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "generateDelegated", "generateDelegates", "toClass", "field", "getSuperClass", "Field", "js.translator"})
public final class DelegationTranslator
extends AbstractTranslator {
    @NotNull
    private final ClassDescriptor classDescriptor;
    @NotNull
    private final List<KtDelegatedSuperTypeEntry> delegationBySpecifiers;
    @NotNull
    private final Map<KtDelegatedSuperTypeEntry, Field> fields;

    /*
     * WARNING - void declaration
     */
    public DelegationTranslator(@NotNull KtPureClassOrObject classDeclaration, @NotNull TranslationContext context2) {
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        Intrinsics.checkNotNullParameter((Object)classDeclaration, (String)"classDeclaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2);
        ClassDescriptor classDescriptor = BindingUtils.getClassDescriptor(context2.bindingContext(), classDeclaration);
        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"getClassDescriptor(conte\u2026text(), classDeclaration)");
        this.classDescriptor = classDescriptor;
        List list2 = classDeclaration.getSuperTypeListEntries();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"classDeclaration.superTypeListEntries");
        Iterable iterable = list2;
        DelegationTranslator delegationTranslator = this;
        boolean $i$f$filterIsInstance = false;
        void var5_7 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtDelegatedSuperTypeEntry)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        delegationTranslator.delegationBySpecifiers = (List)destination$iv$iv;
        this.fields = new LinkedHashMap();
        for (KtDelegatedSuperTypeEntry specifier : this.delegationBySpecifiers) {
            JsName delegateName;
            String idForMangling;
            FqNameUnsafe classFqName;
            KtExpression expression2;
            if (specifier.getDelegateExpression() == null) {
                throw new IllegalArgumentException("delegate expression should not be null: " + specifier.getText());
            }
            BindingContext bindingContext = this.bindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"bindingContext()");
            PropertyDescriptor propertyDescriptor = CodegenUtil.getDelegatePropertyIfAny(expression2, this.classDescriptor, bindingContext);
            BindingContext bindingContext2 = this.bindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext2, (String)"bindingContext()");
            if (CodegenUtil.isFinalPropertyWithBackingField(propertyDescriptor, bindingContext2)) {
                JsName delegateName2;
                PropertyDescriptor propertyDescriptor2 = propertyDescriptor;
                Intrinsics.checkNotNull((Object)propertyDescriptor2);
                Intrinsics.checkNotNullExpressionValue((Object)context2.getNameForDescriptor(propertyDescriptor2), (String)"context.getNameForDescriptor(propertyDescriptor!!)");
                this.fields.put(specifier, new Field(delegateName2, false));
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)DescriptorUtils.getFqName(this.classDescriptor), (String)"getFqName(classDescriptor)");
            Intrinsics.checkNotNullExpressionValue((Object)classFqName.asString(), (String)"classFqName.asString()");
            String string2 = Namer.getDelegatePrefix();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDelegatePrefix()");
            String suggestedName = NameSuggestion.Companion.getStableMangledName(string2, idForMangling);
            Intrinsics.checkNotNullExpressionValue((Object)context2.getScopeForDescriptor(this.classDescriptor).declareFreshName(suggestedName + "_0"), (String)"context.getScopeForDescr\u2026ame(\"${suggestedName}_0\")");
            this.fields.put(specifier, new Field(delegateName, true));
        }
    }

    public final void addInitCode(@NotNull List<JsStatement> statements) {
        Intrinsics.checkNotNullParameter(statements, (String)"statements");
        for (KtDelegatedSuperTypeEntry specifier : this.delegationBySpecifiers) {
            JsExpression delegateInitExpr;
            JsNameRef lhs;
            JsNode jsNode;
            TranslationContext context2;
            KtExpression expression2;
            Field field;
            Intrinsics.checkNotNull((Object)this.fields.get(specifier));
            if (!field.getGenerateField()) continue;
            Intrinsics.checkNotNull((Object)specifier.getDelegateExpression());
            Intrinsics.checkNotNullExpressionValue((Object)this.context().innerBlock(), (String)"context().innerBlock()");
            Intrinsics.checkNotNullExpressionValue((Object)Translation.translateAsExpression(expression2, context2), (String)"translateAsExpression(expression, context)");
            Collection collection = statements;
            List<JsStatement> list2 = context2.dynamicContext().jsBlock().getStatements();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"context.dynamicContext().jsBlock().statements");
            CollectionsKt.addAll((Collection)collection, (Iterable)list2);
            Intrinsics.checkNotNullExpressionValue((Object)JsAstUtils.pureFqn(field.getName(), (JsExpression)new JsThisRef()), (String)"pureFqn(field.name, JsThisRef())");
            Collection collection2 = statements;
            JsBinaryOperation $this$addInitCode_u24lambda_u2d0 = jsNode = JsAstUtils.assignment(lhs, delegateInitExpr);
            boolean bl = false;
            $this$addInitCode_u24lambda_u2d0.setSource(specifier);
            jsNode = jsNode.makeStmt();
            collection2.add(jsNode);
        }
    }

    public final void generateDelegated() {
        for (KtDelegatedSuperTypeEntry specifier : this.delegationBySpecifiers) {
            ClassDescriptor it;
            if (this.getSuperClass((KtSuperTypeListEntry)specifier) == null) continue;
            boolean bl = false;
            KtSuperTypeListEntry ktSuperTypeListEntry = (KtSuperTypeListEntry)specifier;
            Field field = this.fields.get(specifier);
            Intrinsics.checkNotNull((Object)field);
            this.generateDelegates(ktSuperTypeListEntry, it, field);
        }
    }

    private final ClassDescriptor getSuperClass(KtSuperTypeListEntry specifier) {
        BindingContext bindingContext = this.bindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"bindingContext()");
        ClassDescriptor classDescriptor = CodegenUtil.getSuperClassBySuperTypeListEntry(specifier, bindingContext);
        if (classDescriptor == null) {
            throw new IllegalStateException(("ClassDescriptor of superType should not be null: " + specifier.getText()).toString());
        }
        return classDescriptor;
    }

    private final void generateDelegates(KtSuperTypeListEntry specifier, ClassDescriptor toClass, Field field) {
        for (Map.Entry entry : DelegationResolver.Companion.getDelegates$default(DelegationResolver.Companion, this.classDescriptor, toClass, null, 4, null).entrySet()) {
            CallableMemberDescriptor descriptor2 = (CallableMemberDescriptor)entry.getKey();
            CallableMemberDescriptor overriddenDescriptor2 = (CallableMemberDescriptor)entry.getValue();
            CallableMemberDescriptor callableMemberDescriptor = descriptor2;
            if (callableMemberDescriptor instanceof PropertyDescriptor) {
                this.generateDelegateCallForPropertyMember(specifier, (PropertyDescriptor)descriptor2, field.getName());
                continue;
            }
            if (callableMemberDescriptor instanceof FunctionDescriptor) {
                this.generateDelegateCallForFunctionMember(specifier, (FunctionDescriptor)descriptor2, (FunctionDescriptor)overriddenDescriptor2, field.getName());
                continue;
            }
            throw new IllegalArgumentException("Expected property or function " + descriptor2);
        }
    }

    private final void generateDelegateCallForPropertyMember(KtSuperTypeListEntry specifier, PropertyDescriptor descriptor2, JsName delegateName) {
        String string2 = descriptor2.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"descriptor.name.asString()");
        String propertyName = string2;
        if (DescriptorUtilsKt.isExtensionProperty(descriptor2) || TranslationUtils.shouldAccessViaFunctions((CallableDescriptor)descriptor2)) {
            PropertyGetterDescriptor propertyGetterDescriptor = descriptor2.getGetter();
            Intrinsics.checkNotNull((Object)propertyGetterDescriptor);
            PropertyGetterDescriptor getter2 = propertyGetterDescriptor;
            TranslationContext translationContext = this.context();
            TranslationContext translationContext2 = this.context();
            Intrinsics.checkNotNullExpressionValue((Object)translationContext2, (String)"context()");
            translationContext.addDeclarationStatement(UtilsKt.addFunctionToPrototype(translationContext2, this.classDescriptor, getter2, DelegationTranslator.generateDelegateCallForPropertyMember$generateDelegateGetterFunction(delegateName, descriptor2, this, propertyName, specifier, getter2)));
            if (descriptor2.isVar()) {
                PropertySetterDescriptor propertySetterDescriptor = descriptor2.getSetter();
                Intrinsics.checkNotNull((Object)propertySetterDescriptor);
                PropertySetterDescriptor setter2 = propertySetterDescriptor;
                TranslationContext translationContext3 = this.context();
                TranslationContext translationContext4 = this.context();
                Intrinsics.checkNotNullExpressionValue((Object)translationContext4, (String)"context()");
                translationContext3.addDeclarationStatement(UtilsKt.addFunctionToPrototype(translationContext4, this.classDescriptor, setter2, DelegationTranslator.generateDelegateCallForPropertyMember$generateDelegateSetterFunction(this, specifier, delegateName, descriptor2, propertyName, setter2)));
            }
        } else {
            JsObjectLiteral literal = new JsObjectLiteral(true);
            List<JsPropertyInitializer> list2 = literal.getPropertyInitializers();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"literal.propertyInitializers");
            Collection collection = list2;
            collection.add(new JsPropertyInitializer(new JsStringLiteral("configurable"), new JsBooleanLiteral(true)));
            List<JsPropertyInitializer> list3 = literal.getPropertyInitializers();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"literal.propertyInitializers");
            PropertyTranslatorKt.addGetterAndSetter(list3, descriptor2, (Function0<? extends JsPropertyInitializer>)((Function0)new Function0<JsPropertyInitializer>(descriptor2, delegateName, this, propertyName, specifier){
                final /* synthetic */ PropertyDescriptor $descriptor;
                final /* synthetic */ JsName $delegateName;
                final /* synthetic */ DelegationTranslator this$0;
                final /* synthetic */ String $propertyName;
                final /* synthetic */ KtSuperTypeListEntry $specifier;
                {
                    this.$descriptor = $descriptor;
                    this.$delegateName = $delegateName;
                    this.this$0 = $receiver;
                    this.$propertyName = $propertyName;
                    this.$specifier = $specifier;
                    super(0);
                }

                @NotNull
                public final JsPropertyInitializer invoke() {
                    return DelegationTranslator.access$generateDelegateCallForPropertyMember$generateDelegateGetter(this.$descriptor, this.$delegateName, this.this$0, this.$propertyName, this.$specifier);
                }

                @NotNull
                public final String getSignature() {
                    return "generateDelegateCallForPropertyMember$generateDelegateGetter(Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;Lorg/jetbrains/kotlin/js/backend/ast/JsName;Lorg/jetbrains/kotlin/js/translate/declaration/DelegationTranslator;Ljava/lang/String;Lorg/jetbrains/kotlin/psi/KtSuperTypeListEntry;)Lorg/jetbrains/kotlin/js/backend/ast/JsPropertyInitializer;";
                }

                @NotNull
                public final String getName() {
                    return "generateDelegateGetter";
                }

                @NotNull
                public final KDeclarationContainer getOwner() {
                    return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(Intrinsics.Kotlin.class);
                }
            }), (Function0<? extends JsPropertyInitializer>)((Function0)new Function0<JsPropertyInitializer>(descriptor2, this, specifier, delegateName, propertyName){
                final /* synthetic */ PropertyDescriptor $descriptor;
                final /* synthetic */ DelegationTranslator this$0;
                final /* synthetic */ KtSuperTypeListEntry $specifier;
                final /* synthetic */ JsName $delegateName;
                final /* synthetic */ String $propertyName;
                {
                    this.$descriptor = $descriptor;
                    this.this$0 = $receiver;
                    this.$specifier = $specifier;
                    this.$delegateName = $delegateName;
                    this.$propertyName = $propertyName;
                    super(0);
                }

                @NotNull
                public final JsPropertyInitializer invoke() {
                    return DelegationTranslator.access$generateDelegateCallForPropertyMember$generateDelegateSetter(this.$descriptor, this.this$0, this.$specifier, this.$delegateName, this.$propertyName);
                }

                @NotNull
                public final String getSignature() {
                    return "generateDelegateCallForPropertyMember$generateDelegateSetter(Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;Lorg/jetbrains/kotlin/js/translate/declaration/DelegationTranslator;Lorg/jetbrains/kotlin/psi/KtSuperTypeListEntry;Lorg/jetbrains/kotlin/js/backend/ast/JsName;Ljava/lang/String;)Lorg/jetbrains/kotlin/js/backend/ast/JsPropertyInitializer;";
                }

                @NotNull
                public final String getName() {
                    return "generateDelegateSetter";
                }

                @NotNull
                public final KDeclarationContainer getOwner() {
                    return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(Intrinsics.Kotlin.class);
                }
            }));
            TranslationContext translationContext = this.context();
            Intrinsics.checkNotNullExpressionValue((Object)translationContext, (String)"context()");
            UtilsKt.addAccessorsToPrototype(translationContext, this.classDescriptor, descriptor2, literal);
        }
    }

    private final void generateDelegateCallForFunctionMember(KtSuperTypeListEntry specifier, FunctionDescriptor descriptor2, FunctionDescriptor overriddenDescriptor2, JsName delegateName) {
        JsNameRef delegateRef = new JsNameRef(delegateName, (JsExpression)new JsThisRef());
        JsExpression jsExpression = delegateRef;
        TranslationContext translationContext = this.context().newDeclaration(overriddenDescriptor2);
        Intrinsics.checkNotNullExpressionValue((Object)translationContext, (String)"context().newDeclaration(overriddenDescriptor)");
        JsStatement statement2 = UtilsKt.generateDelegateCall(this.classDescriptor, descriptor2, overriddenDescriptor2, jsExpression, translationContext, true, (PsiElement)specifier);
        this.context().addDeclarationStatement(statement2);
    }

    private static final JsFunction generateDelegateCallForPropertyMember$generateDelegateGetterFunction(JsName $delegateName, PropertyDescriptor $descriptor, DelegationTranslator this$0, String propertyName, KtSuperTypeListEntry $specifier, PropertyGetterDescriptor getterDescriptor) {
        JsExpression jsExpression;
        JsNameRef delegateRef = new JsNameRef($delegateName, (JsExpression)new JsThisRef());
        if (DescriptorUtils.isExtension($descriptor)) {
            JsName jsName = this$0.context().getNameForDescriptor(getterDescriptor);
            Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"context().getNameForDescriptor(getterDescriptor)");
            JsName getterName = jsName;
            String string2 = Namer.getReceiverParameterName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getReceiverParameterName()");
            String receiver = string2;
            JsExpression[] jsExpressionArray = new JsExpression[]{new JsNameRef(receiver)};
            jsExpression = new JsInvocation((JsExpression)new JsNameRef(getterName, (JsExpression)delegateRef), jsExpressionArray);
        } else {
            jsExpression = new JsNameRef(propertyName, (JsExpression)delegateRef);
        }
        JsExpression returnExpression = jsExpression;
        returnExpression.source($specifier);
        JsFunction jsFunction = TranslationUtils.simpleReturnFunction(this$0.context().getScopeForDescriptor(getterDescriptor.getContainingDeclaration()), returnExpression);
        Intrinsics.checkNotNullExpressionValue((Object)jsFunction, (String)"simpleReturnFunction(con\u2026ation), returnExpression)");
        JsFunction jsFunction2 = jsFunction;
        jsFunction2.setSource($specifier);
        if (DescriptorUtils.isExtension($descriptor)) {
            JsName jsName = jsFunction2.getScope().declareName(Namer.getReceiverParameterName());
            Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"jsFunction.scope.declare\u2026tReceiverParameterName())");
            JsName receiverName = jsName;
            jsFunction2.getParameters().add(new JsParameter(receiverName));
        }
        return jsFunction2;
    }

    /*
     * WARNING - void declaration
     */
    private static final JsFunction generateDelegateCallForPropertyMember$generateDelegateSetterFunction(DelegationTranslator this$0, KtSuperTypeListEntry $specifier, JsName $delegateName, PropertyDescriptor $descriptor, String propertyName, PropertySetterDescriptor setterDescriptor) {
        void $this$generateDelegateCallForPropertyMember_u24generateDelegateSetterFunction_u24lambda_u2d3;
        JsExpression propertyNameRef;
        JsExpression jsExpression;
        boolean bl;
        JsFunction jsFunction = new JsFunction(this$0.context().program().getRootScope(), "setter for " + setterDescriptor.getName().asString());
        jsFunction.setSource($specifier);
        boolean bl2 = bl = setterDescriptor.getValueParameters().size() == 1;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-DelegationTranslator$generateDelegateCallForPropertyMember$generateDelegateSetterFunction$22 = false;
            String $i$a$-assert-DelegationTranslator$generateDelegateCallForPropertyMember$generateDelegateSetterFunction$22 = "Setter must have 1 parameter";
            throw new AssertionError((Object)$i$a$-assert-DelegationTranslator$generateDelegateCallForPropertyMember$generateDelegateSetterFunction$22);
        }
        JsParameter defaultParameter = new JsParameter(JsScope.declareTemporary());
        JsNameRef jsNameRef = defaultParameter.getName().makeRef();
        Intrinsics.checkNotNullExpressionValue((Object)jsNameRef, (String)"defaultParameter.name.makeRef()");
        JsNameRef defaultParameterRef = jsNameRef;
        JsNameRef delegateRef = new JsNameRef($delegateName, (JsExpression)new JsThisRef());
        if (DescriptorUtils.isExtension($descriptor)) {
            JsName jsName = this$0.context().getNameForDescriptor(setterDescriptor);
            Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"context().getNameForDescriptor(setterDescriptor)");
            JsName setterName = jsName;
            JsNameRef setterNameRef = new JsNameRef(setterName, (JsExpression)delegateRef);
            JsName jsName2 = jsFunction.getScope().declareName(Namer.getReceiverParameterName());
            Intrinsics.checkNotNullExpressionValue((Object)jsName2, (String)"jsFunction.scope.declare\u2026tReceiverParameterName())");
            JsName extensionFunctionReceiverName = jsName2;
            jsFunction.getParameters().add(new JsParameter(extensionFunctionReceiverName));
            JsExpression[] jsExpressionArray = new JsExpression[]{new JsNameRef(extensionFunctionReceiverName), defaultParameterRef};
            jsExpression = new JsInvocation((JsExpression)setterNameRef, jsExpressionArray);
        } else {
            propertyNameRef = new JsNameRef(propertyName, (JsExpression)delegateRef);
            JsBinaryOperation jsBinaryOperation = JsAstUtils.assignment(propertyNameRef, defaultParameterRef);
            Intrinsics.checkNotNullExpressionValue((Object)jsBinaryOperation, (String)"{\n                val pr\u2026rameterRef)\n            }");
            jsExpression = jsBinaryOperation;
        }
        JsExpression setExpression = jsExpression;
        jsFunction.getParameters().add(defaultParameter);
        JsExpression jsExpression2 = setExpression;
        propertyNameRef = jsExpression2;
        JsFunction jsFunction2 = jsFunction;
        boolean bl3 = false;
        $this$generateDelegateCallForPropertyMember_u24generateDelegateSetterFunction_u24lambda_u2d3.setSource($specifier);
        JsStatement jsStatement = jsExpression2.makeStmt();
        jsFunction2.setBody(new JsBlock(jsStatement));
        return jsFunction;
    }

    private static final JsPropertyInitializer generateDelegateCallForPropertyMember$generateDelegateAccessor(DelegationTranslator this$0, PropertyAccessorDescriptor accessorDescriptor, JsFunction function2) {
        JsPropertyInitializer jsPropertyInitializer = TranslationUtils.translateFunctionAsEcma5PropertyDescriptor(function2, accessorDescriptor, this$0.context());
        Intrinsics.checkNotNullExpressionValue((Object)jsPropertyInitializer, (String)"translateFunctionAsEcma5\u2026sorDescriptor, context())");
        return jsPropertyInitializer;
    }

    private static final JsPropertyInitializer generateDelegateCallForPropertyMember$generateDelegateGetter(PropertyDescriptor $descriptor, JsName $delegateName, DelegationTranslator this$0, String propertyName, KtSuperTypeListEntry $specifier) {
        PropertyGetterDescriptor propertyGetterDescriptor = $descriptor.getGetter();
        if (propertyGetterDescriptor == null) {
            throw new IllegalStateException("Getter descriptor should not be null");
        }
        PropertyGetterDescriptor getterDescriptor = propertyGetterDescriptor;
        return DelegationTranslator.generateDelegateCallForPropertyMember$generateDelegateAccessor(this$0, getterDescriptor, DelegationTranslator.generateDelegateCallForPropertyMember$generateDelegateGetterFunction($delegateName, $descriptor, this$0, propertyName, $specifier, getterDescriptor));
    }

    private static final JsPropertyInitializer generateDelegateCallForPropertyMember$generateDelegateSetter(PropertyDescriptor $descriptor, DelegationTranslator this$0, KtSuperTypeListEntry $specifier, JsName $delegateName, String propertyName) {
        PropertySetterDescriptor propertySetterDescriptor = $descriptor.getSetter();
        if (propertySetterDescriptor == null) {
            throw new IllegalStateException("Setter descriptor should not be null");
        }
        PropertySetterDescriptor setterDescriptor = propertySetterDescriptor;
        return DelegationTranslator.generateDelegateCallForPropertyMember$generateDelegateAccessor(this$0, setterDescriptor, DelegationTranslator.generateDelegateCallForPropertyMember$generateDelegateSetterFunction(this$0, $specifier, $delegateName, $descriptor, propertyName, setterDescriptor));
    }

    public static final /* synthetic */ JsPropertyInitializer access$generateDelegateCallForPropertyMember$generateDelegateGetter(PropertyDescriptor $descriptor, JsName $delegateName, DelegationTranslator this$0, String propertyName, KtSuperTypeListEntry $specifier) {
        return DelegationTranslator.generateDelegateCallForPropertyMember$generateDelegateGetter($descriptor, $delegateName, this$0, propertyName, $specifier);
    }

    public static final /* synthetic */ JsPropertyInitializer access$generateDelegateCallForPropertyMember$generateDelegateSetter(PropertyDescriptor $descriptor, DelegationTranslator this$0, KtSuperTypeListEntry $specifier, JsName $delegateName, String propertyName) {
        return DelegationTranslator.generateDelegateCallForPropertyMember$generateDelegateSetter($descriptor, this$0, $specifier, $delegateName, propertyName);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/js/translate/declaration/DelegationTranslator$Field;", "", "name", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "generateField", "", "(Lorg/jetbrains/kotlin/js/backend/ast/JsName;Z)V", "getGenerateField", "()Z", "getName", "()Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "js.translator"})
    private static final class Field {
        @NotNull
        private final JsName name;
        private final boolean generateField;

        public Field(@NotNull JsName name, boolean generateField2) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.generateField = generateField2;
        }

        @NotNull
        public final JsName getName() {
            return this.name;
        }

        public final boolean getGenerateField() {
            return this.generateField;
        }
    }
}

