/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.cfg.ControlFlowInformationProvider;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodiesResolveContext;
import org.jetbrains.kotlin.resolve.checkers.PlatformDiagnosticSuppressor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

public class ControlFlowAnalyzer {
    private final BindingTrace trace;
    private final KotlinBuiltIns builtIns;
    private final LanguageVersionSettings languageVersionSettings;
    private final PlatformDiagnosticSuppressor diagnosticSuppressor;
    private final ControlFlowInformationProvider.Factory controlFlowInformationProviderFactory;

    public ControlFlowAnalyzer(@NotNull BindingTrace trace, @NotNull KotlinBuiltIns builtIns, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull PlatformDiagnosticSuppressor diagnosticSuppressor, @NotNull ControlFlowInformationProvider.Factory controlFlowInformationProviderFactory) {
        if (trace == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(0);
        }
        if (builtIns == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(1);
        }
        if (languageVersionSettings == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(2);
        }
        if (diagnosticSuppressor == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(3);
        }
        if (controlFlowInformationProviderFactory == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(4);
        }
        this.trace = trace;
        this.builtIns = builtIns;
        this.languageVersionSettings = languageVersionSettings;
        this.diagnosticSuppressor = diagnosticSuppressor;
        this.controlFlowInformationProviderFactory = controlFlowInformationProviderFactory;
    }

    public void process(@NotNull BodiesResolveContext c) {
        if (c == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(5);
        }
        for (KtFile ktFile : c.getFiles()) {
            this.checkDeclarationContainer(c, (KtDeclarationContainer)ktFile);
        }
        for (KtClassOrObject ktClassOrObject : c.getDeclaredClasses().keySet()) {
            this.checkDeclarationContainer(c, (KtDeclarationContainer)ktClassOrObject);
        }
        for (KtScript ktScript : c.getScripts().keySet()) {
            this.checkDeclarationContainer(c, (KtDeclarationContainer)ktScript);
        }
        for (KtSecondaryConstructor ktSecondaryConstructor : c.getSecondaryConstructors().keySet()) {
            this.checkSecondaryConstructor(ktSecondaryConstructor);
        }
        for (Map.Entry entry : c.getFunctions().entrySet()) {
            KtNamedFunction function2 = (KtNamedFunction)entry.getKey();
            SimpleFunctionDescriptor functionDescriptor = (SimpleFunctionDescriptor)entry.getValue();
            KotlinType expectedReturnType = !function2.hasBlockBody() && !function2.hasDeclaredReturnType() ? TypeUtils.NO_EXPECTED_TYPE : functionDescriptor.getReturnType();
            this.checkFunction(c, (KtDeclarationWithBody)function2, expectedReturnType);
        }
        for (Map.Entry entry : c.getProperties().entrySet()) {
            KtProperty property = (KtProperty)entry.getKey();
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)entry.getValue();
            this.checkProperty(c, property, propertyDescriptor);
        }
    }

    private void checkSecondaryConstructor(@NotNull KtSecondaryConstructor constructor) {
        if (constructor == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(6);
        }
        ControlFlowInformationProvider controlFlowInformationProvider = this.controlFlowInformationProviderFactory.createControlFlowInformationProvider((KtElement)constructor, this.trace, this.languageVersionSettings, this.diagnosticSuppressor);
        controlFlowInformationProvider.checkDeclaration();
        controlFlowInformationProvider.checkFunction(this.builtIns.getUnitType());
    }

    private void checkDeclarationContainer(@NotNull BodiesResolveContext c, KtDeclarationContainer declarationContainer) {
        if (c == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(7);
        }
        ControlFlowInformationProvider controlFlowInformationProvider = this.controlFlowInformationProviderFactory.createControlFlowInformationProvider((KtElement)declarationContainer, this.trace, this.languageVersionSettings, this.diagnosticSuppressor);
        if (c.getTopDownAnalysisMode().isLocalDeclarations()) {
            controlFlowInformationProvider.checkForLocalClassOrObjectMode();
            return;
        }
        controlFlowInformationProvider.checkDeclaration();
    }

    private void checkProperty(@NotNull BodiesResolveContext c, KtProperty property, PropertyDescriptor propertyDescriptor) {
        if (c == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(8);
        }
        for (KtPropertyAccessor accessor : property.getAccessors()) {
            PropertyAccessorDescriptor accessorDescriptor;
            PropertyAccessorDescriptor propertyAccessorDescriptor = accessorDescriptor = accessor.isGetter() ? propertyDescriptor.getGetter() : propertyDescriptor.getSetter();
            assert (accessorDescriptor != null) : "no property accessor descriptor " + accessor.getText();
            KotlinType returnType = accessorDescriptor.getReturnType();
            this.checkFunction(c, (KtDeclarationWithBody)accessor, returnType);
        }
    }

    private void checkFunction(@NotNull BodiesResolveContext c, @NotNull KtDeclarationWithBody function2, @Nullable KotlinType expectedReturnType) {
        if (c == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(9);
        }
        if (function2 == null) {
            ControlFlowAnalyzer.$$$reportNull$$$0(10);
        }
        ControlFlowInformationProvider controlFlowInformationProvider = this.controlFlowInformationProviderFactory.createControlFlowInformationProvider((KtElement)function2, this.trace, this.languageVersionSettings, this.diagnosticSuppressor);
        if (c.getTopDownAnalysisMode().isLocalDeclarations()) {
            controlFlowInformationProvider.checkForLocalClassOrObjectMode();
            return;
        }
        controlFlowInformationProvider.checkDeclaration();
        controlFlowInformationProvider.checkFunction(expectedReturnType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builtIns";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageVersionSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnosticSuppressor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controlFlowInformationProviderFactory";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/resolve/ControlFlowAnalyzer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "checkSecondaryConstructor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "checkDeclarationContainer";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "checkProperty";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFunction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

