/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.vars;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.VarNamesCollector;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarDefinitionHelper;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionsProcessor;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.TextUtil;

public class VarProcessor {
    public static final int VAR_NON_FINAL = 1;
    public static final int VAR_EXPLICIT_FINAL = 2;
    public static final int VAR_FINAL = 3;
    private final VarNamesCollector varNamesCollector = new VarNamesCollector();
    private final StructMethod method;
    private final MethodDescriptor methodDescriptor;
    private Map<VarVersionPair, String> mapVarNames = new HashMap<VarVersionPair, String>();
    private VarVersionsProcessor varVersions;
    private final Map<VarVersionPair, String> thisVars = new HashMap<VarVersionPair, String>();
    private final Set<VarVersionPair> externalVars = new HashSet<VarVersionPair>();
    private final BitSet finalParameters = new BitSet();
    private final int firstParameterVarIndex;
    private final int firstParameterPosition;

    public VarProcessor(StructClass cl, StructMethod mt, MethodDescriptor md) {
        boolean isEnumInit;
        this.method = mt;
        this.methodDescriptor = md;
        boolean isEnum = cl.hasModifier(16384) && DecompilerContext.getOption("den");
        boolean bl = isEnumInit = isEnum && "<init>".equals(mt.getName());
        this.firstParameterVarIndex = isEnumInit ? 3 : (!mt.hasModifier(8) ? 1 : 0);
        this.firstParameterPosition = isEnumInit ? 2 : 0;
    }

    public void setVarVersions(RootStatement root) {
        VarVersionsProcessor oldProcessor = this.varVersions;
        this.varVersions = new VarVersionsProcessor(this.method, this.methodDescriptor);
        this.varVersions.setVarVersions(root, oldProcessor);
    }

    public void setVarDefinitions(Statement root) {
        this.mapVarNames = new HashMap<VarVersionPair, String>();
        new VarDefinitionHelper(root, this.method, this).setVarDefinitions();
    }

    public void setDebugVarNames(Map<Integer, String> mapDebugVarNames) {
        if (this.varVersions == null) {
            return;
        }
        Map<Integer, Integer> mapOriginalVarIndices = this.varVersions.getMapOriginalVarIndices();
        ArrayList<VarVersionPair> listVars = new ArrayList<VarVersionPair>(this.mapVarNames.keySet());
        listVars.sort(Comparator.comparingInt(o -> o.var));
        HashMap<String, Integer> mapNames = new HashMap<String, Integer>();
        for (VarVersionPair pair : listVars) {
            Integer counter;
            String debugName;
            Object name = this.mapVarNames.get(pair);
            Integer index = mapOriginalVarIndices.get(pair.var);
            if (index != null && (debugName = mapDebugVarNames.get(index)) != null && TextUtil.isValidIdentifier(debugName, this.method.getBytecodeVersion())) {
                name = debugName;
            }
            mapNames.put((String)name, (counter = (Integer)mapNames.get(name)) == null ? (counter = Integer.valueOf(0)) : (counter = Integer.valueOf(counter + 1)));
            if (counter > 0) {
                name = (String)name + String.valueOf(counter);
            }
            this.mapVarNames.put(pair, (String)name);
        }
    }

    public Integer getVarOriginalIndex(int index) {
        return this.varVersions == null ? null : this.varVersions.getMapOriginalVarIndices().get(index);
    }

    public void refreshVarNames(VarNamesCollector vc) {
        HashMap<VarVersionPair, String> tempVarNames = new HashMap<VarVersionPair, String>(this.mapVarNames);
        for (Map.Entry ent : tempVarNames.entrySet()) {
            this.mapVarNames.put((VarVersionPair)ent.getKey(), vc.getFreeName((String)ent.getValue()));
        }
    }

    public VarNamesCollector getVarNamesCollector() {
        return this.varNamesCollector;
    }

    public VarType getVarType(VarVersionPair pair) {
        return this.varVersions == null ? null : this.varVersions.getVarType(pair);
    }

    public void setVarType(VarVersionPair pair, VarType type) {
        this.varVersions.setVarType(pair, type);
    }

    public String getVarName(VarVersionPair pair) {
        return this.mapVarNames == null ? null : this.mapVarNames.get(pair);
    }

    public void setVarName(VarVersionPair pair, String name) {
        this.mapVarNames.put(pair, name);
    }

    public Collection<String> getVarNames() {
        return this.mapVarNames != null ? this.mapVarNames.values() : Collections.emptySet();
    }

    public int getVarFinal(VarVersionPair pair) {
        return this.varVersions == null ? 3 : this.varVersions.getVarFinal(pair);
    }

    public void setVarFinal(VarVersionPair pair, int finalType) {
        this.varVersions.setVarFinal(pair, finalType);
    }

    public Map<VarVersionPair, String> getThisVars() {
        return this.thisVars;
    }

    public Set<VarVersionPair> getExternalVars() {
        return this.externalVars;
    }

    public boolean isParameterFinal(VarVersionPair pair) {
        return this.finalParameters.get(pair.var);
    }

    public void setParameterFinal(VarVersionPair pair) {
        this.finalParameters.set(pair.var);
    }

    public int getFirstParameterVarIndex() {
        return this.firstParameterVarIndex;
    }

    public int getFirstParameterPosition() {
        return this.firstParameterPosition;
    }
}

