/*
 * Decompiled with CFR 0.152.
 */
package circlet.platform.client;

import circlet.platform.api.Packet;
import circlet.platform.api.PacketMeta;
import circlet.platform.api.ServerStats;
import circlet.platform.api.serialization.ExtendableSerializationRegistry;
import circlet.platform.api.services.ArenaResponse;
import circlet.platform.api.services.impl.ParserFunctionsKt;
import circlet.platform.client.ConnectionStatus;
import circlet.platform.client.PushHandler;
import circlet.platform.client.RpcDeserializerException;
import circlet.platform.client.RpcRequest;
import circlet.platform.client.RpcResponse;
import circlet.platform.client.StableConnection;
import circlet.platform.client.Transport;
import circlet.platform.client.WebSocketTransport;
import circlet.platform.client.WebSocketTransportKt;
import circlet.platform.metrics.product.Metrics;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.channels.ReceiveChannel;
import libraries.basics.Sync;
import libraries.coroutines.extra.ChannelKt;
import libraries.coroutines.extra.CoroutineBuildersCommonKt;
import libraries.coroutines.extra.Lifetime;
import libraries.coroutines.extra.LifetimeContext;
import libraries.coroutines.extra.LifetimeSource;
import libraries.coroutines.extra.LifetimeUtilsKt;
import libraries.klogging.KLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.DispatchJvmKt;
import runtime.FailureInfo;
import runtime.RpcException;
import runtime.RpcExceptionKt;
import runtime.RpcServerCancellationException;
import runtime.RpcServerRateLimitedException;
import runtime.RpcTimeoutException;
import runtime.TimeService;
import runtime.async.AtomicInteger;
import runtime.async.AtomicKt;
import runtime.json.JsonBuilderContext;
import runtime.json.JsonDslKt;
import runtime.json.JsonElement;
import runtime.json.JsonObject;
import runtime.json.JsonObjectWrapper;
import runtime.reactive.Property;
import runtime.reactive.Result;
import runtime.reactive.Source;
import runtime.reactive.SourceKt;
import runtime.routing.ActionCookies;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001_B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010:\u001a\u0002052\u0006\u0010;\u001a\u00020\u00132\u0006\u0010<\u001a\u00020\u0013H\u0016Jh\u0010=\u001a\u000205\"\b\b\u0000\u0010>*\u0002092\u0006\u0010?\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010@\u001a\u000e\u0012\u0004\u0012\u00020B\u0012\u0004\u0012\u0002H>0A2(\u0010C\u001a$\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H>0E\u0012\n\u0012\b\u0012\u0004\u0012\u0002050F\u0012\u0006\u0012\u0004\u0018\u0001090DH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010GJ&\u0010H\u001a\u0002052\u0006\u0010?\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010C\u001a\b\u0012\u0004\u0012\u00020504H\u0016J$\u0010I\u001a\u0002H>\"\u0004\b\u0000\u0010>2\u000e\b\u0004\u0010J\u001a\b\u0012\u0004\u0012\u0002H>04H\u0082\b\u00a2\u0006\u0002\u0010KJ\u0010\u0010L\u001a\u0002052\u0006\u0010M\u001a\u00020\u0013H\u0002J\b\u0010N\u001a\u000205H\u0002J\u0019\u0010O\u001a\u0002052\u0006\u0010P\u001a\u00020BH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010QJ\u0010\u0010R\u001a\u0002052\u0006\u0010P\u001a\u00020BH\u0002JU\u0010S\u001a\b\u0012\u0004\u0012\u0002H>0T\"\u0004\b\u0000\u0010>2\u0006\u0010?\u001a\u00020\u00132\u0006\u0010U\u001a\u00020V2\b\u0010W\u001a\u0004\u0018\u00010X2\b\u0010Y\u001a\u0004\u0018\u00010\u00192\u0012\u0010@\u001a\u000e\u0012\u0004\u0012\u00020B\u0012\u0004\u0012\u0002H>0AH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010ZJ\u001c\u0010[\u001a\u0002052\u0012\u0010\\\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130]H\u0002J\f\u0010^\u001a\u00020\u0013*\u00020BH\u0002R\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0018\u00010\u0015R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00130\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001c\u0010'\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u000e\u0010.\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010/\u001a&\u0012\u0004\u0012\u00020\u0019\u0012\b\u0012\u0006\u0012\u0002\b\u00030100j\u0012\u0012\u0004\u0012\u00020\u0019\u0012\b\u0012\u0006\u0012\u0002\b\u000301`2X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00103\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u000205040\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u00106\u001a\u0012\u0012\u0004\u0012\u00020\u0013\u0012\b\u0012\u0006\u0012\u0002\b\u0003070\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u000209X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006`"}, d2={"Lcirclet/platform/client/WebSocketTransport;", "Lcirclet/platform/client/Transport;", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "connection", "Lcirclet/platform/client/StableConnection;", "timeService", "Lruntime/TimeService;", "registry", "Lcirclet/platform/api/serialization/ExtendableSerializationRegistry;", "metrics", "Lcirclet/platform/metrics/product/Metrics;", "actionCookies", "Lruntime/routing/ActionCookies;", "(Llibraries/coroutines/extra/Lifetime;Lcirclet/platform/client/StableConnection;Lruntime/TimeService;Lcirclet/platform/api/serialization/ExtendableSerializationRegistry;Lcirclet/platform/metrics/product/Metrics;Lruntime/routing/ActionCookies;)V", "getActionCookies", "()Lruntime/routing/ActionCookies;", "apiVersions", "", "", "backOffProcess", "Lcirclet/platform/client/WebSocketTransport$BackOffProcess;", "getConnection", "()Lcirclet/platform/client/StableConnection;", "connectionGeneration", "", "getConnectionGeneration", "()I", "connectionStatus", "Lruntime/reactive/Property;", "Lcirclet/platform/client/ConnectionStatus;", "getConnectionStatus", "()Lruntime/reactive/Property;", "deadHandlers", "", "generation", "Lruntime/async/AtomicInteger;", "getLifetime", "()Llibraries/coroutines/extra/Lifetime;", "logReceivedMessagesAs", "getLogReceivedMessagesAs", "()Ljava/lang/String;", "setLogReceivedMessagesAs", "(Ljava/lang/String;)V", "getMetrics", "()Lcirclet/platform/metrics/product/Metrics;", "nextId", "outgoingRpc", "Ljava/util/LinkedHashMap;", "Lcirclet/platform/client/RpcRequest;", "Lkotlin/collections/LinkedHashMap;", "pushEndedHandlers", "Lkotlin/Function0;", "", "pushHandlers", "Lcirclet/platform/client/PushHandler;", "sync", "", "apiVersion", "service", "version", "handlePushes", "T", "path", "parser", "Lkotlin/Function1;", "Lcirclet/platform/api/Packet;", "handler", "Lkotlin/Function2;", "Lruntime/reactive/Result;", "Lkotlin/coroutines/Continuation;", "(Ljava/lang/String;Llibraries/coroutines/extra/Lifetime;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;)V", "handlePushesEnded", "lock", "inner", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "onConnectionAuthFail", "message", "onConnectionCreated", "onMessage", "packet", "(Lcirclet/platform/api/Packet;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "post", "rpc", "Lcirclet/platform/client/RpcResponse;", "payload", "Lruntime/json/JsonElement;", "meta", "Lcirclet/platform/api/PacketMeta;", "timeout", "(Ljava/lang/String;Lruntime/json/JsonElement;Lcirclet/platform/api/PacketMeta;Ljava/lang/Integer;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendApiVersions", "versions", "", "debugPrint", "BackOffProcess", "platform-client"})
public final class WebSocketTransport
implements Transport {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final StableConnection connection;
    @NotNull
    private final TimeService timeService;
    @NotNull
    private final ExtendableSerializationRegistry registry;
    @Nullable
    private final Metrics metrics;
    @Nullable
    private final ActionCookies actionCookies;
    @NotNull
    private final AtomicInteger nextId;
    @Nullable
    private BackOffProcess backOffProcess;
    @NotNull
    private final LinkedHashMap<Integer, RpcRequest<?>> outgoingRpc;
    @NotNull
    private final Map<String, PushHandler<?>> pushHandlers;
    @NotNull
    private final Set<String> deadHandlers;
    @NotNull
    private final Set<Function0<Unit>> pushEndedHandlers;
    @NotNull
    private final Map<String, String> apiVersions;
    @NotNull
    private final Object sync;
    @NotNull
    private final AtomicInteger generation;
    @Nullable
    private String logReceivedMessagesAs;

    public WebSocketTransport(@NotNull Lifetime lifetime, @NotNull StableConnection connection, @NotNull TimeService timeService, @NotNull ExtendableSerializationRegistry registry, @Nullable Metrics metrics, @Nullable ActionCookies actionCookies) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)timeService, (String)"timeService");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        this.lifetime = lifetime;
        this.connection = connection;
        this.timeService = timeService;
        this.registry = registry;
        this.metrics = metrics;
        this.actionCookies = actionCookies;
        this.nextId = AtomicKt.atomicInt(1);
        this.outgoingRpc = new LinkedHashMap();
        this.pushHandlers = new LinkedHashMap();
        this.deadHandlers = new LinkedHashSet();
        this.pushEndedHandlers = new LinkedHashSet();
        this.apiVersions = new LinkedHashMap();
        this.sync = new Object();
        this.generation = AtomicKt.atomicInt(0);
        SourceKt.view((Source)this.connection.getStatus(), this.lifetime, (Function2)new Function2<Lifetime, ConnectionStatus, Unit>(){

            public final void invoke(@NotNull Lifetime $noName_0, @NotNull ConnectionStatus value2) {
                Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"$noName_0");
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                if (value2 instanceof ConnectionStatus.AuthFailed) {
                    String string2 = ((ConnectionStatus.AuthFailed)value2).getMessage();
                    if (string2 == null) {
                        string2 = "Authentication failed";
                    }
                    this.onConnectionAuthFail(string2);
                }
                if (value2 instanceof ConnectionStatus.Connected) {
                    generation.incrementAndGet();
                    this.onConnectionCreated();
                }
            }
        });
        this.connection.getReceived().invokeOnClose((Function1)2.INSTANCE);
        ChannelKt.launchForEach$default((ReceiveChannel)this.connection.getReceived(), this.lifetime, DispatchJvmKt.getUi(), null, (Function2)new Function2<Packet, Continuation<? super Unit>, Object>(this, null){
            Object L$1;
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ WebSocketTransport this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var30_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        it = (Packet)this.L$0;
                        var3_4 = WebSocketTransportKt.access$getLog$p();
                        var4_5 = this.this$0;
                        $i$f$catch = false;
                        $this$internalCatch_u24default$iv$iv = $this$catch$iv;
                        except$iv$iv = CollectionsKt.emptyList();
                        $i$f$internalCatch = false;
                        $i$a$-catch-WebSocketTransport$3$2 = false;
                        if (var4_5.getLogReceivedMessagesAs() != null) {
                            this_$iv = WebSocketTransportKt.access$getLog$p();
                            $i$f$info = false;
                            if (this_$iv.isInfoEnabled()) {
                                var12_14 = this_$iv;
                                $i$a$-info-WebSocketTransport$3$2$1 = false;
                                var12_14.info(var4_5.getLogReceivedMessagesAs() + " received " + WebSocketTransport.access$debugPrint(var4_5, it));
                            }
                        }
                        this.L$0 = $this$internalCatch_u24default$iv$iv;
                        this.L$1 = except$iv$iv;
                        this.label = 1;
                        v0 = WebSocketTransport.access$onMessage(var4_5, it, (Continuation)this);
                        ** if (v0 != var30_2) goto lbl29
lbl28:
                        // 1 sources

                        return var30_2;
lbl29:
                        // 1 sources

                        ** GOTO lbl40
                    }
                    case 1: {
                        $i$f$catch = false;
                        $i$f$internalCatch = false;
                        $i$a$-catch-WebSocketTransport$3$2 = false;
                        except$iv$iv = (List)this.L$1;
                        $this$internalCatch_u24default$iv$iv = (KLogger)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl40:
                            // 2 sources

                            var14_16 = Unit.INSTANCE;
                        }
                        catch (Throwable th$iv$iv) {
                            $i$f$isCancellationException = false;
                            if (th$iv$iv instanceof InterruptedException != false || th$iv$iv instanceof CancellationException != false) {
                                throw th$iv$iv;
                            }
                            $this$any$iv$iv$iv = except$iv$iv;
                            $i$f$any = false;
                            if (!($this$any$iv$iv$iv instanceof Collection) || !((Collection)$this$any$iv$iv$iv).isEmpty()) ** GOTO lbl51
                            v1 = false;
                            ** GOTO lbl58
lbl51:
                            // 2 sources

                            for (T element$iv$iv$iv : $this$any$iv$iv$iv) {
                                it$iv$iv = (KClass)element$iv$iv$iv;
                                $i$a$-any-KLoggerExKt$internalCatch$1$iv$iv = false;
                                if (!it$iv$iv.isInstance((Object)th$iv$iv)) continue;
                                v1 = true;
                                ** GOTO lbl58
                            }
                            v1 = false;
lbl58:
                            // 3 sources

                            if (v1) {
                                throw th$iv$iv;
                            }
                            var22_26 = th$iv$iv;
                            $this$catch_u24lambda_u2d1$iv = $this$internalCatch_u24default$iv$iv;
                            $i$a$-internalCatch$default-KLoggerExKt$catch$2$iv = false;
                            this_$iv$iv = $this$catch_u24lambda_u2d1$iv;
                            $i$f$error = false;
                            if (this_$iv$iv.isErrorEnabled()) {
                                var28_31 = th$iv;
                                var27_32 = this_$iv$iv;
                                $i$a$-catch-WebSocketTransport$3$1 = false;
                                var29_33 = "error in web socket message handing";
                                var27_32.error((Throwable)var28_31, var29_33);
                            }
                            var14_17 = null;
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                Function2<Packet, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value2;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull Packet p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 4, null);
    }

    public /* synthetic */ WebSocketTransport(Lifetime lifetime, StableConnection stableConnection, TimeService timeService, ExtendableSerializationRegistry extendableSerializationRegistry, Metrics metrics, ActionCookies actionCookies, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            extendableSerializationRegistry = ExtendableSerializationRegistry.Companion.getGlobal();
        }
        if ((n & 0x10) != 0) {
            metrics = null;
        }
        if ((n & 0x20) != 0) {
            actionCookies = null;
        }
        this(lifetime, stableConnection, timeService, extendableSerializationRegistry, metrics, actionCookies);
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final StableConnection getConnection() {
        return this.connection;
    }

    @Nullable
    public final Metrics getMetrics() {
        return this.metrics;
    }

    @Nullable
    public final ActionCookies getActionCookies() {
        return this.actionCookies;
    }

    @Override
    @NotNull
    public Property<ConnectionStatus> getConnectionStatus() {
        return this.connection.getStatus();
    }

    @Override
    public int getConnectionGeneration() {
        return this.generation.getValue();
    }

    @Nullable
    public final String getLogReceivedMessagesAs() {
        return this.logReceivedMessagesAs;
    }

    public final void setLogReceivedMessagesAs(@Nullable String string2) {
        this.logReceivedMessagesAs = string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apiVersion(@NotNull String service, @NotNull String version) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        WebSocketTransport this_$iv = this;
        boolean $i$f$lock = false;
        Sync sync = Sync.INSTANCE;
        Object lock$iv$iv = this_$iv.sync;
        boolean $i$f$exec = false;
        synchronized (lock$iv$iv) {
            boolean bl2 = false;
            boolean bl3 = false;
            bl = this.apiVersions.put(service, version) == null;
        }
        boolean newApi = bl;
        if (newApi) {
            this.sendApiVersions(MapsKt.mapOf((Pair)TuplesKt.to((Object)service, (Object)version)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void handlePushes(@NotNull String path2, @NotNull Lifetime lifetime, @NotNull Function1<? super Packet, ? extends T> parser, @NotNull Function2<? super runtime.reactive.Result<? extends T>, ? super Continuation<? super Unit>, ? extends Object> handler) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(parser, (String)"parser");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        WebSocketTransport this_$iv = this;
        boolean $i$f$lock = false;
        Sync sync = Sync.INSTANCE;
        Object lock$iv$iv = this_$iv.sync;
        boolean $i$f$exec = false;
        synchronized (lock$iv$iv) {
            boolean bl = false;
            boolean bl2 = false;
            Map map2 = this.pushHandlers;
            PushHandler<? extends T> pushHandler = new PushHandler<T>(parser, handler);
            map2.put(path2, pushHandler);
            Unit unit = Unit.INSTANCE;
        }
        lifetime.add((Function0<Unit>)((Function0)new Function0<Unit>(this, path2){
            final /* synthetic */ WebSocketTransport this$0;
            final /* synthetic */ String $path;
            {
                this.this$0 = $receiver;
                this.$path = $path;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke() {
                void this_$iv;
                WebSocketTransport webSocketTransport = this.this$0;
                WebSocketTransport webSocketTransport2 = this.this$0;
                String string2 = this.$path;
                boolean $i$f$lock = false;
                Sync sync = Sync.INSTANCE;
                Object lock$iv$iv = WebSocketTransport.access$getSync$p((WebSocketTransport)this_$iv);
                boolean $i$f$exec = false;
                synchronized (lock$iv$iv) {
                    boolean bl = false;
                    boolean bl2 = false;
                    WebSocketTransport.access$getPushHandlers$p(webSocketTransport2).remove(string2);
                    WebSocketTransport.access$getDeadHandlers$p(webSocketTransport2).add(string2);
                    Unit unit = Unit.INSTANCE;
                }
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handlePushesEnded(@NotNull String path2, @NotNull Lifetime lifetime, @NotNull Function0<Unit> handler) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        Lifetime $this$inContext$iv = lifetime;
        boolean $i$f$inContext = false;
        if (!$this$inContext$iv.isTerminated()) {
            LifetimeContext $this$handlePushesEnded_u24lambda_u2d3 = new LifetimeContext($this$inContext$iv);
            boolean bl = false;
            WebSocketTransport this_$iv = this;
            boolean $i$f$lock = false;
            Sync sync = Sync.INSTANCE;
            Object lock$iv$iv = this_$iv.sync;
            boolean $i$f$exec = false;
            synchronized (lock$iv$iv) {
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = this.pushEndedHandlers.add(handler);
            }
            $this$handlePushesEnded_u24lambda_u2d3.afterTermination((Function0<Unit>)((Function0)new Function0<Unit>(this, handler){
                final /* synthetic */ WebSocketTransport this$0;
                final /* synthetic */ Function0<Unit> $handler;
                {
                    this.this$0 = $receiver;
                    this.$handler = $handler;
                    super(0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void this_$iv;
                    WebSocketTransport webSocketTransport = this.this$0;
                    WebSocketTransport webSocketTransport2 = this.this$0;
                    Function0<Unit> function0 = this.$handler;
                    boolean $i$f$lock = false;
                    Sync sync = Sync.INSTANCE;
                    Object lock$iv$iv = WebSocketTransport.access$getSync$p((WebSocketTransport)this_$iv);
                    boolean $i$f$exec = false;
                    synchronized (lock$iv$iv) {
                        boolean bl = false;
                        boolean bl2 = false;
                        WebSocketTransport.access$getPushEndedHandlers$p(webSocketTransport2).remove(function0);
                        Unit unit = Unit.INSTANCE;
                    }
                }
            }));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    @Nullable
    public <T> Object rpc(@NotNull String var1_1, @NotNull JsonElement var2_2, @Nullable PacketMeta var3_3, @Nullable Integer var4_4, @NotNull Function1<? super Packet, ? extends T> var5_5, @NotNull Continuation<? super RpcResponse<T>> var6_6) {
        if (!(var6_6 instanceof rpc.1)) ** GOTO lbl-1000
        var31_7 = var6_6;
        if ((var31_7.label & -2147483648) != 0) {
            var31_7.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var6_6){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ WebSocketTransport this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.rpc(null, null, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var32_9 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                id = this.nextId.getAndIncrement();
                $i$f$suspendCancellableCoroutine = false;
                $continuation.L$0 = this;
                $continuation.L$1 = path;
                $continuation.L$2 = payload;
                $continuation.L$3 = meta;
                $continuation.L$4 = timeout;
                $continuation.L$5 = parser;
                $continuation.I$0 = id;
                $continuation.label = 1;
                uCont$iv = $continuation;
                $i$a$-suspendCoroutineUninterceptedOrReturn-CancellableContinuationKt$suspendCancellableCoroutine$2$iv = false;
                cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
                cancellable$iv.initCancellability();
                callback = (CancellableContinuation)cancellable$iv;
                $i$a$-suspendCancellableCoroutine-WebSocketTransport$rpc$2 = false;
                if (this.getConnection().getStatus().getValue() instanceof ConnectionStatus.AuthFailed) {
                    ((Continuation)callback).resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new RpcException(new FailureInfo("Authentication failed", null, null, null, null, null, 62, null), (String)path))));
                } else {
                    v0 = timeout;
                    realTimeout = v0 == null ? 60000 : v0.intValue();
                    now = WebSocketTransport.access$getTimeService$p(this).now();
                    timer = WebSocketTransport.access$getTimeService$p(this).launchAfterDelay(this.getLifetime(), DispatchJvmKt.getUi(), realTimeout, (Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(this, callback, realTimeout, id, null){
                        int label;
                        final /* synthetic */ WebSocketTransport this$0;
                        final /* synthetic */ CancellableContinuation<RpcResponse<T>> $callback;
                        final /* synthetic */ int $realTimeout;
                        final /* synthetic */ int $id;
                        {
                            this.this$0 = $receiver;
                            this.$callback = $callback;
                            this.$realTimeout = $realTimeout;
                            this.$id = $id;
                            super(1, $completion);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * WARNING - void declaration
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    RpcRequest rpcRequest;
                                    void this_$iv;
                                    ResultKt.throwOnFailure((Object)object);
                                    WebSocketTransport webSocketTransport = this.this$0;
                                    WebSocketTransport webSocketTransport2 = this.this$0;
                                    int n = this.$id;
                                    boolean $i$f$lock = false;
                                    Object lock$iv$iv = WebSocketTransport.access$getSync$p((WebSocketTransport)this_$iv);
                                    boolean $i$f$exec = false;
                                    synchronized (lock$iv$iv) {
                                        boolean bl = false;
                                        boolean bl2 = false;
                                        rpcRequest = (RpcRequest)WebSocketTransport.access$getOutgoingRpc$p(webSocketTransport2).remove(Boxing.boxInt((int)n));
                                    }
                                    RpcRequest removed = rpcRequest;
                                    if (removed != null && !this.this$0.getLifetime().isTerminated()) {
                                        void var2_12;
                                        ((Continuation)this.$callback).resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new RpcTimeoutException("Request to " + var2_12.getPacket().getPath() + " has timed out after " + this.$realTimeout + "ms"))));
                                    }
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                            return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                        }
                    }));
                    v1 = this.getMetrics();
                    if (v1 == null) {
                        v2 /* !! */  = null;
                    } else {
                        v3 = v1.getSession();
                        v2 /* !! */  = v3 == null ? null : v3.currentSessionId();
                    }
                    v4 = this.getActionCookies();
                    packet = new Packet(id, (String)path, (JsonElement)payload, v2 /* !! */ , (String)(v4 == null ? null : v4.currentUid()), null, null, null, (PacketMeta)meta, null, null, 1760, null);
                    request = new RpcRequest<T>(packet, (Continuation)callback, timer, realTimeout, now + (long)realTimeout, parser);
                    this_$iv = this;
                    $i$f$lock = false;
                    lock$iv$iv = WebSocketTransport.access$getSync$p(this_$iv);
                    $i$f$exec = false;
                    synchronized (lock$iv$iv) {
                        $i$a$-exec-WebSocketTransport$lock$1$iv = false;
                        $i$a$-lock-WebSocketTransport$rpc$2$1 = false;
                        var27_37 = WebSocketTransport.access$getOutgoingRpc$p(this);
                        var28_38 = Boxing.boxInt((int)id);
                        var27_37.put(var28_38, request);
                        var29_39 = Unit.INSTANCE;
                    }
                    WebSocketTransport.access$post(this, packet);
                }
                v5 = cancellable$iv.getResult();
                if (v5 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    DebugProbesKt.probeCoroutineSuspended($continuation);
                }
                v6 = v5;
                if (v5 == var32_9) {
                    return var32_9;
                }
                ** GOTO lbl94
            }
            case 1: {
                $i$f$suspendCancellableCoroutine = false;
                id = $continuation.I$0;
                (Function1)$continuation.L$5;
                (Integer)$continuation.L$4;
                (PacketMeta)$continuation.L$3;
                (JsonElement)$continuation.L$2;
                (String)$continuation.L$1;
                this = (WebSocketTransport)$continuation.L$0;
                {
                    ResultKt.throwOnFailure((Object)$result);
                    v6 = $result;
lbl94:
                    // 2 sources

                    var8_12 = (RpcResponse)v6;
                    ** GOTO lbl112
                }
            }
            {
                finally {
                    this_$iv = this;
                    $i$f$lock = false;
                    lock$iv$iv = WebSocketTransport.access$getSync$p(this_$iv);
                    $i$f$exec = false;
                    synchronized (lock$iv$iv) {
                        $i$a$-exec-WebSocketTransport$lock$1$iv = false;
                        $i$a$-lock-WebSocketTransport$rpc$3 = false;
                        var17_43 = (RpcRequest)WebSocketTransport.access$getOutgoingRpc$p(this).remove(Boxing.boxInt((int)id));
                    }
                }
            }
lbl112:
            // 1 sources

            return var8_12;
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Object onMessage(Packet var1_1, Continuation<? super Unit> var2_2) {
        block70: {
            block68: {
                block69: {
                    block67: {
                        if (!(var2_2 instanceof onMessage.1)) ** GOTO lbl-1000
                        var18_3 = var2_2;
                        if ((var18_3.label & -2147483648) != 0) {
                            var18_3.label -= -2147483648;
                        } else lbl-1000:
                        // 2 sources

                        {
                            $continuation = new ContinuationImpl(this, var2_2){
                                Object L$0;
                                Object L$1;
                                Object L$2;
                                int I$0;
                                int I$1;
                                /* synthetic */ Object result;
                                final /* synthetic */ WebSocketTransport this$0;
                                int label;
                                {
                                    this.this$0 = this$0;
                                    super($completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object $result) {
                                    this.result = $result;
                                    this.label |= Integer.MIN_VALUE;
                                    return WebSocketTransport.access$onMessage(this.this$0, null, (Continuation)this);
                                }
                            };
                        }
                        $result = $continuation.result;
                        var19_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch ($continuation.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = packet.getMeta();
                                if (v0 != null) ** GOTO lbl16
                                v1 = null;
                                break block67;
lbl16:
                                // 1 sources

                                v2 = v0.getExtensionClasses();
                                if (v2 != null) ** GOTO lbl20
                                v1 = null;
                                break block67;
lbl20:
                                // 1 sources

                                $this$forEach$iv = v2;
                                $i$f$forEach = false;
                                var7_19 = $this$forEach$iv;
                                var8_24 = 0;
                                var9_28 = var7_19.length;
lbl25:
                                // 3 sources

                                while (var8_24 < var9_28) {
                                    element$iv = var7_19[var8_24];
                                    it = element$iv;
                                    $i$a$-forEach-WebSocketTransport$onMessage$2 = false;
                                    $continuation.L$0 = this;
                                    $continuation.L$1 = packet;
                                    $continuation.L$2 = var7_19;
                                    $continuation.I$0 = ++var8_24;
                                    $continuation.I$1 = var9_28;
                                    $continuation.label = 1;
                                    v3 = this.registry.loadDeserializer((String)it, (Continuation<? super Unit>)$continuation);
                                    if (v3 != var19_5) continue;
                                    return var19_5;
                                }
                                break;
                            }
                            case 1: {
                                $i$f$forEach = false;
                                $i$a$-forEach-WebSocketTransport$onMessage$2 = false;
                                var9_28 = $continuation.I$1;
                                var8_24 = $continuation.I$0;
                                var7_19 = (String[])$continuation.L$2;
                                packet = (Packet)$continuation.L$1;
                                this = (WebSocketTransport)$continuation.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v3 = $result;
                                ** GOTO lbl25
                            }
                        }
                        v1 = Unit.INSTANCE;
                    }
                    failure = packet.getFailure();
                    if (failure == null) break block68;
                    if (failure.getTransportError() != null) {
                        WebSocketTransportKt.access$getLog$p().debug("Push " + packet.getPath() + " failed and will be resent with backoff: " + RpcExceptionKt.message(failure));
                        this_$iv = this;
                        $i$f$lock = false;
                        lock$iv$iv = WebSocketTransport.access$getSync$p(this_$iv);
                        $i$f$exec = false;
                        synchronized (lock$iv$iv) {
                            $i$a$-exec-WebSocketTransport$lock$1$iv = false;
                            $i$a$-lock-WebSocketTransport$onMessage$3 = false;
                            it = WebSocketTransport.access$getBackOffProcess$p(this);
                            if (it == null) {
                                created = var12_43 = new BackOffProcess();
                                $i$a$-also-WebSocketTransport$onMessage$3$1 = false;
                                WebSocketTransport.access$setBackOffProcess$p(this, created);
                                v4 = var12_43;
                            } else {
                                v4 = it;
                            }
                            var15_56 /* !! */  = v4;
                        }
                    }
                    if (packet.getId() == 0) {
                        if (failure.getAuthenticationError() != null) {
                            this_$iv = "Should be handled earlier and synchronously when message is just received";
                            throw new IllegalStateException(this_$iv.toString());
                        }
                        WebSocketTransportKt.access$getLog$p().error("Push " + packet.getPath() + " failed: " + RpcExceptionKt.message(failure));
                        this_$iv = this;
                        $i$f$lock = false;
                        lock$iv$iv = WebSocketTransport.access$getSync$p(this_$iv);
                        $i$f$exec = false;
                        synchronized (lock$iv$iv) {
                            $i$a$-exec-WebSocketTransport$lock$1$iv = false;
                            $i$a$-lock-WebSocketTransport$onMessage$4 = false;
                            WebSocketTransport.access$getPushHandlers$p(this).remove(packet.getPath());
                            it = WebSocketTransport.access$getDeadHandlers$p(this).add(packet.getPath());
                        }
                    }
                    this_$iv = this;
                    $i$f$lock = false;
                    lock$iv$iv = WebSocketTransport.access$getSync$p((WebSocketTransport)this_$iv);
                    $i$f$exec = false;
                    synchronized (lock$iv$iv) {
                        $i$a$-exec-WebSocketTransport$lock$1$iv = false;
                        $i$a$-lock-WebSocketTransport$onMessage$rpc$1 = false;
                        var12_44 = (RpcRequest)WebSocketTransport.access$getOutgoingRpc$p(this).remove(Boxing.boxInt((int)packet.getId()));
                    }
                    rpc = var12_44;
                    if (rpc != null) break block69;
                    this_$iv = WebSocketTransportKt.access$getLog$p();
                    $i$f$warn = false;
                    if (this_$iv.isWarnEnabled()) {
                        var16_59 = this_$iv;
                        $i$a$-warn-WebSocketTransport$onMessage$5 = false;
                        var16_59.warn("no handler with id = " + packet.getId() + " found");
                    }
                    break block70;
                }
                v5 = rpc.getTimer();
                if (v5 == null) {
                    v6 = null;
                } else {
                    Job.DefaultImpls.cancel$default((Job)v5, null, (int)1, null);
                    v6 = Unit.INSTANCE;
                }
                this_$iv = failure.getRequestError();
                if (this_$iv == null) ** GOTO lbl-1000
                tmp = -1;
                switch (this_$iv.hashCode()) {
                    case -771078535: {
                        if (this_$iv.equals("Too many requests")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 1914718620: {
                        if (this_$iv.equals("Request execution cancelled on server")) {
                            tmp = 2;
                        }
                        break;
                    }
                    case 1782696108: {
                        if (this_$iv.equals("Request execution timed out")) {
                            tmp = 3;
                        }
                        break;
                    }
                }
                switch (tmp) {
                    case 3: {
                        $i$f$warn = rpc.getCallback();
                        $i$a$-warn-WebSocketTransport$onMessage$5 = new RpcTimeoutException("Request to " + rpc.getPacket().getPath() + " has timed out from server side");
                        $i$f$warn.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-warn-WebSocketTransport$onMessage$5)));
                        break;
                    }
                    case 2: {
                        $i$f$warn = rpc.getCallback();
                        $i$a$-warn-WebSocketTransport$onMessage$5 = new RpcServerCancellationException("Request to " + rpc.getPacket().getPath() + " was cancelled on server side");
                        $i$f$warn.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-warn-WebSocketTransport$onMessage$5)));
                        break;
                    }
                    case 1: {
                        $i$f$warn = rpc.getCallback();
                        $i$a$-warn-WebSocketTransport$onMessage$5 = new RpcServerRateLimitedException("Request to " + rpc.getPacket().getPath() + " was rate limited on server side");
                        $i$f$warn.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-warn-WebSocketTransport$onMessage$5)));
                        break;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        $i$f$warn = rpc.getCallback();
                        $i$a$-warn-WebSocketTransport$onMessage$5 = new RpcException(failure, rpc.getPacket().getPath());
                        $i$f$warn.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-warn-WebSocketTransport$onMessage$5)));
                        break;
                    }
                }
                break block70;
            }
            if (packet.getId() != 0 || Intrinsics.areEqual((Object)packet.getPath(), (Object)"")) ** GOTO lbl224
            this_$iv = this;
            $i$f$lock = false;
            lock$iv$iv = WebSocketTransport.access$getSync$p((WebSocketTransport)this_$iv);
            $i$f$exec = false;
            synchronized (lock$iv$iv) {
                $i$a$-exec-WebSocketTransport$lock$1$iv = false;
                $i$a$-lock-WebSocketTransport$onMessage$pushHandler$1 = false;
                var12_46 = (PushHandler)WebSocketTransport.access$getPushHandlers$p(this).get(packet.getPath());
            }
            pushHandler = var12_46;
            if (pushHandler != null) {
                try {
                    $i$f$lock = new Result.Success<Object>(pushHandler.getParser().invoke((Object)packet));
                }
                catch (Throwable e) {
                    $i$f$lock = new Result.Failure(new RpcDeserializerException(e, packet.getPath()));
                }
                result = $i$f$lock;
                CoroutineBuildersCommonKt.launch$default(this.getLifetime(), DispatchJvmKt.getUi(), null, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((PushHandler<Object>)pushHandler, (runtime.reactive.Result<? extends Object>)result, null){
                    int label;
                    final /* synthetic */ PushHandler<Object> $pushHandler;
                    final /* synthetic */ runtime.reactive.Result<Object> $result;
                    {
                        this.$pushHandler = $pushHandler;
                        this.$result = $result;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = this.$pushHandler.getHandler().invoke(this.$result, (Object)((Object)this));
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, 12, null);
            } else {
                this_$iv = this;
                $i$f$lock = false;
                lock$iv$iv = WebSocketTransport.access$getSync$p((WebSocketTransport)this_$iv);
                $i$f$exec = false;
                synchronized (lock$iv$iv) {
                    $i$a$-exec-WebSocketTransport$lock$1$iv = false;
                    $i$a$-lock-WebSocketTransport$onMessage$7 = false;
                    if (!WebSocketTransport.access$getDeadHandlers$p(this).contains(packet.getPath())) {
                        throw new IllegalStateException(("Payload " + packet.getPath() + ':' + packet.getPayload() + " for unknown handler").toString());
                    }
                    WebSocketTransportKt.access$getLog$p().warn("Payload " + packet.getPath() + ':' + packet.getPayload() + " for dead handler");
                    var12_46 = Unit.INSTANCE;
                }
lbl224:
                // 1 sources

                if (packet.getId() != 0 && Intrinsics.areEqual((Object)packet.getPath(), (Object)"")) {
                    this_$iv = this;
                    $i$f$lock = false;
                    lock$iv$iv = WebSocketTransport.access$getSync$p((WebSocketTransport)this_$iv);
                    $i$f$exec = false;
                    synchronized (lock$iv$iv) {
                        $i$a$-exec-WebSocketTransport$lock$1$iv = false;
                        $i$a$-lock-WebSocketTransport$onMessage$rpc$2 = false;
                        var12_49 = (RpcRequest)WebSocketTransport.access$getOutgoingRpc$p(this).remove(Boxing.boxInt((int)packet.getId()));
                    }
                    rpc = var12_49;
                    if (rpc == null) {
                        this_$iv = WebSocketTransportKt.access$getLog$p();
                        $i$f$warn = false;
                        if (this_$iv.isWarnEnabled()) {
                            var16_60 = this_$iv;
                            $i$a$-warn-WebSocketTransport$onMessage$8 = false;
                            var16_60.warn("no handler with id = " + packet.getId() + " found");
                        }
                    } else {
                        v7 = rpc.getTimer();
                        if (v7 == null) {
                            v8 = null;
                        } else {
                            Job.DefaultImpls.cancel$default((Job)v7, null, (int)1, null);
                            v8 = Unit.INSTANCE;
                        }
                        try {
                            value = rpc.getParser().invoke((Object)packet);
                            var6_17 = rpc.getCallback();
                            $i$a$-warn-WebSocketTransport$onMessage$8 = new RpcResponse<Object>(value, packet.getStats(), packet.getUpdates(), packet.getPayload());
                            var6_17.resumeWith(Result.constructor-impl((Object)$i$a$-warn-WebSocketTransport$onMessage$8));
                        }
                        catch (Throwable e) {
                            var6_18 = rpc.getCallback();
                            $i$a$-warn-WebSocketTransport$onMessage$8 = new RpcDeserializerException(e, Intrinsics.stringPlus((String)"rpc: ", (Object)rpc.getPacket().getPath()));
                            var6_18.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-warn-WebSocketTransport$onMessage$8)));
                        }
                    }
                }
            }
        }
        if (failure == null) {
            this_$iv = this;
            $i$f$lock = false;
            lock$iv$iv = WebSocketTransport.access$getSync$p(this_$iv);
            $i$f$exec = false;
            synchronized (lock$iv$iv) {
                $i$a$-exec-WebSocketTransport$lock$1$iv = false;
                $i$a$-lock-WebSocketTransport$onMessage$9 = false;
                v9 = WebSocketTransport.access$getBackOffProcess$p(this);
                if (v9 == null) {
                    v10 = null;
                } else {
                    it = v9;
                    $i$a$-let-WebSocketTransport$onMessage$9$1 = false;
                    if (WebSocketTransport.access$getOutgoingRpc$p(this).isEmpty()) {
                        it.terminate();
                        WebSocketTransport.access$setBackOffProcess$p(this, null);
                    } else {
                        it.reset();
                    }
                    v10 = Unit.INSTANCE;
                }
                var15_56 /* !! */  = v10;
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onConnectionCreated() {
        Collection collection;
        Pair pair;
        WebSocketTransport this_$iv = this;
        boolean $i$f$lock = false;
        Sync sync = Sync.INSTANCE;
        Object lock$iv$iv = this_$iv.sync;
        boolean $i$f$exec22 = false;
        synchronized (lock$iv$iv) {
            boolean bl = false;
            boolean bl2 = false;
            HashMap hashMap = new HashMap(this.apiVersions);
            Collection collection2 = this.outgoingRpc.values();
            Intrinsics.checkNotNullExpressionValue(collection2, (String)"outgoingRpc.values");
            pair = TuplesKt.to(hashMap, (Object)CollectionsKt.toList((Iterable)collection2));
        }
        Pair pair2 = pair;
        HashMap versions2 = (HashMap)pair2.component1();
        List requests2 = (List)pair2.component2();
        this.sendApiVersions(versions2);
        Iterable $this$forEach$iv = requests2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RpcRequest rpc2 = (RpcRequest)element$iv;
            boolean bl = false;
            this.post(rpc2.getPacket());
        }
        Object this_$iv2 = this;
        boolean $i$f$lock2 = false;
        Sync $i$f$exec22 = Sync.INSTANCE;
        Object lock$iv$iv2 = ((WebSocketTransport)this_$iv2).sync;
        boolean $i$f$exec = false;
        synchronized (lock$iv$iv2) {
            boolean bl = false;
            boolean bl3 = false;
            collection = runtime.utils.CollectionsKt.getAndClear(this.pushEndedHandlers);
        }
        this_$iv2 = collection;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 it = (Function0)element$iv;
            boolean bl = false;
            it.invoke();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onConnectionAuthFail(String message2) {
        Map map2;
        WebSocketTransport this_$iv = this;
        boolean $i$f$lock = false;
        Object object = Sync.INSTANCE;
        Object lock$iv$iv = this_$iv.sync;
        boolean $i$f$exec = false;
        synchronized (lock$iv$iv) {
            boolean bl = false;
            boolean bl2 = false;
            map2 = runtime.utils.CollectionsKt.getAndClear(this.outgoingRpc);
        }
        Map $this$forEach$iv = map2;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = (Map.Entry)object.next();
            boolean bl = false;
            Job job = ((RpcRequest)it.getValue()).getTimer();
            if (job != null) {
                Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
            }
            ((RpcRequest)it.getValue()).getCallback().resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new RpcException(new FailureInfo(message2, null, null, null, null, null, 62, null), ((RpcRequest)it.getValue()).getPacket().getPath()))));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void sendApiVersions(Map<String, String> versions2) {
        boolean $i$f$jsonObjectNode = false;
        Object baseObj$iv$iv = null;
        boolean $i$f$objectNode = false;
        JsonNodeFactory factory$iv$iv = new JsonNodeFactory(false);
        ObjectNode rootNode$iv$iv = factory$iv$iv.objectNode();
        Intrinsics.checkNotNullExpressionValue((Object)rootNode$iv$iv, (String)"rootNode");
        JsonBuilderContext jsonBuilderContext = new JsonBuilderContext(rootNode$iv$iv, factory$iv$iv, JsonDslKt.getJackson());
        String string2 = "apiVersion";
        int n = 0;
        WebSocketTransport webSocketTransport = this;
        boolean bl = false;
        Map<String, String> $this$forEach$iv = versions2;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $this$sendApiVersions_u24lambda_u2d26;
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> $dstr$key$value = element$iv = iterator2.next();
            boolean bl2 = false;
            String key2 = $dstr$key$value.getKey();
            String value2 = $dstr$key$value.getValue();
            $this$sendApiVersions_u24lambda_u2d26.put(key2, value2);
        }
        Unit unit = Unit.INSTANCE;
        ObjectNode objectNode = rootNode$iv$iv;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n2 = 2040;
        Long l = null;
        ArenaResponse.Update[] updateArray = null;
        PacketMeta packetMeta = null;
        Long l2 = null;
        ServerStats serverStats = null;
        FailureInfo failureInfo = null;
        String string3 = null;
        String string4 = null;
        JsonElement jsonElement = new JsonObjectWrapper(objectNode);
        String string5 = string2;
        int n3 = n;
        webSocketTransport.post(new Packet(n3, string5, jsonElement, string4, string3, failureInfo, serverStats, l2, packetMeta, updateArray, l, n2, defaultConstructorMarker));
    }

    private final void post(Packet packet) {
        boolean $i$f$jsonObjectNode = false;
        Object baseObj$iv$iv = null;
        boolean $i$f$objectNode = false;
        JsonNodeFactory factory$iv$iv = new JsonNodeFactory(false);
        ObjectNode rootNode$iv$iv = factory$iv$iv.objectNode();
        Intrinsics.checkNotNullExpressionValue((Object)rootNode$iv$iv, (String)"rootNode");
        JsonBuilderContext $this$post_u24lambda_u2d27 = new JsonBuilderContext(rootNode$iv$iv, factory$iv$iv, JsonDslKt.getJackson());
        boolean bl = false;
        ParserFunctionsKt.jsonify_Packet(packet, $this$post_u24lambda_u2d27, this.registry);
        ObjectNode objectNode = rootNode$iv$iv;
        JsonObject packetJson = new JsonObjectWrapper(objectNode);
        this.connection.postJson(packetJson);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T lock(Function0<? extends T> inner) {
        boolean $i$f$lock = false;
        Sync sync = Sync.INSTANCE;
        Object lock$iv = this.sync;
        boolean $i$f$exec = false;
        synchronized (lock$iv) {
            Object object;
            try {
                boolean bl = false;
                object = inner.invoke();
            }
            finally {
                InlineMarker.finallyStart((int)1);
                // MONITOREXIT @DISABLED, blocks:[1, 3] lbl13 : MonitorExitStatement: MONITOREXIT : lock$iv
                InlineMarker.finallyEnd((int)1);
            }
            return (T)object;
        }
    }

    private final String debugPrint(Packet $this$debugPrint) {
        String string2;
        StringBuilder stringBuilder = new StringBuilder().append("Packet(id=").append($this$debugPrint.getId()).append(", path='").append($this$debugPrint.getPath()).append("', payload=").append(JsonDslKt.text($this$debugPrint.getPayload())).append(", failure=").append($this$debugPrint.getFailure()).append(", stats=").append($this$debugPrint.getStats()).append(", limitsTokensRemaining=").append($this$debugPrint.getLimitsTokensRemaining()).append(", meta=").append($this$debugPrint.getMeta()).append(", updates=");
        Object[] objectArray = $this$debugPrint.getUpdates();
        if (objectArray == null) {
            string2 = null;
        } else {
            String string3 = Arrays.toString(objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(this)");
            string2 = string3;
        }
        return stringBuilder.append((Object)string2).append(')').toString();
    }

    public static final /* synthetic */ Set access$getDeadHandlers$p(WebSocketTransport $this) {
        return $this.deadHandlers;
    }

    public static final /* synthetic */ Object access$onMessage(WebSocketTransport $this, Packet packet, Continuation $completion) {
        return $this.onMessage(packet, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ TimeService access$getTimeService$p(WebSocketTransport $this) {
        return $this.timeService;
    }

    public static final /* synthetic */ void access$setBackOffProcess$p(WebSocketTransport $this, BackOffProcess backOffProcess) {
        $this.backOffProcess = backOffProcess;
    }

    public static final /* synthetic */ void access$post(WebSocketTransport $this, Packet packet) {
        $this.post(packet);
    }

    public static final /* synthetic */ BackOffProcess access$getBackOffProcess$p(WebSocketTransport $this) {
        return $this.backOffProcess;
    }

    public static final /* synthetic */ String access$debugPrint(WebSocketTransport $this, Packet $receiver) {
        return $this.debugPrint($receiver);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u00020\fH\u0002J\u0006\u0010\u000e\u001a\u00020\fR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcirclet/platform/client/WebSocketTransport$BackOffProcess;", "", "(Lcirclet/platform/client/WebSocketTransport;)V", "delay", "", "getDelay", "()I", "setDelay", "(I)V", "lifetime", "Llibraries/coroutines/extra/LifetimeSource;", "reset", "", "start", "terminate", "platform-client"})
    private final class BackOffProcess {
        @NotNull
        private LifetimeSource lifetime;
        private int delay;

        public BackOffProcess() {
            Intrinsics.checkNotNullParameter((Object)WebSocketTransport.this, (String)"this$0");
            this.lifetime = LifetimeUtilsKt.nested(WebSocketTransport.this.getLifetime());
            this.delay = 5000;
            this.start();
        }

        public final int getDelay() {
            return this.delay;
        }

        public final void setDelay(int n) {
            this.delay = n;
        }

        /*
         * WARNING - void declaration
         */
        public final void reset() {
            if (WebSocketTransport.this.getLogReceivedMessagesAs() != null) {
                void this_$iv;
                KLogger kLogger = WebSocketTransportKt.access$getLog$p();
                WebSocketTransport webSocketTransport = WebSocketTransport.this;
                boolean $i$f$info = false;
                if (this_$iv.isInfoEnabled()) {
                    void var5_4 = this_$iv;
                    boolean bl = false;
                    var5_4.info(Intrinsics.stringPlus((String)webSocketTransport.getLogReceivedMessagesAs(), (Object)" back off: restart"));
                }
            }
            this.lifetime.terminate();
            this.lifetime = LifetimeUtilsKt.nested(WebSocketTransport.this.getLifetime());
            this.start();
        }

        /*
         * WARNING - void declaration
         */
        public final void terminate() {
            if (WebSocketTransport.this.getLogReceivedMessagesAs() != null) {
                void this_$iv;
                KLogger kLogger = WebSocketTransportKt.access$getLog$p();
                WebSocketTransport webSocketTransport = WebSocketTransport.this;
                boolean $i$f$info = false;
                if (this_$iv.isInfoEnabled()) {
                    void var5_4 = this_$iv;
                    boolean bl = false;
                    var5_4.info(Intrinsics.stringPlus((String)webSocketTransport.getLogReceivedMessagesAs(), (Object)" back off: terminate"));
                }
            }
            this.lifetime.terminate();
        }

        private final void start() {
            CoroutineBuildersCommonKt.launch$default(this.lifetime, DispatchJvmKt.getUi(), null, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, WebSocketTransport.this, null){
                Object L$0;
                int label;
                final /* synthetic */ BackOffProcess this$0;
                final /* synthetic */ WebSocketTransport this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var24_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    block6 : switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
lbl5:
                            // 2 sources

                            while (!BackOffProcess.access$getLifetime$p(this.this$0).isTerminated()) {
                                now = WebSocketTransport.access$getTimeService$p(this.this$1).now();
                                var5_5 = this.this$1;
                                var6_6 = this.this$1;
                                $i$f$lock = false;
                                lock$iv$iv = WebSocketTransport.access$getSync$p((WebSocketTransport)this_$iv);
                                $i$f$exec = false;
                                synchronized (lock$iv$iv) {
                                    $i$a$-exec-WebSocketTransport$lock$1$iv = false;
                                    $i$a$-lock-WebSocketTransport$BackOffProcess$start$1$requests$1 = false;
                                    var13_19 = WebSocketTransport.access$getOutgoingRpc$p(var6_6).values();
                                    Intrinsics.checkNotNullExpressionValue(var13_19, (String)"outgoingRpc.values");
                                    $this$filter$iv = var13_19;
                                    $i$f$filter = false;
                                    var15_22 = $this$filter$iv;
                                    destination$iv$iv = new ArrayList<E>();
                                    $i$f$filterTo = false;
                                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                                        it = (RpcRequest)element$iv$iv;
                                        $i$a$-filter-WebSocketTransport$BackOffProcess$start$1$requests$1$1 = false;
                                        if (!(it.getDue() > now)) continue;
                                        destination$iv$iv.add(element$iv$iv);
                                    }
                                    var22_29 = (List)destination$iv$iv;
                                }
                                requests = var22_29;
                                if (requests.isEmpty()) {
                                    this_$iv = this.this$1;
                                    var6_6 = this.this$1;
                                    $i$f$lock = false;
                                    lock$iv$iv = WebSocketTransport.access$getSync$p((WebSocketTransport)this_$iv);
                                    $i$f$exec = false;
                                    synchronized (lock$iv$iv) {
                                        $i$a$-exec-WebSocketTransport$lock$1$iv = false;
                                        $i$a$-lock-WebSocketTransport$BackOffProcess$start$1$1 = false;
                                        WebSocketTransport.access$setBackOffProcess$p(var6_6, null);
                                        $this$filter$iv = Unit.INSTANCE;
                                        break block6;
                                    }
                                }
                                if (this.this$1.getLogReceivedMessagesAs() != null) {
                                    this_$iv = WebSocketTransportKt.access$getLog$p();
                                    var6_6 = this.this$1;
                                    $i$f$lock = this.this$0;
                                    $i$f$info = false;
                                    if (this_$iv.isInfoEnabled()) {
                                        var23_32 = this_$iv;
                                        $i$a$-info-WebSocketTransport$BackOffProcess$start$1$2 = false;
                                        var23_32.info(var6_6.getLogReceivedMessagesAs() + " back off: will repeat " + requests.size() + " requests after " + $i$f$lock.getDelay() + " milliseconds");
                                    }
                                }
                                this.L$0 = requests;
                                this.label = 1;
                                v0 = WebSocketTransport.access$getTimeService$p(this.this$1).delay(this.this$0.getDelay(), (Continuation<? super Unit>)((Continuation)this));
                                if (v0 == var24_2) {
                                    return var24_2;
                                }
                                ** GOTO lbl75
                            }
                            break;
                        }
                        case 1: {
                            requests = (List)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl75:
                            // 2 sources

                            this_$iv = this.this$1;
                            var6_6 = this.this$1;
                            $i$f$lock = false;
                            lock$iv$iv = WebSocketTransport.access$getSync$p((WebSocketTransport)this_$iv);
                            $i$f$exec = false;
                            synchronized (lock$iv$iv) {
                                $i$a$-exec-WebSocketTransport$lock$1$iv = false;
                                $i$a$-lock-WebSocketTransport$BackOffProcess$start$1$3 = false;
                                $this$filter$iv = requests;
                                $i$f$filter = false;
                                $this$filterTo$iv$iv = $this$filter$iv;
                                destination$iv$iv = new ArrayList<E>();
                                $i$f$filterTo = false;
                                for (T element$iv$iv : $this$filterTo$iv$iv) {
                                    it = (RpcRequest)element$iv$iv;
                                    $i$a$-filter-WebSocketTransport$BackOffProcess$start$1$3$1 = false;
                                    if (!WebSocketTransport.access$getOutgoingRpc$p(var6_6).containsKey(Boxing.boxInt((int)it.getPacket().getId()))) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                var22_29 = (List)destination$iv$iv;
                            }
                            $this$forEach$iv = var22_29;
                            var6_6 = this.this$1;
                            $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                rpc = (RpcRequest)element$iv;
                                $i$a$-forEach-WebSocketTransport$BackOffProcess$start$1$4 = false;
                                WebSocketTransport.access$post(var6_6, rpc.getPacket());
                            }
                            ** GOTO lbl5
                        }
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 12, null);
        }

        public static final /* synthetic */ LifetimeSource access$getLifetime$p(BackOffProcess $this) {
            return $this.lifetime;
        }
    }
}

