/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.gateway.rd.list;

import com.intellij.space.gateway.messages.SpaceGatewayBundle;
import com.intellij.space.gateway.rd.SpaceGatewayRdUiParams;
import com.intellij.space.gateway.rd.list.SpaceGatewayRdListFactory;
import com.intellij.space.gateway.rd.list.SpaceGatewayRdListWithFiltersVm;
import com.intellij.space.gateway.rd.list.SpaceGatewayRdManagingUiContext;
import com.intellij.space.ui.panel.SpaceComponentWrapper;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import libraries.coroutines.extra.Lifetime;
import org.jetbrains.annotations.NotNull;
import runtime.reactive.MutableProperty;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/space/gateway/rd/list/SpaceGatewayRdListWithFilterFactory;", "", "()V", "filterAndRdListGap", "", "create", "Ljavax/swing/JComponent;", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "listWithFiltersVm", "Lcom/intellij/space/gateway/rd/list/SpaceGatewayRdListWithFiltersVm;", "uiContext", "Lcom/intellij/space/gateway/rd/list/SpaceGatewayRdManagingUiContext;", "createFilterComponent", "createFilteredRdListComponent", "intellij.space.gateway"})
public final class SpaceGatewayRdListWithFilterFactory {
    private static final int filterAndRdListGap = 16;
    @NotNull
    public static final SpaceGatewayRdListWithFilterFactory INSTANCE;

    @NotNull
    public final JComponent create(@NotNull Lifetime lifetime, @NotNull SpaceGatewayRdListWithFiltersVm listWithFiltersVm, @NotNull SpaceGatewayRdManagingUiContext uiContext) {
        BorderLayoutPanel borderLayoutPanel;
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)listWithFiltersVm, (String)"listWithFiltersVm");
        Intrinsics.checkNotNullParameter((Object)uiContext, (String)"uiContext");
        JComponent filterComponent = this.createFilterComponent(listWithFiltersVm);
        JComponent rdList = this.createFilteredRdListComponent(lifetime, listWithFiltersVm, uiContext);
        BorderLayoutPanel $this$apply = borderLayoutPanel = new BorderLayoutPanel();
        boolean bl = false;
        $this$apply.setOpaque(false);
        $this$apply.addToTop((Component)filterComponent);
        $this$apply.addToCenter((Component)rdList);
        return (JComponent)borderLayoutPanel;
    }

    private final JComponent createFilterComponent(SpaceGatewayRdListWithFiltersVm listWithFiltersVm) {
        SearchTextField searchTextField2;
        SpaceComponentWrapper spaceComponentWrapper;
        SpaceComponentWrapper $this$apply = spaceComponentWrapper = new SpaceComponentWrapper(null, null, 3, null);
        boolean bl = false;
        $this$apply.setBorder(new CompoundBorder(IdeBorderFactory.createBorder((Color)SpaceGatewayRdUiParams.Colors.INSTANCE.getBorderColor(), (int)8), (Border)JBUI.Borders.empty((int)6, (int)24)));
        SpaceComponentWrapper filterComponent = spaceComponentWrapper;
        SearchTextField $this$apply2 = searchTextField2 = new SearchTextField(false);
        boolean bl2 = false;
        JBTextField jBTextField = $this$apply2.getTextEditor();
        Intrinsics.checkNotNullExpressionValue((Object)jBTextField, (String)"textEditor");
        StatusText statusText = jBTextField.getEmptyText();
        Intrinsics.checkNotNullExpressionValue((Object)statusText, (String)"textEditor.emptyText");
        statusText.setText(SpaceGatewayBundle.message("rd.list.search.empty.text", new Object[0]));
        JBTextField jBTextField2 = $this$apply2.getTextEditor();
        Intrinsics.checkNotNullExpressionValue((Object)jBTextField2, (String)"textEditor");
        jBTextField2.setBorder((Border)JBUI.Borders.empty());
        JBTextField jBTextField3 = $this$apply2.getTextEditor();
        Intrinsics.checkNotNullExpressionValue((Object)jBTextField3, (String)"textEditor");
        jBTextField3.setBackground(SpaceGatewayRdUiParams.Colors.INSTANCE.getBackgroundColor());
        $this$apply2.setFocusable(false);
        SearchTextField textFilterComponent = searchTextField2;
        textFilterComponent.addDocumentListener((DocumentListener)new DocumentAdapter(listWithFiltersVm, textFilterComponent){
            final /* synthetic */ SpaceGatewayRdListWithFiltersVm $listWithFiltersVm;
            final /* synthetic */ SearchTextField $textFilterComponent;

            protected void textChanged(@NotNull DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                MutableProperty<String> mutableProperty2 = this.$listWithFiltersVm.getTextFilter();
                String string2 = this.$textFilterComponent.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"textFilterComponent.text");
                mutableProperty2.setValue(string2);
            }
            {
                this.$listWithFiltersVm = $captured_local_variable$0;
                this.$textFilterComponent = $captured_local_variable$1;
            }
        });
        filterComponent.setContent((JComponent)textFilterComponent);
        return (JComponent)((Object)filterComponent);
    }

    private final JComponent createFilteredRdListComponent(Lifetime lifetime, SpaceGatewayRdListWithFiltersVm listWithFiltersVm, SpaceGatewayRdManagingUiContext uiContext) {
        SpaceComponentWrapper spaceComponentWrapper;
        SpaceComponentWrapper $this$apply = spaceComponentWrapper = new SpaceComponentWrapper(null, null, 3, null);
        boolean bl = false;
        $this$apply.setBorder((Border)JBUI.Borders.emptyTop((int)16));
        SpaceComponentWrapper component2 = spaceComponentWrapper;
        JComponent rdList = SpaceGatewayRdListFactory.INSTANCE.createDevEnvList(lifetime, listWithFiltersVm.getRdListVm(), uiContext);
        component2.setContent(rdList);
        return (JComponent)((Object)component2);
    }

    private SpaceGatewayRdListWithFilterFactory() {
    }

    static {
        SpaceGatewayRdListWithFilterFactory spaceGatewayRdListWithFilterFactory;
        INSTANCE = spaceGatewayRdListWithFilterFactory = new SpaceGatewayRdListWithFilterFactory();
    }
}

