/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.promo;

import com.intellij.util.JBHiDPIScaledImage;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import libraries.klogging.KLogger;
import libraries.klogging.KLoggers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/space/promo/ImageLoader;", "", "()V", "LOG", "Llibraries/klogging/KLogger;", "loadImage", "Ljava/awt/Image;", "path", "", "width", "", "height", "intellij.space"})
final class ImageLoader {
    private static final KLogger LOG;
    @NotNull
    public static final ImageLoader INSTANCE;

    @Nullable
    public final Image loadImage(@NotNull String path2, int width, int height) {
        Image image;
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        try {
            BufferedImage img = ImageIO.read(this.getClass().getResourceAsStream(path2));
            Image image2 = img;
            BufferedImage bufferedImage = img;
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"img");
            image = (Image)new JBHiDPIScaledImage(image2, width, height, bufferedImage.getType());
        }
        catch (Exception e) {
            KLogger this_$iv = LOG;
            boolean $i$f$error = false;
            if (this_$iv.isErrorEnabled()) {
                KLogger kLogger = this_$iv;
                boolean bl = false;
                String string2 = "Image " + path2 + " is not loaded";
                kLogger.error(string2);
            }
            image = null;
        }
        return image;
    }

    private ImageLoader() {
    }

    static {
        ImageLoader imageLoader;
        INSTANCE = imageLoader = new ImageLoader();
        ImageLoader $this$logger$iv = imageLoader;
        boolean $i$f$logger = false;
        LOG = KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(ImageLoader.class));
    }
}

