/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.kotlin.commonNative.debugger;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrDebuggerTypesHelper;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtReferenceExpression;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u001d\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\rH\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0006H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/kotlin/commonNative/debugger/KonanDebuggerTypesHelper;", "Lcom/jetbrains/cidr/execution/debugger/evaluation/CidrDebuggerTypesHelper;", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "(Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;)V", "dropInlinerSuffix", "", "receivedName", "isImplicitContextVariable", "", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "variable", "Lcom/jetbrains/cidr/execution/debugger/backend/LLValue;", "(Lcom/intellij/xdebugger/XSourcePosition;Lcom/jetbrains/cidr/execution/debugger/backend/LLValue;)Ljava/lang/Boolean;", "resolveToDeclaration", "Lcom/intellij/psi/PsiElement;", "value", "tryResolveToDeclaration", "blockExpression", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "variableName", "Companion", "kotlin-ultimate.common-native"})
public final class KonanDebuggerTypesHelper
extends CidrDebuggerTypesHelper {
    @NotNull
    public static final String KONAN_NAME_FOR_THIS = "_this";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Boolean isImplicitContextVariable(@NotNull XSourcePosition position, @NotNull LLValue variable2) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)variable2, (String)"variable");
        return Intrinsics.areEqual((Object)variable2.getName(), (Object)KONAN_NAME_FOR_THIS);
    }

    private final PsiElement tryResolveToDeclaration(KtBlockExpression blockExpression2, String variableName) {
        KtReferenceExpression referenceExpression;
        KtReferenceExpression ktReferenceExpression;
        CidrDebugProcess cidrDebugProcess = this.myProcess;
        Intrinsics.checkNotNullExpressionValue((Object)cidrDebugProcess, (String)"myProcess");
        Project project2 = cidrDebugProcess.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProcess.project");
        KtExpression codeFragment = new KtPsiFactory(project2, false).createExpressionCodeFragment(variableName, (PsiElement)blockExpression2).getContentElement();
        KtExpression ktExpression = codeFragment;
        if (!(ktExpression instanceof KtReferenceExpression)) {
            ktExpression = null;
        }
        return (ktReferenceExpression = (referenceExpression = (KtReferenceExpression)ktExpression)) != null && (ktReferenceExpression = ReferenceUtilsKt.getMainReference((KtReferenceExpression)ktReferenceExpression)) != null ? ktReferenceExpression.resolve() : null;
    }

    private final String dropInlinerSuffix(String receivedName) {
        int index2 = StringsKt.lastIndexOf$default((CharSequence)receivedName, (char)'_', (int)0, (boolean)false, (int)6, null);
        if (index2 <= 0) {
            return receivedName;
        }
        CharSequence charSequence = receivedName;
        int n = index2 + 1;
        CharSequence charSequence2 = ((String)charSequence).substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"this as java.lang.String).substring(startIndex)");
        String suffix = charSequence2;
        charSequence = suffix;
        if (charSequence.length() > 0) {
            boolean bl;
            block4: {
                CharSequence $this$all$iv = suffix;
                boolean $i$f$all = false;
                charSequence2 = $this$all$iv;
                for (int i = 0; i < charSequence2.length(); ++i) {
                    char element$iv = charSequence2.charAt(i);
                    char it = element$iv;
                    boolean bl2 = false;
                    char c = it;
                    if (Character.isDigit(c)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
            if (bl) {
                charSequence = receivedName;
                n = 0;
                charSequence2 = ((String)charSequence).substring(n, index2);
                Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                return charSequence2;
            }
        }
        return receivedName;
    }

    @Nullable
    public PsiElement resolveToDeclaration(@Nullable XSourcePosition position, @NotNull LLValue value2) {
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                if (Intrinsics.areEqual((Object)value2.getName(), (Object)KONAN_NAME_FOR_THIS)) break block7;
                CidrDebugProcess cidrDebugProcess = this.myProcess;
                Intrinsics.checkNotNullExpressionValue((Object)cidrDebugProcess, (String)"myProcess");
                DumbService dumbService = DumbService.getInstance((Project)cidrDebugProcess.getProject());
                Intrinsics.checkNotNullExpressionValue((Object)dumbService, (String)"DumbService.getInstance(myProcess.project)");
                if (!dumbService.isDumb()) break block8;
            }
            return null;
        }
        XSourcePosition xSourcePosition = position;
        if (xSourcePosition == null) {
            return null;
        }
        CidrDebugProcess cidrDebugProcess = this.myProcess;
        Intrinsics.checkNotNullExpressionValue((Object)cidrDebugProcess, (String)"myProcess");
        KtBlockExpression ktBlockExpression = Companion.findBlockAtPosition(xSourcePosition, cidrDebugProcess);
        if (ktBlockExpression == null) {
            return null;
        }
        KtBlockExpression blockExpression2 = ktBlockExpression;
        Object[] objectArray = new String[2];
        String string = value2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value.name");
        objectArray[0] = this.dropInlinerSuffix(string);
        String string2 = value2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"value.name");
        objectArray[1] = string2;
        for (String name2 : CollectionsKt.listOf((Object[])objectArray)) {
            PsiElement declaration2;
            if (this.tryResolveToDeclaration(blockExpression2, name2) == null) {
                continue;
            }
            TextRange textRange = declaration2.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"declaration.textRange");
            if (textRange.getStartOffset() > position.getOffset()) continue;
            return declaration2;
        }
        return null;
    }

    public KonanDebuggerTypesHelper(@NotNull CidrDebugProcess process2) {
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        super(process2);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/kotlin/commonNative/debugger/KonanDebuggerTypesHelper$Companion;", "", "()V", "KONAN_NAME_FOR_THIS", "", "findBlockAtPosition", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "kotlin-ultimate.common-native"})
    public static final class Companion {
        @Nullable
        public final KtBlockExpression findBlockAtPosition(@NotNull XSourcePosition position, @NotNull CidrDebugProcess process2) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
            return (KtBlockExpression)PsiTreeUtil.getNonStrictParentOfType((PsiElement)CidrDebuggerTypesHelper.getContextElement((XSourcePosition)position, (Project)process2.getProject()), (Class[])new Class[]{KtBlockExpression.class});
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

