/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.caches.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.analyzer.PlatformAnalysisParameters;
import org.jetbrains.kotlin.analyzer.ResolverForModuleFactory;
import org.jetbrains.kotlin.analyzer.ResolverForProject;
import org.jetbrains.kotlin.builtins.DefaultBuiltIns;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.jvm.JvmBuiltIns;
import org.jetbrains.kotlin.caches.resolve.IdePlatformKindResolution;
import org.jetbrains.kotlin.caches.resolve.JvmLibraryInfo;
import org.jetbrains.kotlin.caches.resolve.JvmPlatformKindResolutionKt;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.context.ProjectContext;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.LibraryInfo;
import org.jetbrains.kotlin.idea.caches.project.SdkInfo;
import org.jetbrains.kotlin.idea.caches.resolve.BuiltInsCacheKey;
import org.jetbrains.kotlin.idea.caches.resolve.KotlinCacheServiceImplKt;
import org.jetbrains.kotlin.idea.configuration.IdeBuiltInsLoadingState;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.impl.JvmIdePlatformKind;
import org.jetbrains.kotlin.resolve.TargetEnvironment;
import org.jetbrains.kotlin.resolve.jvm.JvmPlatformParameters;
import org.jetbrains.kotlin.resolve.jvm.JvmResolverForModuleFactory;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00011B\u0005\u00a2\u0006\u0002\u0010\u0002J:\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J.\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J6\u0010\u0019\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J \u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J$\u0010(\u001a\u00020)2\u0006\u0010\r\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010\u00142\b\u0010,\u001a\u0004\u0018\u00010\u0016H\u0016J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/caches/resolve/JvmPlatformKindResolution;", "Lorg/jetbrains/kotlin/caches/resolve/IdePlatformKindResolution;", "()V", "kind", "Lorg/jetbrains/kotlin/platform/impl/JvmIdePlatformKind;", "getKind", "()Lorg/jetbrains/kotlin/platform/impl/JvmIdePlatformKind;", "libraryKind", "Lcom/intellij/openapi/roots/libraries/PersistentLibraryKind;", "getLibraryKind", "()Lcom/intellij/openapi/roots/libraries/PersistentLibraryKind;", "createBuiltIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "moduleInfo", "Lorg/jetbrains/kotlin/idea/caches/project/IdeaModuleInfo;", "projectContext", "Lorg/jetbrains/kotlin/context/ProjectContext;", "resolverForProject", "Lorg/jetbrains/kotlin/analyzer/ResolverForProject;", "sdkDependency", "Lorg/jetbrains/kotlin/idea/caches/project/SdkInfo;", "stdlibDependency", "Lorg/jetbrains/kotlin/idea/caches/project/LibraryInfo;", "createBuiltInsFromClassLoader", "Lorg/jetbrains/kotlin/builtins/jvm/JvmBuiltIns;", "createBuiltinsFromModuleDependencies", "createLibraryInfo", "", "project", "Lcom/intellij/openapi/project/Project;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "createResolverForModuleFactory", "Lorg/jetbrains/kotlin/analyzer/ResolverForModuleFactory;", "settings", "Lorg/jetbrains/kotlin/analyzer/PlatformAnalysisParameters;", "environment", "Lorg/jetbrains/kotlin/resolve/TargetEnvironment;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getKeyForBuiltIns", "Lorg/jetbrains/kotlin/idea/caches/resolve/BuiltInsCacheKey;", "Lorg/jetbrains/kotlin/analyzer/ModuleInfo;", "sdkInfo", "stdlibInfo", "isLibraryFileForPlatform", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "CacheKeyByBuiltInsDependencies", "kotlin.core"})
public final class JvmPlatformKindResolution
implements IdePlatformKindResolution {
    @Override
    public boolean isLibraryFileForPlatform(@NotNull VirtualFile virtualFile2) {
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        return false;
    }

    @Override
    @NotNull
    public ResolverForModuleFactory createResolverForModuleFactory(@NotNull PlatformAnalysisParameters settings2, @NotNull TargetEnvironment environment, @NotNull TargetPlatform platform2) {
        Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)platform2, (String)"platform");
        return (ResolverForModuleFactory)new JvmResolverForModuleFactory((JvmPlatformParameters)settings2, environment, platform2);
    }

    @Override
    @Nullable
    public PersistentLibraryKind<?> getLibraryKind() {
        return null;
    }

    @Override
    @NotNull
    public List<LibraryInfo> createLibraryInfo(@NotNull Project project2, @NotNull Library library2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)library2, (String)"library");
        return CollectionsKt.listOf((Object)new JvmLibraryInfo(project2, library2));
    }

    @NotNull
    public JvmIdePlatformKind getKind() {
        return JvmIdePlatformKind.INSTANCE;
    }

    @Override
    @NotNull
    public BuiltInsCacheKey getKeyForBuiltIns(@NotNull ModuleInfo moduleInfo, @Nullable SdkInfo sdkInfo, @Nullable LibraryInfo stdlibInfo) {
        Intrinsics.checkNotNullParameter((Object)moduleInfo, (String)"moduleInfo");
        if (IdeBuiltInsLoadingState.INSTANCE.isFromClassLoader() && stdlibInfo != null) {
            JvmPlatformKindResolutionKt.access$getLOG$p().error("Standard library " + stdlibInfo.getDisplayedName() + " provided for built-ins, but loading from dependencies is disabled");
        }
        return sdkInfo != null ? (BuiltInsCacheKey)new CacheKeyByBuiltInsDependencies(sdkInfo.getSdk(), stdlibInfo) : (BuiltInsCacheKey)BuiltInsCacheKey.DefaultBuiltInsKey.INSTANCE;
    }

    @Override
    @NotNull
    public KotlinBuiltIns createBuiltIns(@NotNull IdeaModuleInfo moduleInfo, @NotNull ProjectContext projectContext, @NotNull ResolverForProject<IdeaModuleInfo> resolverForProject, @Nullable SdkInfo sdkDependency, @Nullable LibraryInfo stdlibDependency) {
        Intrinsics.checkNotNullParameter((Object)moduleInfo, (String)"moduleInfo");
        Intrinsics.checkNotNullParameter((Object)projectContext, (String)"projectContext");
        Intrinsics.checkNotNullParameter(resolverForProject, (String)"resolverForProject");
        return sdkDependency == null ? (KotlinBuiltIns)DefaultBuiltIns.Companion.getInstance() : (stdlibDependency == null || moduleInfo instanceof SdkInfo ? (KotlinBuiltIns)this.createBuiltInsFromClassLoader(moduleInfo, projectContext, resolverForProject, sdkDependency) : (KotlinBuiltIns)this.createBuiltinsFromModuleDependencies(moduleInfo, projectContext, resolverForProject, sdkDependency, stdlibDependency));
    }

    private final JvmBuiltIns createBuiltInsFromClassLoader(IdeaModuleInfo moduleInfo, ProjectContext projectContext, ResolverForProject<IdeaModuleInfo> resolverForProject, SdkInfo sdkDependency) {
        JvmBuiltIns jvmBuiltIns;
        JvmBuiltIns $this$apply = jvmBuiltIns = new JvmBuiltIns(projectContext.getStorageManager(), JvmBuiltIns.Kind.FROM_CLASS_LOADER);
        boolean bl = false;
        $this$apply.setPostponedSettingsComputation((Function0)new Function0<JvmBuiltIns.Settings>(resolverForProject, sdkDependency, moduleInfo, projectContext){
            final /* synthetic */ ResolverForProject $resolverForProject$inlined;
            final /* synthetic */ SdkInfo $sdkDependency$inlined;
            final /* synthetic */ IdeaModuleInfo $moduleInfo$inlined;
            final /* synthetic */ ProjectContext $projectContext$inlined;
            {
                this.$resolverForProject$inlined = resolverForProject;
                this.$sdkDependency$inlined = sdkInfo;
                this.$moduleInfo$inlined = ideaModuleInfo;
                this.$projectContext$inlined = projectContext;
                super(0);
            }

            @NotNull
            public final JvmBuiltIns.Settings invoke() {
                ModuleDescriptor sdkDescriptor = this.$resolverForProject$inlined.descriptorForModule((ModuleInfo)this.$sdkDependency$inlined);
                boolean isAdditionalBuiltInsFeaturesSupported = KotlinCacheServiceImplKt.supportsAdditionalBuiltInsMembers(this.$moduleInfo$inlined, this.$projectContext$inlined.getProject());
                return new JvmBuiltIns.Settings(sdkDescriptor, isAdditionalBuiltInsFeaturesSupported);
            }
        });
        return jvmBuiltIns;
    }

    private final JvmBuiltIns createBuiltinsFromModuleDependencies(IdeaModuleInfo moduleInfo, ProjectContext projectContext, ResolverForProject<IdeaModuleInfo> resolverForProject, SdkInfo sdkDependency, LibraryInfo stdlibDependency) {
        JvmBuiltIns jvmBuiltIns;
        if (IdeBuiltInsLoadingState.INSTANCE.isFromClassLoader()) {
            JvmPlatformKindResolutionKt.access$getLOG$p().error("Incorrect attempt to create built-ins from module dependencies");
        }
        JvmBuiltIns $this$apply = jvmBuiltIns = new JvmBuiltIns(projectContext.getStorageManager(), JvmBuiltIns.Kind.FROM_DEPENDENCIES);
        boolean bl = false;
        $this$apply.setPostponedBuiltinsModuleComputation((Function0)new Function0<ModuleDescriptorImpl>(resolverForProject, stdlibDependency, sdkDependency, moduleInfo, projectContext){
            final /* synthetic */ ResolverForProject $resolverForProject$inlined;
            final /* synthetic */ LibraryInfo $stdlibDependency$inlined;
            final /* synthetic */ SdkInfo $sdkDependency$inlined;
            final /* synthetic */ IdeaModuleInfo $moduleInfo$inlined;
            final /* synthetic */ ProjectContext $projectContext$inlined;
            {
                this.$resolverForProject$inlined = resolverForProject;
                this.$stdlibDependency$inlined = libraryInfo;
                this.$sdkDependency$inlined = sdkInfo;
                this.$moduleInfo$inlined = ideaModuleInfo;
                this.$projectContext$inlined = projectContext;
                super(0);
            }

            public final ModuleDescriptorImpl invoke() {
                ModuleDescriptor stdlibDescriptor;
                ModuleDescriptor moduleDescriptor = stdlibDescriptor = this.$resolverForProject$inlined.descriptorForModule((ModuleInfo)this.$stdlibDependency$inlined);
                if (moduleDescriptor == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl");
                }
                return (ModuleDescriptorImpl)moduleDescriptor;
            }
        });
        $this$apply.setPostponedSettingsComputation((Function0)new Function0<JvmBuiltIns.Settings>(resolverForProject, stdlibDependency, sdkDependency, moduleInfo, projectContext){
            final /* synthetic */ ResolverForProject $resolverForProject$inlined;
            final /* synthetic */ LibraryInfo $stdlibDependency$inlined;
            final /* synthetic */ SdkInfo $sdkDependency$inlined;
            final /* synthetic */ IdeaModuleInfo $moduleInfo$inlined;
            final /* synthetic */ ProjectContext $projectContext$inlined;
            {
                this.$resolverForProject$inlined = resolverForProject;
                this.$stdlibDependency$inlined = libraryInfo;
                this.$sdkDependency$inlined = sdkInfo;
                this.$moduleInfo$inlined = ideaModuleInfo;
                this.$projectContext$inlined = projectContext;
                super(0);
            }

            @NotNull
            public final JvmBuiltIns.Settings invoke() {
                ModuleDescriptor sdkDescriptor = this.$resolverForProject$inlined.descriptorForModule((ModuleInfo)this.$sdkDependency$inlined);
                boolean isAdditionalBuiltInsFeaturesSupported = KotlinCacheServiceImplKt.supportsAdditionalBuiltInsMembers(this.$moduleInfo$inlined, this.$projectContext$inlined.getProject());
                return new JvmBuiltIns.Settings(sdkDescriptor, isAdditionalBuiltInsFeaturesSupported);
            }
        });
        return jvmBuiltIns;
    }

    @Override
    @Nullable
    public PackageFragmentProvider createKlibPackageFragmentProvider(@NotNull ModuleInfo moduleInfo, @NotNull StorageManager storageManager, @NotNull LanguageVersionSettings languageVersionSettings2, @NotNull ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter((Object)moduleInfo, (String)"moduleInfo");
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings2, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        return IdePlatformKindResolution.DefaultImpls.createKlibPackageFragmentProvider(this, moduleInfo, storageManager, languageVersionSettings2, moduleDescriptor);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/caches/resolve/JvmPlatformKindResolution$CacheKeyByBuiltInsDependencies;", "Lorg/jetbrains/kotlin/idea/caches/resolve/BuiltInsCacheKey;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "stdlib", "Lorg/jetbrains/kotlin/idea/caches/project/LibraryInfo;", "(Lcom/intellij/openapi/projectRoots/Sdk;Lorg/jetbrains/kotlin/idea/caches/project/LibraryInfo;)V", "getSdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "getStdlib", "()Lorg/jetbrains/kotlin/idea/caches/project/LibraryInfo;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "kotlin.core"})
    public static final class CacheKeyByBuiltInsDependencies
    implements BuiltInsCacheKey {
        @NotNull
        private final Sdk sdk;
        @Nullable
        private final LibraryInfo stdlib;

        @NotNull
        public final Sdk getSdk() {
            return this.sdk;
        }

        @Nullable
        public final LibraryInfo getStdlib() {
            return this.stdlib;
        }

        public CacheKeyByBuiltInsDependencies(@NotNull Sdk sdk2, @Nullable LibraryInfo stdlib2) {
            Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
            this.sdk = sdk2;
            this.stdlib = stdlib2;
        }

        @NotNull
        public final Sdk component1() {
            return this.sdk;
        }

        @Nullable
        public final LibraryInfo component2() {
            return this.stdlib;
        }

        @NotNull
        public final CacheKeyByBuiltInsDependencies copy(@NotNull Sdk sdk2, @Nullable LibraryInfo stdlib2) {
            Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
            return new CacheKeyByBuiltInsDependencies(sdk2, stdlib2);
        }

        public static /* synthetic */ CacheKeyByBuiltInsDependencies copy$default(CacheKeyByBuiltInsDependencies cacheKeyByBuiltInsDependencies, Sdk sdk2, LibraryInfo libraryInfo, int n, Object object) {
            if ((n & 1) != 0) {
                sdk2 = cacheKeyByBuiltInsDependencies.sdk;
            }
            if ((n & 2) != 0) {
                libraryInfo = cacheKeyByBuiltInsDependencies.stdlib;
            }
            return cacheKeyByBuiltInsDependencies.copy(sdk2, libraryInfo);
        }

        @NotNull
        public String toString() {
            return "CacheKeyByBuiltInsDependencies(sdk=" + this.sdk + ", stdlib=" + this.stdlib + ")";
        }

        public int hashCode() {
            Sdk sdk2 = this.sdk;
            LibraryInfo libraryInfo = this.stdlib;
            return (sdk2 != null ? sdk2.hashCode() : 0) * 31 + (libraryInfo != null ? ((Object)libraryInfo).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CacheKeyByBuiltInsDependencies)) break block3;
                    CacheKeyByBuiltInsDependencies cacheKeyByBuiltInsDependencies = (CacheKeyByBuiltInsDependencies)object;
                    if (!Intrinsics.areEqual((Object)this.sdk, (Object)cacheKeyByBuiltInsDependencies.sdk) || !Intrinsics.areEqual((Object)this.stdlib, (Object)cacheKeyByBuiltInsDependencies.stdlib)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

