/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.console;

import com.intellij.execution.configurations.CompositeParameterTargetedValue;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.execution.wsl.target.WslTargetEnvironmentConfiguration;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KotlinIdeaReplBundle;
import org.jetbrains.kotlin.console.KotlinConsoleRunner;
import org.jetbrains.kotlin.idea.artifacts.KotlinArtifacts;
import org.jetbrains.kotlin.idea.artifacts.KotlinClassPath;
import org.jetbrains.kotlin.idea.project.TargetPlatformDetector;
import org.jetbrains.kotlin.idea.util.JavaParametersBuilder;
import org.jetbrains.kotlin.idea.util.projectStructure.ProjectStructureUtilKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JdkPlatform;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\u0007J\u0018\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\bJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\u0007J\u0018\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/console/KotlinConsoleKeeper;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "consoleMap", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/kotlin/console/KotlinConsoleRunner;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getConsoleByVirtualFile", "virtualFile", "putVirtualFileToConsole", "console", "removeConsole", "run", "module", "Lcom/intellij/openapi/module/Module;", "previousCompilationFailed", "", "Companion", "kotlin.repl"})
public final class KotlinConsoleKeeper {
    private final Map<VirtualFile, KotlinConsoleRunner> consoleMap;
    @NotNull
    private final Project project;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @Nullable
    public final KotlinConsoleRunner getConsoleByVirtualFile(@NotNull VirtualFile virtualFile2) {
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        return this.consoleMap.get(virtualFile2);
    }

    @Nullable
    public final KotlinConsoleRunner putVirtualFileToConsole(@NotNull VirtualFile virtualFile2, @NotNull KotlinConsoleRunner console) {
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)((Object)console), (String)"console");
        return this.consoleMap.put(virtualFile2, console);
    }

    @Nullable
    public final KotlinConsoleRunner removeConsole(@NotNull VirtualFile virtualFile2) {
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        return this.consoleMap.remove(virtualFile2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final KotlinConsoleRunner run(@NotNull Module module2, boolean previousCompilationFailed) {
        void environmentRequest;
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        String string = module2.getModuleFilePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"module.moduleFilePath");
        String path2 = string;
        Pair<TargetEnvironmentRequest, TargetedCommandLine> pair = Companion.createReplCommandLine(this.project, module2);
        TargetEnvironmentRequest targetEnvironmentRequest = (TargetEnvironmentRequest)pair.component1();
        TargetedCommandLine cmdLine = (TargetedCommandLine)pair.component2();
        KotlinConsoleRunner consoleRunner = new KotlinConsoleRunner(module2, (TargetEnvironmentRequest)environmentRequest, cmdLine, previousCompilationFailed, this.project, KotlinIdeaReplBundle.message("name.kotlin.repl", new Object[0]), path2);
        consoleRunner.initAndRun();
        return consoleRunner;
    }

    public static /* synthetic */ KotlinConsoleRunner run$default(KotlinConsoleKeeper kotlinConsoleKeeper, Module module2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return kotlinConsoleKeeper.run(module2, bl);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public KotlinConsoleKeeper(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.consoleMap = new ConcurrentHashMap();
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance((String)"#org.jetbrains.kotlin.console");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(\"#org\u2026etbrains.kotlin.console\")");
        LOG = logger;
    }

    @JvmStatic
    @NotNull
    public static final KotlinConsoleKeeper getInstance(@NotNull Project project2) {
        return Companion.getInstance(project2);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/console/KotlinConsoleKeeper$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "createReplCommandLine", "Lkotlin/Pair;", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "Lcom/intellij/execution/target/TargetedCommandLine;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "getInstance", "Lorg/jetbrains/kotlin/console/KotlinConsoleKeeper;", "kotlin.repl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final KotlinConsoleKeeper getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$getServiceSafe$iv = (ComponentManager)project2;
            boolean $i$f$getServiceSafe = false;
            Object object = $this$getServiceSafe$iv.getService(KotlinConsoleKeeper.class);
            if (object == null) {
                String string = "Unable to locate service " + KotlinConsoleKeeper.class.getName();
                throw new IllegalStateException(string.toString());
            }
            return (KotlinConsoleKeeper)object;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Pair<TargetEnvironmentRequest, TargetedCommandLine> createReplCommandLine(@NotNull Project project2, @Nullable Module module2) {
            Path path2;
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            ParametersList parametersList;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            JavaParameters javaParameters = new JavaParametersBuilder(project2).withSdkFrom(module2, true).withMainClassName("org.jetbrains.kotlin.cli.jvm.K2JVMCompiler").build();
            WslTargetEnvironmentConfiguration wslConfiguration = JavaCommandLineState.checkCreateWslConfiguration((Sdk)javaParameters.getJdk());
            WslTargetEnvironmentConfiguration wslTargetEnvironmentConfiguration = wslConfiguration;
            if (wslTargetEnvironmentConfiguration == null || (wslTargetEnvironmentConfiguration = wslTargetEnvironmentConfiguration.createEnvironmentRequest(project2)) == null) {
                wslTargetEnvironmentConfiguration = (TargetEnvironmentRequest)new LocalTargetEnvironmentRequest();
            }
            WslTargetEnvironmentConfiguration request2 = wslTargetEnvironmentConfiguration;
            javaParameters.setCharset((Charset)null);
            ParametersList $this$with = parametersList = javaParameters.getVMParametersList();
            boolean bl = false;
            $this$with.add("-Dkotlin.repl.ideMode=true");
            boolean $i$f$isUnitTestMode = false;
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            if (application.isUnitTestMode()) {
                Sdk sdk2 = javaParameters.getJdk();
                if (sdk2 != null && (sdk2 = ProjectStructureUtilKt.getVersion(sdk2)) != null) {
                    if (sdk2.isAtLeast(JavaSdkVersion.JDK_1_9)) {
                        $this$with.add("--add-opens");
                        $this$with.add("java.base/java.util=ALL-UNNAMED");
                    }
                }
            }
            parametersList = javaParameters.getClassPath();
            Object $this$apply = parametersList;
            boolean bl2 = false;
            List classPath = KotlinClassPath.CompilerWithScripting.computeClassPath();
            Iterable iterable = classPath;
            ParametersList parametersList2 = $this$apply;
            boolean $i$f$map = false;
            void var13_32 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void file2;
                Path path3;
                File file3 = (File)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                Path path4 = path3 = file2.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"path");
                Path path5 = path4;
                String absolutePath = ((Object)path5.toAbsolutePath()).toString();
                path5 = path3;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.notExists(path5, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    LOG.warn("Compiler dependency classpath " + absolutePath + " does not exist");
                }
                String string = absolutePath;
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            parametersList2.addAll((List)collection);
            if (module2 != null) {
                void $this$filterIsInstanceTo$iv$iv$iv;
                List<String> classPath2 = JavaParametersBuilder.Companion.getModuleDependencies(module2);
                $this$apply = classPath2;
                if (!$this$apply.isEmpty()) {
                    javaParameters.setUseDynamicParameters(javaParameters.isDynamicClasspath());
                    Object $this$with2 = $this$apply = javaParameters.getProgramParametersList();
                    boolean bl4 = false;
                    $this$with2.add("-cp");
                    CompositeParameterTargetedValue compositeValue = new CompositeParameterTargetedValue();
                    boolean bl5 = false;
                    for (String s : (Iterable)classPath2) {
                        void index2;
                        if (index2 > 0) {
                            compositeValue.addLocalPart(String.valueOf(request2.getTargetPlatform().getPlatform().pathSeparator));
                        }
                        compositeValue.addPathPart(s);
                        ++index2;
                    }
                    $this$with2.add(compositeValue);
                }
                TargetPlatform targetPlatform = TargetPlatformDetector.getPlatform(module2);
                Intrinsics.checkNotNullExpressionValue((Object)targetPlatform, (String)"TargetPlatformDetector.getPlatform(module)");
                TargetPlatform $this$subplatformsOfType$iv = targetPlatform;
                boolean $i$f$subplatformsOfType = false;
                Iterable $this$filterIsInstance$iv$iv = $this$subplatformsOfType$iv.getComponentPlatforms();
                boolean $i$f$filterIsInstance = false;
                Iterable index2 = $this$filterIsInstance$iv$iv;
                Collection destination$iv$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
                    if (!(element$iv$iv$iv instanceof JdkPlatform)) continue;
                    destination$iv$iv$iv.add(element$iv$iv$iv);
                }
                JdkPlatform jdkPlatform = (JdkPlatform)CollectionsKt.firstOrNull((List)((List)destination$iv$iv$iv));
                if (jdkPlatform != null && (jdkPlatform = jdkPlatform.getTargetVersion()) != null) {
                    TargetPlatform it = $this$subplatformsOfType$iv = jdkPlatform;
                    boolean bl6 = false;
                    ParametersList $this$with3 = $i$f$filterIsInstance = javaParameters.getProgramParametersList();
                    boolean bl7 = false;
                    $this$with3.add("-jvm-target");
                    $this$with3.add(it.getDescription());
                }
            }
            $this$with = parametersList = javaParameters.getProgramParametersList();
            boolean bl8 = false;
            $this$with.add("-kotlin-home");
            Path it = path2 = KotlinArtifacts.Companion.getInstance().getKotlincDirectory().toPath();
            boolean bl9 = false;
            Path path6 = it;
            Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"it");
            Path path7 = path6;
            LinkOption[] $i$f$filterIsInstanceTo = new LinkOption[]{};
            boolean bl10 = Files.exists(path7, Arrays.copyOf($i$f$filterIsInstanceTo, $i$f$filterIsInstanceTo.length));
            if (!bl10) {
                boolean bl11 = false;
                String string = "Kotlinc directory does not exist";
                throw new IllegalStateException(string.toString());
            }
            Path path8 = path2;
            Intrinsics.checkNotNullExpressionValue((Object)path8, (String)"KotlinArtifacts.instance\u2026      }\n                }");
            path2 = path8;
            String kotlinHome = ((Object)path2.toAbsolutePath()).toString();
            $this$with.add(new CompositeParameterTargetedValue().addPathPart(kotlinHome));
            TargetedCommandLine targetedCommandLine = javaParameters.toCommandLine((TargetEnvironmentRequest)request2).build();
            Intrinsics.checkNotNullExpressionValue((Object)targetedCommandLine, (String)"javaParameters.toCommandLine(request).build()");
            return TuplesKt.to((Object)request2, (Object)targetedCommandLine);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

