/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion;

import com.intellij.codeInsight.daemon.impl.actions.AddImportAction;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupActionProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.completion.KotlinIdeaCompletionBundle;
import org.jetbrains.kotlin.idea.core.completion.DeclarationLookupObject;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J&\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/completion/KotlinExcludeFromCompletionLookupActionProvider;", "Lcom/intellij/codeInsight/lookup/LookupActionProvider;", "()V", "addExcludes", "", "consumer", "Lcom/intellij/util/Consumer;", "Lcom/intellij/codeInsight/lookup/LookupElementAction;", "project", "Lcom/intellij/openapi/project/Project;", "fqName", "", "fillActions", "element", "Lcom/intellij/codeInsight/lookup/LookupElement;", "lookup", "Lcom/intellij/codeInsight/lookup/Lookup;", "ExcludeFromCompletionAction", "kotlin.idea"})
public final class KotlinExcludeFromCompletionLookupActionProvider
implements LookupActionProvider {
    public void fillActions(@NotNull LookupElement element3, @NotNull Lookup lookup, @NotNull Consumer<LookupElementAction> consumer2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
        Object object = element3.getObject();
        if (!(object instanceof DeclarationLookupObject)) {
            object = null;
        }
        DeclarationLookupObject declarationLookupObject = (DeclarationLookupObject)object;
        if (declarationLookupObject == null) {
            return;
        }
        DeclarationLookupObject lookupObject = declarationLookupObject;
        PsiFile psiFile2 = lookup.getPsiFile();
        if (psiFile2 == null || (psiFile2 = psiFile2.getProject()) == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"lookup.psiFile?.project ?: return");
        PsiFile project2 = psiFile2;
        FqName fqName2 = lookupObject.getImportableFqName();
        if (fqName2 != null) {
            FqName fqName3;
            FqName it = fqName3 = fqName2;
            boolean bl = false;
            String string = it.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.asString()");
            this.addExcludes(consumer2, (Project)project2, string);
            return;
        }
    }

    private final void addExcludes(Consumer<LookupElementAction> consumer2, Project project2, String fqName2) {
        Iterator iterator = AddImportAction.getAllExcludableStrings((String)fqName2).iterator();
        while (iterator.hasNext()) {
            String s;
            String string = s = (String)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"s");
            consumer2.consume((Object)new ExcludeFromCompletionAction(project2, string));
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/completion/KotlinExcludeFromCompletionLookupActionProvider$ExcludeFromCompletionAction;", "Lcom/intellij/codeInsight/lookup/LookupElementAction;", "project", "Lcom/intellij/openapi/project/Project;", "exclude", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "performLookupAction", "Lcom/intellij/codeInsight/lookup/LookupElementAction$Result;", "kotlin.idea"})
    private static final class ExcludeFromCompletionAction
    extends LookupElementAction {
        private final Project project;
        private final String exclude;

        @NotNull
        public LookupElementAction.Result performLookupAction() {
            AddImportAction.excludeFromImport((Project)this.project, (String)this.exclude);
            LookupElementAction.Result result2 = LookupElementAction.Result.HIDE_LOOKUP;
            Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"Result.HIDE_LOOKUP");
            return result2;
        }

        public ExcludeFromCompletionAction(@NotNull Project project2, @NotNull String exclude) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)exclude, (String)"exclude");
            super(null, KotlinIdeaCompletionBundle.message("exclude.0.from.completion", exclude));
            this.project = project2;
            this.exclude = exclude;
        }
    }
}

