/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration.notifications;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.BrowseNotificationAction;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.KotlinVersionVerbose;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinPluginLayout;
import org.jetbrains.kotlin.idea.configuration.ProjectUtilsKt;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\n\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0002\u001a\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0002\u001a\n\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u0002\u001a \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u000e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0018H\u0007\u001a\u0010\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0003H\u0002\u001a\f\u0010\u001a\u001a\u00020\r*\u00020\u0003H\u0002\u001a\u000e\u0010\u001b\u001a\u0004\u0018\u00010\u0003*\u00020\u000fH\u0002\"\u0010\u0010\u0000\u001a\u00020\u00018\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0002\u001a\u00020\u0001*\u00020\u00038G\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u0015\u0010\u0006\u001a\u00020\u0003*\u00020\u00038G\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\t\u001a\u00020\u0001*\u00020\u00038G\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0005\u00a8\u0006\u001c"}, d2={"LAST_BUNDLED_KOTLIN_COMPILER_VERSION_PROPERTY_NAME", "", "campaignVersion", "Lkotlin/KotlinVersion;", "getCampaignVersion", "(Lkotlin/KotlinVersion;)Ljava/lang/String;", "dropHotfixPart", "getDropHotfixPart", "(Lkotlin/KotlinVersion;)Lkotlin/KotlinVersion;", "whatIsNewPageVersion", "getWhatIsNewPageVersion", "bundledCompilerVersionIfReleased", "checkExternalKotlinCompilerVersion", "", "project", "Lcom/intellij/openapi/project/Project;", "createWhatIsNewAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "kotlinVersion", "findLastBundledCompilerVersion", "newExternalKotlinCompilerShouldBePromoted", "", "bundledCompilerVersion", "externalCompilerVersion", "Lkotlin/Function0;", "whatIsNewPageUrl", "disableNewNotifications", "findExternalCompilerVersion", "kotlin.idea"})
public final class NewExternalKotlinCompilerNotificationKt {
    @VisibleForTesting
    @NotNull
    public static final String LAST_BUNDLED_KOTLIN_COMPILER_VERSION_PROPERTY_NAME = "kotlin.updates.whats.new.shown.for";

    public static final void checkExternalKotlinCompilerVersion(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        KotlinVersion kotlinVersion2 = NewExternalKotlinCompilerNotificationKt.bundledCompilerVersionIfReleased();
        if (kotlinVersion2 == null) {
            return;
        }
        KotlinVersion bundledKotlinCompilerVersion = kotlinVersion2;
        if (!NewExternalKotlinCompilerNotificationKt.newExternalKotlinCompilerShouldBePromoted(bundledKotlinCompilerVersion, (Function0<KotlinVersion>)((Function0)new Function0<KotlinVersion>(project2){

            @Nullable
            public final KotlinVersion invoke() {
                return NewExternalKotlinCompilerNotificationKt.access$findExternalCompilerVersion((Project)this.receiver);
            }
        }))) {
            return;
        }
        ModalityState modalityState$iv = null;
        boolean $i$f$invokeLater = false;
        Application application = ApplicationManager.getApplication();
        Runnable runnable = new Runnable(bundledKotlinCompilerVersion){
            final /* synthetic */ KotlinVersion $bundledKotlinCompilerVersion$inlined;
            {
                this.$bundledKotlinCompilerVersion$inlined = kotlinVersion2;
            }

            public final void run() {
                boolean bl = false;
                NewExternalKotlinCompilerNotificationKt.access$disableNewNotifications(this.$bundledKotlinCompilerVersion$inlined);
            }
        };
        ModalityState modalityState = ModalityState.defaultModalityState();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
        application.invokeLater(runnable, modalityState);
        NotificationGroupManager.getInstance().getNotificationGroup("kotlin.external.compiler.updates").createNotification(KotlinBundle.message("kotlin.external.compiler.updates.notification.content.0", bundledKotlinCompilerVersion), NotificationType.INFORMATION).setSuggestionType(true).addAction(NewExternalKotlinCompilerNotificationKt.createWhatIsNewAction(bundledKotlinCompilerVersion)).setIcon(KotlinIcons.SMALL_LOGO).setImportant(true).notify(project2);
    }

    private static final KotlinVersion findExternalCompilerVersion(Project $this$findExternalCompilerVersion) {
        boolean $i$f$runReadAction = false;
        KotlinVersionVerbose kotlinVersionVerbose = (KotlinVersionVerbose)ApplicationManager.getApplication().runReadAction(new Computable($this$findExternalCompilerVersion){
            final /* synthetic */ Project $this_findExternalCompilerVersion$inlined;
            {
                this.$this_findExternalCompilerVersion$inlined = project2;
            }

            public final T compute() {
                boolean bl = false;
                return (T)ProjectUtilsKt.findAnyExternalKotlinCompilerVersion(this.$this_findExternalCompilerVersion$inlined);
            }
        });
        return kotlinVersionVerbose != null ? kotlinVersionVerbose.getPlainVersion() : null;
    }

    private static final KotlinVersion bundledCompilerVersionIfReleased() {
        KotlinVersionVerbose kotlinVersionVerbose;
        block3: {
            block2: {
                KotlinVersionVerbose kotlinVersionVerbose2;
                String kotlinCompilerVersion = KotlinPluginLayout.Companion.getInstance().getStandaloneCompilerVersion();
                kotlinVersionVerbose = KotlinVersionVerbose.Companion.parse(kotlinCompilerVersion);
                if (kotlinVersionVerbose == null) break block2;
                KotlinVersionVerbose it = kotlinVersionVerbose2 = kotlinVersionVerbose;
                boolean bl = false;
                kotlinVersionVerbose = it.getMilestone() == KotlinVersionVerbose.KotlinVersionMilestone.release ? kotlinVersionVerbose2 : null;
                if (kotlinVersionVerbose != null) break block3;
            }
            return null;
        }
        KotlinVersionVerbose kotlinVersionVerbose3 = kotlinVersionVerbose;
        return kotlinVersionVerbose3.getPlainVersion();
    }

    private static final void disableNewNotifications(KotlinVersion $this$disableNewNotifications) {
        boolean $i$f$runWriteAction = false;
        ApplicationManager.getApplication().runWriteAction(new Computable($this$disableNewNotifications){
            final /* synthetic */ KotlinVersion $this_disableNewNotifications$inlined;
            {
                this.$this_disableNewNotifications$inlined = kotlinVersion2;
            }

            public final T compute() {
                boolean bl = false;
                PropertiesComponent.getInstance().setValue("kotlin.updates.whats.new.shown.for", this.$this_disableNewNotifications$inlined.toString());
                return (T)Unit.INSTANCE;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public static final KotlinVersion getDropHotfixPart(@NotNull KotlinVersion $this$dropHotfixPart) {
        void it;
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$dropHotfixPart, (String)"$this$dropHotfixPart");
        int n2 = n = $this$dropHotfixPart.getPatch() / 10;
        int n3 = $this$dropHotfixPart.getMinor();
        int n4 = $this$dropHotfixPart.getMajor();
        boolean bl = false;
        int n5 = it == true ? 0 : n2;
        int n6 = n5 * 10;
        int n7 = n3;
        int n8 = n4;
        return new KotlinVersion(n8, n7, n6);
    }

    @VisibleForTesting
    public static final boolean newExternalKotlinCompilerShouldBePromoted(@NotNull KotlinVersion bundledCompilerVersion, @NotNull Function0<KotlinVersion> externalCompilerVersion) {
        Intrinsics.checkNotNullParameter((Object)bundledCompilerVersion, (String)"bundledCompilerVersion");
        Intrinsics.checkNotNullParameter(externalCompilerVersion, (String)"externalCompilerVersion");
        KotlinVersion downgradedBundledKotlinCompilerVersion = NewExternalKotlinCompilerNotificationKt.getDropHotfixPart(bundledCompilerVersion);
        KotlinVersion lastBundledVersion = NewExternalKotlinCompilerNotificationKt.findLastBundledCompilerVersion();
        if (lastBundledVersion != null && lastBundledVersion.compareTo(downgradedBundledKotlinCompilerVersion) >= 0) {
            return false;
        }
        KotlinVersion kotlinVersion2 = (KotlinVersion)externalCompilerVersion.invoke();
        if (kotlinVersion2 == null) {
            return false;
        }
        KotlinVersion externalKotlinCompilerVersion = kotlinVersion2;
        return externalKotlinCompilerVersion.compareTo(downgradedBundledKotlinCompilerVersion) < 0;
    }

    private static final KotlinVersion findLastBundledCompilerVersion() {
        boolean $i$f$runReadAction = false;
        String string = (String)ApplicationManager.getApplication().runReadAction(new Computable(){

            public final T compute() {
                boolean bl = false;
                return (T)PropertiesComponent.getInstance().getValue("kotlin.updates.whats.new.shown.for");
            }
        });
        if (string == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"runReadAction {\n        \u2026AME)\n    } ?: return null");
        String lastVersionValue = string;
        KotlinVersionVerbose kotlinVersionVerbose = KotlinVersionVerbose.Companion.parse(lastVersionValue);
        return kotlinVersionVerbose != null ? kotlinVersionVerbose.getPlainVersion() : null;
    }

    private static final AnAction createWhatIsNewAction(KotlinVersion kotlinVersion2) {
        return (AnAction)new BrowseNotificationAction(KotlinBundle.message("kotlin.external.compiler.updates.notification.learn.what.is.new.action", new Object[0]), NewExternalKotlinCompilerNotificationKt.whatIsNewPageUrl(kotlinVersion2));
    }

    private static final String whatIsNewPageUrl(KotlinVersion kotlinVersion2) {
        return "https://kotlinlang.org/docs/whatsnew" + NewExternalKotlinCompilerNotificationKt.getWhatIsNewPageVersion(kotlinVersion2) + ".html?utm_source=ide&utm_medium=release-notification&utm_campaign=" + NewExternalKotlinCompilerNotificationKt.getCampaignVersion(kotlinVersion2) + "-release";
    }

    @VisibleForTesting
    @NotNull
    public static final String getWhatIsNewPageVersion(@NotNull KotlinVersion $this$whatIsNewPageVersion) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$whatIsNewPageVersion, (String)"$this$whatIsNewPageVersion");
        StringBuilder $this$buildString = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$buildString.append($this$whatIsNewPageVersion.getMajor());
        $this$buildString.append($this$whatIsNewPageVersion.getMinor());
        int majorPartOfPath = $this$whatIsNewPageVersion.getPatch() / 10;
        if (majorPartOfPath > 1) {
            $this$buildString.append(majorPartOfPath);
            $this$buildString.append('0');
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @VisibleForTesting
    @NotNull
    public static final String getCampaignVersion(@NotNull KotlinVersion $this$campaignVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$campaignVersion, (String)"$this$campaignVersion");
        return $this$campaignVersion.getMajor() + "-" + $this$campaignVersion.getMinor() + "-" + $this$campaignVersion.getPatch();
    }

    public static final /* synthetic */ KotlinVersion access$findExternalCompilerVersion(Project $this$access_u24findExternalCompilerVersion) {
        return NewExternalKotlinCompilerNotificationKt.findExternalCompilerVersion($this$access_u24findExternalCompilerVersion);
    }

    public static final /* synthetic */ void access$disableNewNotifications(KotlinVersion $this$access_u24disableNewNotifications) {
        NewExternalKotlinCompilerNotificationKt.disableNewNotifications($this$access_u24disableNewNotifications);
    }
}

