/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.formatter;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.formatter.KotlinPackageEntry;
import org.jetbrains.kotlin.idea.core.formatter.KotlinPackageEntryTable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006J\b\u0010\u000f\u001a\u00020\u0000H\u0016J\u0011\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0086\u0002J\u000e\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0000J\u0013\u0010\u0016\u001a\u00020\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\u0011\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u001a\u00a2\u0006\u0002\u0010\u001bJ\u000e\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\tJ\b\u0010\u001e\u001a\u00020\tH\u0016J\u0016\u0010\u001f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\tJ\u0010\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\"H\u0016J\u0006\u0010#\u001a\u00020\rJ\u000e\u0010$\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\tJ\u0016\u0010%\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\tJ\u0010\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020\"H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/idea/core/formatter/KotlinPackageEntryTable;", "Lcom/intellij/openapi/util/JDOMExternalizable;", "", "()V", "entries", "", "Lorg/jetbrains/kotlin/idea/core/formatter/KotlinPackageEntry;", "(Ljava/util/List;)V", "entryCount", "", "getEntryCount", "()I", "addEntry", "", "entry", "clone", "contains", "", "packageName", "", "copyFrom", "packageTable", "equals", "other", "", "getEntries", "", "()[Lorg/jetbrains/kotlin/idea/core/formatter/KotlinPackageEntry;", "getEntryAt", "index", "hashCode", "insertEntryAt", "readExternal", "element", "Lorg/jdom/Element;", "removeEmptyPackages", "removeEntryAt", "setEntryAt", "writeExternal", "parentNode", "kotlin.formatter"})
public final class KotlinPackageEntryTable
implements JDOMExternalizable,
Cloneable {
    private final List<KotlinPackageEntry> entries;

    public final int getEntryCount() {
        return this.entries.size();
    }

    @NotNull
    public KotlinPackageEntryTable clone() {
        KotlinPackageEntryTable clone2 = new KotlinPackageEntryTable();
        clone2.copyFrom(this);
        return clone2;
    }

    public final void copyFrom(@NotNull KotlinPackageEntryTable packageTable) {
        Intrinsics.checkNotNullParameter((Object)packageTable, (String)"packageTable");
        this.entries.clear();
        this.entries.addAll((Collection<KotlinPackageEntry>)packageTable.entries);
    }

    @NotNull
    public final KotlinPackageEntry[] getEntries() {
        Collection $this$toTypedArray$iv = this.entries;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        KotlinPackageEntry[] kotlinPackageEntryArray = thisCollection$iv.toArray(new KotlinPackageEntry[0]);
        if (kotlinPackageEntryArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        return kotlinPackageEntryArray;
    }

    public final void insertEntryAt(@NotNull KotlinPackageEntry entry, int index2) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        this.entries.add(index2, entry);
    }

    public final void removeEntryAt(int index2) {
        this.entries.remove(index2);
    }

    @NotNull
    public final KotlinPackageEntry getEntryAt(int index2) {
        return this.entries.get(index2);
    }

    public final void setEntryAt(@NotNull KotlinPackageEntry entry, int index2) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        this.entries.set(index2, entry);
    }

    public final boolean contains(@NotNull String packageName2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)packageName2, (String)"packageName");
            Iterable $this$any$iv = this.entries;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinPackageEntry it = (KotlinPackageEntry)element$iv;
                    boolean bl2 = false;
                    if (!(!it.isSpecial() && it.matchesPackageName(packageName2))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void removeEmptyPackages() {
        CollectionsKt.removeAll(this.entries, (Function1)removeEmptyPackages.1.INSTANCE);
    }

    public final void addEntry(@NotNull KotlinPackageEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        this.entries.add(entry);
    }

    public void readExternal(@NotNull Element element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        this.entries.clear();
        List list2 = element3.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"element.children");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String packageName2;
            String string;
            String string2;
            Element it = (Element)element$iv;
            boolean bl = false;
            Element element4 = it;
            Intrinsics.checkNotNullExpressionValue((Object)element4, (String)"it");
            if (!Intrinsics.areEqual((Object)element4.getName(), (Object)"package")) continue;
            if (it.getAttributeValue("name") == null) {
                throw (Throwable)new InvalidDataException();
            }
            boolean alias = it.getAttributeValue("alias") != null ? Boolean.parseBoolean(string2) : false;
            boolean withSubpackages = it.getAttributeValue("withSubpackages") != null ? Boolean.parseBoolean(string) : false;
            CharSequence charSequence = packageName2;
            KotlinPackageEntry entry = charSequence.length() == 0 && !alias ? KotlinPackageEntry.ALL_OTHER_IMPORTS_ENTRY : ((charSequence = (CharSequence)packageName2).length() == 0 && alias ? KotlinPackageEntry.ALL_OTHER_ALIAS_IMPORTS_ENTRY : new KotlinPackageEntry(packageName2, withSubpackages));
            this.entries.add(entry);
        }
    }

    public void writeExternal(@NotNull Element parentNode) {
        Intrinsics.checkNotNullParameter((Object)parentNode, (String)"parentNode");
        for (KotlinPackageEntry entry : this.entries) {
            Element element3 = new Element("package");
            parentNode.addContent(element3);
            String name2 = entry.isSpecial() ? "" : entry.getPackageName();
            boolean alias = Intrinsics.areEqual((Object)entry, (Object)KotlinPackageEntry.ALL_OTHER_ALIAS_IMPORTS_ENTRY);
            element3.setAttribute("name", name2);
            element3.setAttribute("alias", String.valueOf(alias));
            element3.setAttribute("withSubpackages", String.valueOf(entry.getWithSubpackages()));
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KotlinPackageEntryTable)) {
            return false;
        }
        if (this.getEntryCount() != ((KotlinPackageEntryTable)other).getEntryCount()) {
            return false;
        }
        int n = 0;
        int n2 = ((Collection)this.entries).size();
        while (n < n2) {
            void i;
            if (Intrinsics.areEqual((Object)this.entries.get((int)i), (Object)((KotlinPackageEntryTable)other).entries.get((int)i)) ^ true) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        KotlinPackageEntry kotlinPackageEntry = (KotlinPackageEntry)CollectionsKt.firstOrNull(this.entries);
        return kotlinPackageEntry != null ? kotlinPackageEntry.hashCode() : 0;
    }

    public KotlinPackageEntryTable(@NotNull List<KotlinPackageEntry> entries) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        this.entries = entries;
    }

    public KotlinPackageEntryTable() {
        this(new ArrayList());
    }
}

