/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.ucache;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.NonClasspathDirectoriesScope;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.ScriptConfigurationManager;
import org.jetbrains.kotlin.idea.core.script.ucache.ScriptClassRootsBuilder;
import org.jetbrains.kotlin.idea.core.script.ucache.ScriptSdks;
import org.jetbrains.kotlin.idea.core.script.ucache.SdkId;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.resolve.ScriptCompilationConfigurationWrapper;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 92\u00020\u0001:\b9:;<=>?@BE\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&J\u0012\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020\u0005H\u0002J\u000e\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020\u000fJ\u0018\u0010,\u001a\u00020-2\u0006\u0010%\u001a\u00020&2\b\u0010.\u001a\u0004\u0018\u00010\u0000J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00040\u00072\u0006\u0010.\u001a\u00020\u0000H\u0002J\u0012\u00100\u001a\u0004\u0018\u00010(2\u0006\u0010+\u001a\u00020\u0004H\u0002J\u0010\u00101\u001a\u0004\u0018\u00010\u00052\u0006\u0010+\u001a\u00020\u0004J\u0010\u00102\u001a\u0004\u0018\u0001032\u0006\u0010+\u001a\u00020\u000fJ\u000e\u00104\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\u000fJ\u0010\u00105\u001a\u0004\u0018\u00010\u001e2\u0006\u0010+\u001a\u00020\u000fJ\u0010\u00106\u001a\u00020\n2\u0006\u0010.\u001a\u00020\u0000H\u0002J\u000e\u00107\u001a\u00020\u00002\u0006\u00108\u001a\u00020\fR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0011R\u0016\u0010\u0019\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0013\u0010\u001d\u001a\u0004\u0018\u00010\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache;", "", "scripts", "", "", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache$LightScriptInfo;", "classes", "", "sources", "customDefinitionsUsed", "", "sdks", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptSdks;", "(Ljava/util/Map;Ljava/util/Set;Ljava/util/Set;ZLorg/jetbrains/kotlin/idea/core/script/ucache/ScriptSdks;)V", "allDependenciesClassFiles", "Lcom/intellij/openapi/vfs/VirtualFile;", "getAllDependenciesClassFiles", "()Ljava/util/Set;", "allDependenciesClassFilesScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "Lorg/jetbrains/annotations/NotNull;", "getAllDependenciesClassFilesScope", "()Lcom/intellij/psi/search/GlobalSearchScope;", "allDependenciesSources", "getAllDependenciesSources", "allDependenciesSourcesScope", "getAllDependenciesSourcesScope", "getCustomDefinitionsUsed", "()Z", "firstScriptSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "getFirstScriptSdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "getSdks", "()Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptSdks;", "builder", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsBuilder;", "project", "Lcom/intellij/openapi/project/Project;", "computeHeavy", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache$HeavyScriptInfo;", "lightScriptInfo", "contains", "file", "diff", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache$Updates;", "old", "getChangedScripts", "getHeavyScriptInfo", "getLightScriptInfo", "getScriptConfiguration", "Lorg/jetbrains/kotlin/scripting/resolve/ScriptCompilationConfigurationWrapper;", "getScriptDependenciesClassFilesScope", "getScriptSdk", "hasNewRoots", "withUpdatedSdks", "newSdks", "Companion", "DirectScriptInfo", "FullUpdate", "HeavyScriptInfo", "IncrementalUpdates", "LightScriptInfo", "NotChanged", "Updates", "kotlin.core"})
public final class ScriptClassRootsCache {
    @NotNull
    private final Set<VirtualFile> allDependenciesClassFiles;
    @NotNull
    private final Set<VirtualFile> allDependenciesSources;
    @NotNull
    private final GlobalSearchScope allDependenciesClassFilesScope;
    @NotNull
    private final GlobalSearchScope allDependenciesSourcesScope;
    private final Map<String, LightScriptInfo> scripts;
    private final Set<String> classes;
    private final Set<String> sources;
    private final boolean customDefinitionsUsed;
    @NotNull
    private final ScriptSdks sdks;
    @NotNull
    private static final ScriptClassRootsCache EMPTY;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final ScriptClassRootsCache withUpdatedSdks(@NotNull ScriptSdks newSdks) {
        Intrinsics.checkNotNullParameter((Object)newSdks, (String)"newSdks");
        return new ScriptClassRootsCache(this.scripts, this.classes, this.sources, this.customDefinitionsUsed, newSdks);
    }

    @NotNull
    public final ScriptClassRootsBuilder builder(@NotNull Project project2) {
        ScriptClassRootsBuilder scriptClassRootsBuilder;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        ScriptClassRootsBuilder builder = scriptClassRootsBuilder = new ScriptClassRootsBuilder(project2, CollectionsKt.toMutableSet((Iterable)this.classes), CollectionsKt.toMutableSet((Iterable)this.sources), MapsKt.toMutableMap(this.scripts));
        boolean bl = false;
        if (this.customDefinitionsUsed) {
            builder.useCustomScriptDefinition();
        }
        builder.getSdks().addAll(this.sdks);
        return scriptClassRootsBuilder;
    }

    @Nullable
    public final LightScriptInfo getLightScriptInfo(@NotNull String file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.scripts.get(file2);
    }

    public final boolean contains(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Map<String, LightScriptInfo> map2 = this.scripts;
        String string = file2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
        String string2 = string;
        return map2.containsKey(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final HeavyScriptInfo getHeavyScriptInfo(String file2) {
        HeavyScriptInfo heavy0;
        LightScriptInfo lightScriptInfo = this.getLightScriptInfo(file2);
        if (lightScriptInfo == null) {
            return null;
        }
        LightScriptInfo lightScriptInfo2 = lightScriptInfo;
        Reference<HeavyScriptInfo> reference2 = lightScriptInfo2.getHeavyCache();
        HeavyScriptInfo heavyScriptInfo = heavy0 = reference2 != null ? reference2.get() : null;
        if (heavy0 != null) {
            return heavy0;
        }
        LightScriptInfo lightScriptInfo3 = lightScriptInfo2;
        synchronized (lightScriptInfo3) {
            block6: {
                HeavyScriptInfo heavy1;
                boolean bl = false;
                Reference<HeavyScriptInfo> reference3 = lightScriptInfo2.getHeavyCache();
                HeavyScriptInfo heavyScriptInfo2 = heavy1 = reference3 != null ? reference3.get() : null;
                if (heavy1 == null) break block6;
                HeavyScriptInfo heavyScriptInfo3 = heavy1;
                return heavyScriptInfo3;
            }
            HeavyScriptInfo heavy2 = this.computeHeavy(lightScriptInfo2);
            lightScriptInfo2.setHeavyCache((Reference<HeavyScriptInfo>)new SoftReference<HeavyScriptInfo>(heavy2));
            HeavyScriptInfo heavyScriptInfo4 = heavy2;
            return heavyScriptInfo4;
        }
    }

    private final HeavyScriptInfo computeHeavy(LightScriptInfo lightScriptInfo) {
        HeavyScriptInfo heavyScriptInfo;
        ScriptCompilationConfigurationWrapper scriptCompilationConfigurationWrapper = lightScriptInfo.buildConfiguration();
        if (scriptCompilationConfigurationWrapper == null) {
            return null;
        }
        ScriptCompilationConfigurationWrapper configuration2 = scriptCompilationConfigurationWrapper;
        List<File> roots2 = configuration2.getDependenciesClassPath();
        File file2 = configuration2.getJavaHome();
        Sdk sdk2 = this.sdks.get(SdkId.Companion.invoke(file2 != null ? file2.toPath() : null));
        if (sdk2 == null) {
            GlobalSearchScope globalSearchScope = NonClasspathDirectoriesScope.compose(ScriptConfigurationManager.Companion.toVfsRoots((Iterable<? extends File>)roots2));
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"compose(toVfsRoots(roots))");
            heavyScriptInfo = new HeavyScriptInfo(configuration2, globalSearchScope, null);
        } else {
            Object[] objectArray = sdk2.getRootProvider().getFiles(OrderRootType.CLASSES);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"sdk.rootProvider.getFiles(OrderRootType.CLASSES)");
            List sdkClasses = ArraysKt.toList((Object[])objectArray);
            GlobalSearchScope globalSearchScope = NonClasspathDirectoriesScope.compose((List)CollectionsKt.plus((Collection)sdkClasses, (Iterable)ScriptConfigurationManager.Companion.toVfsRoots((Iterable<? extends File>)roots2)));
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"compose(sdkClasses + toVfsRoots(roots))");
            heavyScriptInfo = new HeavyScriptInfo(configuration2, globalSearchScope, sdk2);
        }
        return heavyScriptInfo;
    }

    @Nullable
    public final Sdk getFirstScriptSdk() {
        return this.sdks.getFirst();
    }

    @NotNull
    public final Set<VirtualFile> getAllDependenciesClassFiles() {
        return this.allDependenciesClassFiles;
    }

    @NotNull
    public final Set<VirtualFile> getAllDependenciesSources() {
        return this.allDependenciesSources;
    }

    @NotNull
    public final GlobalSearchScope getAllDependenciesClassFilesScope() {
        return this.allDependenciesClassFilesScope;
    }

    @NotNull
    public final GlobalSearchScope getAllDependenciesSourcesScope() {
        return this.allDependenciesSourcesScope;
    }

    @Nullable
    public final ScriptCompilationConfigurationWrapper getScriptConfiguration(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        String string = file2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
        HeavyScriptInfo heavyScriptInfo = this.getHeavyScriptInfo(string);
        return heavyScriptInfo != null ? heavyScriptInfo.getScriptConfiguration() : null;
    }

    @Nullable
    public final Sdk getScriptSdk(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        String string = file2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
        HeavyScriptInfo heavyScriptInfo = this.getHeavyScriptInfo(string);
        return heavyScriptInfo != null ? heavyScriptInfo.getSdk() : null;
    }

    @NotNull
    public final GlobalSearchScope getScriptDependenciesClassFilesScope(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        String string = file2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
        HeavyScriptInfo heavyScriptInfo = this.getHeavyScriptInfo(string);
        if (heavyScriptInfo == null || (heavyScriptInfo = heavyScriptInfo.getClassFilesScope()) == null) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
            heavyScriptInfo = globalSearchScope;
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"GlobalSearchScope.EMPTY_SCOPE");
        }
        return heavyScriptInfo;
    }

    @NotNull
    public final Updates diff(@NotNull Project project2, @Nullable ScriptClassRootsCache old) {
        Updates updates;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        ScriptClassRootsCache scriptClassRootsCache = old;
        if (scriptClassRootsCache == null) {
            updates = new FullUpdate(project2, this);
        } else if (Intrinsics.areEqual((Object)scriptClassRootsCache, (Object)this)) {
            updates = new NotChanged(this);
        } else {
            Collection collection = SetsKt.plus(this.allDependenciesClassFiles, (Iterable)this.allDependenciesSources);
            Collection collection2 = SetsKt.plus(old.allDependenciesClassFiles, (Iterable)old.allDependenciesSources);
            Set<String> set2 = this.getChangedScripts(old);
            boolean bl = old.hasNewRoots(this);
            updates = new IncrementalUpdates(this, this.hasNewRoots(old), collection2, collection, bl, set2);
        }
        return updates;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasNewRoots(ScriptClassRootsCache old) {
        boolean bl;
        VirtualFile it;
        boolean bl2;
        Set oldClassRoots = CollectionsKt.toSet((Iterable)old.allDependenciesClassFiles);
        Set oldSourceRoots = CollectionsKt.toSet((Iterable)old.allDependenciesSources);
        Iterable $this$any$iv = this.allDependenciesClassFiles;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl2 = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                it = (VirtualFile)element$iv;
                boolean bl3 = false;
                if (!oldClassRoots.contains(it)) {
                    return true;
                }
                boolean bl4 = false;
                if (!bl4) continue;
                return true;
            }
            bl2 = false;
        }
        if (bl2) return true;
        $this$any$iv = this.allDependenciesSources;
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            Object element$iv;
            if (!iterator.hasNext()) return false;
            element$iv = iterator.next();
            it = (VirtualFile)element$iv;
            boolean bl5 = false;
            if (!oldSourceRoots.contains(it)) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private final Set<String> getChangedScripts(ScriptClassRootsCache old) {
        Map.Entry<String, LightScriptInfo> it;
        Map.Entry<String, LightScriptInfo> element$iv;
        Set changed = new LinkedHashSet();
        Map<String, LightScriptInfo> $this$forEach$iv = this.scripts;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, LightScriptInfo>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            it = element$iv = iterator.next();
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)old.scripts.get(it.getKey()), (Object)it.getValue()) ^ true)) continue;
            changed.add(it.getKey());
        }
        $this$forEach$iv = old.scripts;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            it = element$iv = iterator.next();
            boolean bl = false;
            Map<String, LightScriptInfo> map2 = this.scripts;
            String string = it.getKey();
            if (map2.containsKey(string)) continue;
            changed.add(it.getKey());
        }
        return changed;
    }

    public final boolean getCustomDefinitionsUsed() {
        return this.customDefinitionsUsed;
    }

    @NotNull
    public final ScriptSdks getSdks() {
        return this.sdks;
    }

    public ScriptClassRootsCache(@NotNull Map<String, ? extends LightScriptInfo> scripts, @NotNull Set<String> classes2, @NotNull Set<String> sources, boolean customDefinitionsUsed, @NotNull ScriptSdks sdks) {
        boolean bl;
        VirtualFile it$iv;
        VirtualFile virtualFile2;
        String it;
        boolean bl2;
        Object element$iv;
        Object element$iv$iv;
        Set result2;
        Set set2;
        Intrinsics.checkNotNullParameter(scripts, (String)"scripts");
        Intrinsics.checkNotNullParameter(classes2, (String)"classes");
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        Intrinsics.checkNotNullParameter((Object)sdks, (String)"sdks");
        this.scripts = scripts;
        this.classes = classes2;
        this.sources = sources;
        this.customDefinitionsUsed = customDefinitionsUsed;
        this.sdks = sdks;
        Set set3 = set2 = (Set)new LinkedHashSet();
        ScriptClassRootsCache scriptClassRootsCache = this;
        boolean bl3 = false;
        result2.addAll((Collection)this.sdks.getNonIndexedClassRoots());
        Iterable $this$mapNotNullTo$iv = this.classes;
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = element$iv$iv = iterator.next();
            bl2 = false;
            it = (String)element$iv;
            boolean bl4 = false;
            Path path2 = Paths.get(it, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(path)");
            if (ScriptConfigurationManager.Companion.classpathEntryToVfs(path2) == null) continue;
            it$iv = virtualFile2;
            bl = false;
            ((Collection)result2).add(it$iv);
        }
        Unit unit = Unit.INSTANCE;
        scriptClassRootsCache.allDependenciesClassFiles = set2;
        result2 = set2 = (Set)new LinkedHashSet();
        scriptClassRootsCache = this;
        boolean bl5 = false;
        result2.addAll((Collection)this.sdks.getNonIndexedSourceRoots());
        $this$mapNotNullTo$iv = this.sources;
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        $i$f$forEach = false;
        iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = element$iv$iv = iterator.next();
            bl2 = false;
            it = (String)element$iv;
            boolean bl6 = false;
            Path path3 = Paths.get(it, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(path)");
            if (ScriptConfigurationManager.Companion.classpathEntryToVfs(path3) == null) continue;
            it$iv = virtualFile2;
            bl = false;
            ((Collection)result2).add(it$iv);
        }
        unit = Unit.INSTANCE;
        scriptClassRootsCache.allDependenciesSources = set2;
        GlobalSearchScope globalSearchScope = NonClasspathDirectoriesScope.compose((List)CollectionsKt.toList((Iterable)this.allDependenciesClassFiles));
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"compose(allDependenciesClassFiles.toList())");
        this.allDependenciesClassFilesScope = globalSearchScope;
        GlobalSearchScope globalSearchScope2 = NonClasspathDirectoriesScope.compose((List)CollectionsKt.toList((Iterable)this.allDependenciesSources));
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope2, (String)"compose(allDependenciesSources.toList())");
        this.allDependenciesSourcesScope = globalSearchScope2;
    }

    static {
        Companion = new Companion(null);
        EMPTY = new ScriptClassRootsCache(MapsKt.emptyMap(), SetsKt.emptySet(), SetsKt.emptySet(), true, new ScriptSdks(MapsKt.emptyMap(), SetsKt.emptySet(), SetsKt.emptySet()));
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH&R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\"\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache$LightScriptInfo;", "", "definition", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "(Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;)V", "getDefinition", "()Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "heavyCache", "Ljava/lang/ref/Reference;", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache$HeavyScriptInfo;", "getHeavyCache", "()Ljava/lang/ref/Reference;", "setHeavyCache", "(Ljava/lang/ref/Reference;)V", "buildConfiguration", "Lorg/jetbrains/kotlin/scripting/resolve/ScriptCompilationConfigurationWrapper;", "kotlin.core"})
    public static abstract class LightScriptInfo {
        @Nullable
        private volatile Reference<HeavyScriptInfo> heavyCache;
        @Nullable
        private final ScriptDefinition definition;

        @Nullable
        public final Reference<HeavyScriptInfo> getHeavyCache() {
            return this.heavyCache;
        }

        public final void setHeavyCache(@Nullable Reference<HeavyScriptInfo> reference2) {
            this.heavyCache = reference2;
        }

        @Nullable
        public abstract ScriptCompilationConfigurationWrapper buildConfiguration();

        @Nullable
        public final ScriptDefinition getDefinition() {
            return this.definition;
        }

        public LightScriptInfo(@Nullable ScriptDefinition definition2) {
            this.definition = definition2;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache$DirectScriptInfo;", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache$LightScriptInfo;", "result", "Lorg/jetbrains/kotlin/scripting/resolve/ScriptCompilationConfigurationWrapper;", "(Lorg/jetbrains/kotlin/scripting/resolve/ScriptCompilationConfigurationWrapper;)V", "getResult", "()Lorg/jetbrains/kotlin/scripting/resolve/ScriptCompilationConfigurationWrapper;", "buildConfiguration", "kotlin.core"})
    public static final class DirectScriptInfo
    extends LightScriptInfo {
        @NotNull
        private final ScriptCompilationConfigurationWrapper result;

        @Override
        @NotNull
        public ScriptCompilationConfigurationWrapper buildConfiguration() {
            return this.result;
        }

        @NotNull
        public final ScriptCompilationConfigurationWrapper getResult() {
            return this.result;
        }

        public DirectScriptInfo(@NotNull ScriptCompilationConfigurationWrapper result2) {
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            super(null);
            this.result = result2;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache$HeavyScriptInfo;", "", "scriptConfiguration", "Lorg/jetbrains/kotlin/scripting/resolve/ScriptCompilationConfigurationWrapper;", "classFilesScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "(Lorg/jetbrains/kotlin/scripting/resolve/ScriptCompilationConfigurationWrapper;Lcom/intellij/psi/search/GlobalSearchScope;Lcom/intellij/openapi/projectRoots/Sdk;)V", "getClassFilesScope", "()Lcom/intellij/psi/search/GlobalSearchScope;", "getScriptConfiguration", "()Lorg/jetbrains/kotlin/scripting/resolve/ScriptCompilationConfigurationWrapper;", "getSdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "kotlin.core"})
    public static final class HeavyScriptInfo {
        @NotNull
        private final ScriptCompilationConfigurationWrapper scriptConfiguration;
        @NotNull
        private final GlobalSearchScope classFilesScope;
        @Nullable
        private final Sdk sdk;

        @NotNull
        public final ScriptCompilationConfigurationWrapper getScriptConfiguration() {
            return this.scriptConfiguration;
        }

        @NotNull
        public final GlobalSearchScope getClassFilesScope() {
            return this.classFilesScope;
        }

        @Nullable
        public final Sdk getSdk() {
            return this.sdk;
        }

        public HeavyScriptInfo(@NotNull ScriptCompilationConfigurationWrapper scriptConfiguration, @NotNull GlobalSearchScope classFilesScope, @Nullable Sdk sdk2) {
            Intrinsics.checkNotNullParameter((Object)scriptConfiguration, (String)"scriptConfiguration");
            Intrinsics.checkNotNullParameter((Object)classFilesScope, (String)"classFilesScope");
            this.scriptConfiguration = scriptConfiguration;
            this.classFilesScope = classFilesScope;
            this.sdk = sdk2;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0012\u0010\f\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\tR\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache$Updates;", "", "cache", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache;", "getCache", "()Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache;", "changed", "", "getChanged", "()Z", "hasNewRoots", "getHasNewRoots", "hasUpdatedScripts", "getHasUpdatedScripts", "newRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getNewRoots", "()Ljava/util/Collection;", "oldRoots", "getOldRoots", "isScriptChanged", "scriptPath", "", "kotlin.core"})
    public static interface Updates {
        @NotNull
        public ScriptClassRootsCache getCache();

        public boolean getChanged();

        public boolean getHasNewRoots();

        @NotNull
        public Collection<VirtualFile> getOldRoots();

        @NotNull
        public Collection<VirtualFile> getNewRoots();

        public boolean getHasUpdatedScripts();

        public boolean isScriptChanged(@NotNull String var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u000f\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\rH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0013R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache$IncrementalUpdates;", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache$Updates;", "cache", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache;", "hasNewRoots", "", "oldRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "newRoots", "hasOldRoots", "updatedScripts", "", "", "(Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache;ZLjava/util/Collection;Ljava/util/Collection;ZLjava/util/Set;)V", "getCache", "()Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache;", "changed", "getChanged", "()Z", "getHasNewRoots", "hasUpdatedScripts", "getHasUpdatedScripts", "getNewRoots", "()Ljava/util/Collection;", "getOldRoots", "isScriptChanged", "scriptPath", "kotlin.core"})
    public static final class IncrementalUpdates
    implements Updates {
        @NotNull
        private final ScriptClassRootsCache cache;
        private final boolean hasNewRoots;
        @NotNull
        private final Collection<VirtualFile> oldRoots;
        @NotNull
        private final Collection<VirtualFile> newRoots;
        private final boolean hasOldRoots;
        private final Set<String> updatedScripts;

        @Override
        public boolean getHasUpdatedScripts() {
            Collection collection = this.updatedScripts;
            return !collection.isEmpty();
        }

        @Override
        public boolean isScriptChanged(@NotNull String scriptPath) {
            Intrinsics.checkNotNullParameter((Object)scriptPath, (String)"scriptPath");
            return this.updatedScripts.contains(scriptPath);
        }

        @Override
        public boolean getChanged() {
            Collection collection;
            return this.getHasNewRoots() || !(collection = (Collection)this.updatedScripts).isEmpty() || this.hasOldRoots;
        }

        @Override
        @NotNull
        public ScriptClassRootsCache getCache() {
            return this.cache;
        }

        @Override
        public boolean getHasNewRoots() {
            return this.hasNewRoots;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getOldRoots() {
            return this.oldRoots;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getNewRoots() {
            return this.newRoots;
        }

        public IncrementalUpdates(@NotNull ScriptClassRootsCache cache2, boolean hasNewRoots, @NotNull Collection<? extends VirtualFile> oldRoots, @NotNull Collection<? extends VirtualFile> newRoots, boolean hasOldRoots, @NotNull Set<String> updatedScripts) {
            Intrinsics.checkNotNullParameter((Object)cache2, (String)"cache");
            Intrinsics.checkNotNullParameter(oldRoots, (String)"oldRoots");
            Intrinsics.checkNotNullParameter(newRoots, (String)"newRoots");
            Intrinsics.checkNotNullParameter(updatedScripts, (String)"updatedScripts");
            this.cache = cache2;
            this.hasNewRoots = hasNewRoots;
            this.oldRoots = oldRoots;
            this.newRoots = newRoots;
            this.hasOldRoots = hasOldRoots;
            this.updatedScripts = updatedScripts;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache$FullUpdate;", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache$Updates;", "project", "Lcom/intellij/openapi/project/Project;", "cache", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache;)V", "getCache", "()Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache;", "changed", "", "getChanged", "()Z", "hasNewRoots", "getHasNewRoots", "hasUpdatedScripts", "getHasUpdatedScripts", "newRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getNewRoots", "()Ljava/util/Collection;", "oldRoots", "getOldRoots", "isScriptChanged", "scriptPath", "", "kotlin.core"})
    public static final class FullUpdate
    implements Updates {
        @NotNull
        private final Collection<VirtualFile> oldRoots;
        private final Project project;
        @NotNull
        private final ScriptClassRootsCache cache;

        @Override
        public boolean getChanged() {
            return true;
        }

        @Override
        public boolean getHasUpdatedScripts() {
            return true;
        }

        @Override
        public boolean isScriptChanged(@NotNull String scriptPath) {
            Intrinsics.checkNotNullParameter((Object)scriptPath, (String)"scriptPath");
            return true;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getOldRoots() {
            return this.oldRoots;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getNewRoots() {
            return SetsKt.plus(this.getCache().getAllDependenciesClassFiles(), (Iterable)this.getCache().getAllDependenciesSources());
        }

        @Override
        public boolean getHasNewRoots() {
            Collection collection = this.getCache().getAllDependenciesClassFiles();
            return !collection.isEmpty() || !(collection = (Collection)this.getCache().getAllDependenciesSources()).isEmpty();
        }

        @Override
        @NotNull
        public ScriptClassRootsCache getCache() {
            return this.cache;
        }

        public FullUpdate(@NotNull Project project2, @NotNull ScriptClassRootsCache cache2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)cache2, (String)"cache");
            this.project = project2;
            this.cache = cache2;
            this.oldRoots = CollectionsKt.emptyList();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\nR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache$NotChanged;", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache$Updates;", "cache", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache;", "(Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache;)V", "getCache", "()Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache;", "changed", "", "getChanged", "()Z", "hasNewRoots", "getHasNewRoots", "hasUpdatedScripts", "getHasUpdatedScripts", "newRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getNewRoots", "()Ljava/util/Collection;", "oldRoots", "getOldRoots", "isScriptChanged", "scriptPath", "", "kotlin.core"})
    public static final class NotChanged
    implements Updates {
        @NotNull
        private final Collection<VirtualFile> oldRoots;
        @NotNull
        private final Collection<VirtualFile> newRoots;
        @NotNull
        private final ScriptClassRootsCache cache;

        @Override
        public boolean getChanged() {
            return false;
        }

        @Override
        public boolean getHasNewRoots() {
            return false;
        }

        @Override
        public boolean getHasUpdatedScripts() {
            return false;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getOldRoots() {
            return this.oldRoots;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getNewRoots() {
            return this.newRoots;
        }

        @Override
        public boolean isScriptChanged(@NotNull String scriptPath) {
            Intrinsics.checkNotNullParameter((Object)scriptPath, (String)"scriptPath");
            return false;
        }

        @Override
        @NotNull
        public ScriptClassRootsCache getCache() {
            return this.cache;
        }

        public NotChanged(@NotNull ScriptClassRootsCache cache2) {
            Intrinsics.checkNotNullParameter((Object)cache2, (String)"cache");
            this.cache = cache2;
            this.oldRoots = CollectionsKt.emptyList();
            this.newRoots = CollectionsKt.emptyList();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache$Companion;", "", "()V", "EMPTY", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache;", "getEMPTY", "()Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache;", "kotlin.core"})
    public static final class Companion {
        @NotNull
        public final ScriptClassRootsCache getEMPTY() {
            return EMPTY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

