/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.jdi.VirtualMachineProxy;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.TypeComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.KotlinPositionManagerKt;
import org.jetbrains.kotlin.idea.debugger.SafeUtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\"\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\f\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\t\u001a\u0012\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b*\u00020\rH\u0002\u001a\u001e\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00100\u000f*\u00020\rH\u0000\u001a\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\f2\u0006\u0010\u0013\u001a\u00020\bH\u0002\u00a8\u0006\u0014"}, d2={"findTargetClasses", "", "Lcom/sun/jdi/ReferenceType;", "Lcom/intellij/debugger/engine/DebugProcess;", "outerClass", "lineAt", "", "getClassName", "", "Lcom/sun/jdi/Location;", "getInlineFunctionLocalVariables", "Lkotlin/sequences/Sequence;", "Lcom/sun/jdi/LocalVariable;", "Lcom/sun/jdi/Method;", "getInlineFunctionNamesAndBorders", "", "Lkotlin/ranges/ClosedRange;", "isInlineFunctionLocalVariable", "", "methodName", "kotlin.jvm-debugger.core"})
public final class KotlinPositionManagerKt {
    @NotNull
    public static final Map<LocalVariable, ClosedRange<Location>> getInlineFunctionNamesAndBorders(@NotNull Method $this$getInlineFunctionNamesAndBorders) {
        Intrinsics.checkNotNullParameter((Object)$this$getInlineFunctionNamesAndBorders, (String)"$this$getInlineFunctionNamesAndBorders");
        return MapsKt.toMap((Sequence)SequencesKt.mapNotNull(KotlinPositionManagerKt.getInlineFunctionLocalVariables($this$getInlineFunctionNamesAndBorders), (Function1)getInlineFunctionNamesAndBorders.1.INSTANCE));
    }

    private static final Sequence<LocalVariable> getInlineFunctionLocalVariables(Method $this$getInlineFunctionLocalVariables) {
        List<LocalVariable> list2 = SafeUtilKt.safeVariables($this$getInlineFunctionLocalVariables);
        if (list2 == null) {
            return SequencesKt.emptySequence();
        }
        List<LocalVariable> localVariables = list2;
        return SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)localVariables), (Function1)((Function1)new Function1<LocalVariable, Boolean>($this$getInlineFunctionLocalVariables){
            final /* synthetic */ Method $this_getInlineFunctionLocalVariables;

            public final boolean invoke(@NotNull LocalVariable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = this.$this_getInlineFunctionLocalVariables.name();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name()");
                return KotlinPositionManagerKt.access$isInlineFunctionLocalVariable(it, string);
            }
            {
                this.$this_getInlineFunctionLocalVariables = method;
                super(1);
            }
        }));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isInlineFunctionLocalVariable(LocalVariable $this$isInlineFunctionLocalVariable, String methodName2) {
        String string = $this$isInlineFunctionLocalVariable.name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name()");
        if (!StringsKt.startsWith$default((String)string, (String)"$i$f$", (boolean)false, (int)2, null)) return false;
        String string2 = $this$isInlineFunctionLocalVariable.name();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name()");
        if (!(Intrinsics.areEqual((Object)StringsKt.substringAfter$default((String)string2, (String)"$i$f$", null, (int)2, null), (Object)methodName2) ^ true)) return false;
        return true;
    }

    @Nullable
    public static final String getClassName(@NotNull Location $this$getClassName) {
        Intrinsics.checkNotNullParameter((Object)$this$getClassName, (String)"$this$getClassName");
        String string = $this$getClassName.declaringType().name();
        if (string == null) {
            return null;
        }
        String currentLocationFqName = string;
        JvmClassName jvmClassName = JvmClassName.byFqNameWithoutInnerClasses((FqName)new FqName(currentLocationFqName));
        Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"JvmClassName.byFqNameWit\u2026e(currentLocationFqName))");
        String string2 = jvmClassName.getInternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"JvmClassName.byFqNameWit\u2026tionFqName)).internalName");
        return StringsKt.replace$default((String)string2, (char)'/', (char)'.', (boolean)false, (int)4, null);
    }

    private static final List<ReferenceType> findTargetClasses(DebugProcess $this$findTargetClasses, ReferenceType outerClass, int lineAt) {
        VirtualMachineProxy vmProxy = $this$findTargetClasses.getVirtualMachineProxy();
        try {
            if (!outerClass.isPrepared()) {
                return CollectionsKt.emptyList();
            }
        }
        catch (ObjectCollectedException e) {
            return CollectionsKt.emptyList();
        }
        ArrayList targetClasses = new ArrayList(1);
        try {
            Iterable iterable;
            for (Location location2 : SafeUtilKt.safeAllLineLocations(outerClass)) {
                Method method;
                int locationLine = location2.lineNumber() - 1;
                if (locationLine < 0 || lineAt != locationLine || (method = location2.method()) == null || DebuggerUtils.isSynthetic((TypeComponent)method) || method.isBridge()) continue;
                iterable = targetClasses;
                iterable.add(outerClass);
                break;
            }
            List nestedTypes = vmProxy.nestedTypes(outerClass);
            for (ReferenceType nested : nestedTypes) {
                Collection collection = targetClasses;
                ReferenceType referenceType = nested;
                Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"nested");
                iterable = KotlinPositionManagerKt.findTargetClasses($this$findTargetClasses, referenceType, lineAt);
                CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        return targetClasses;
    }

    public static final /* synthetic */ Sequence access$getInlineFunctionLocalVariables(Method $this$access_u24getInlineFunctionLocalVariables) {
        return KotlinPositionManagerKt.getInlineFunctionLocalVariables($this$access_u24getInlineFunctionLocalVariables);
    }

    public static final /* synthetic */ List access$findTargetClasses(DebugProcess $this$access_u24findTargetClasses, ReferenceType outerClass, int lineAt) {
        return KotlinPositionManagerKt.findTargetClasses($this$access_u24findTargetClasses, outerClass, lineAt);
    }

    public static final /* synthetic */ boolean access$isInlineFunctionLocalVariable(LocalVariable $this$access_u24isInlineFunctionLocalVariable, String methodName2) {
        return KotlinPositionManagerKt.isInlineFunctionLocalVariable($this$access_u24isInlineFunctionLocalVariable, methodName2);
    }
}

